/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class StandardError {
    private StandardError() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reportNativeException(AbstractNativeRunner abstractNativeRunner, Throwable throwable) {
        Context context = CurrentContext.CONTEXT;
        Channel channel = context.getFilesState().getChannel(2);
        if (channel == null) return;
        PrintStream printStream = new PrintStream(channel.newOutputStream(), true);
        if (throwable instanceof Fail.Exception) {
            String string = Misc.convertException(((Fail.Exception)throwable).asValue(), null);
            printStream.println("Fatal error: exception " + string);
            if (!context.getCodeState().isBacktraceActive()) return;
            abstractNativeRunner.printExceptionBacktrace(printStream);
            return;
        }
        if (throwable instanceof Fatal.Exception) {
            printStream.println(((Fatal.Exception)throwable).getMessage());
            return;
        }
        printStream.println(throwable.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void reportBytecodeException(ByteCodeRunner byteCodeRunner, Throwable throwable) throws OCamlJavaException {
        String string;
        PrintStream printStream;
        ByteArrayOutputStream byteArrayOutputStream;
        block11: {
            block12: {
                String string2;
                block10: {
                    Context context = CurrentContext.CONTEXT;
                    Channel channel = context.getFilesState().getChannel(2);
                    if (channel != null && channel.isOutputChannel()) {
                        byteArrayOutputStream = null;
                        printStream = new PrintStream(channel.newOutputStream(), true);
                    } else {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        printStream = new PrintStream(byteArrayOutputStream, true);
                    }
                    if (!(throwable instanceof Fail.Exception)) break block10;
                    CodeState codeState = context.getCodeState();
                    Value value = codeState.getGlobalData();
                    String string3 = Misc.convertException(((Fail.Exception)throwable).asValue(value), value);
                    printStream.println("Fatal error: exception " + string3);
                    if (!codeState.isBacktraceActive() || context.getDebuggerState().isDebuggerInUse()) break block11;
                    break block12;
                }
                if (throwable instanceof Fatal.Exception) {
                    printStream.println(((Fatal.Exception)throwable).getMessage());
                    if (byteArrayOutputStream == null) {
                        printStream.close();
                    }
                } else {
                    String string4;
                    printStream.println(throwable.toString());
                    if (byteArrayOutputStream == null) {
                        printStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        string4 = byteArrayOutputStream.toString();
                        throw new OCamlJavaException(string4, throwable);
                    }
                    string4 = "internal error";
                    throw new OCamlJavaException(string4, throwable);
                }
                if (byteArrayOutputStream != null) {
                    string2 = byteArrayOutputStream.toString();
                    throw new OCamlJavaException(string2, throwable);
                }
                string2 = "fatal error";
                throw new OCamlJavaException(string2, throwable);
            }
            byteCodeRunner.printExceptionBacktrace(printStream);
        }
        if (byteArrayOutputStream == null) {
            printStream.close();
        }
        if (byteArrayOutputStream != null) {
            string = byteArrayOutputStream.toString();
            throw new OCamlJavaException(string, throwable);
        }
        string = "program exception";
        throw new OCamlJavaException(string, throwable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reportThreadException(Thread thread, Throwable throwable) {
        PrintStream printStream;
        block2: {
            block3: {
                block1: {
                    Channel channel = CurrentContext.FILES_STATE.getChannel(2);
                    if (channel == null) break block1;
                    printStream = new PrintStream(channel.newOutputStream(), true);
                    printStream.printf("Thread '%s' raised an exception: ", thread.getName());
                    if (!(throwable instanceof Fail.Exception)) break block2;
                    break block3;
                }
                return;
            }
            Value value = ((Fail.Exception)throwable).asValue();
            printStream.println(Misc.convertException(value, null));
            return;
        }
        printStream.println(throwable.getClass().getName());
    }
}

