/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Weak", source="byterun/weak.c")
public final class Weak {
    private static final Value NONE = Value.ZERO;
    private static final int SOME_TAG = 0;

    private Weak() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a Weak.t")
    public static Value caml_weak_create(Value value) throws Fail.Exception {
        long l = value.asLong() + 1L;
        if (l <= 0L || l > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Weak.create");
        }
        return Value.createWeakBlock(l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int", "'a option"}, returnType="unit")
    public static Value caml_weak_set(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong() + 1L;
        if (l < 1L || l >= value.sizeWeakValues()) {
            Fail.invalidArgument("Weak.set");
            return Value.UNIT;
        }
        value.setWeak(l, null);
        if (!value3.isBlock()) return Value.UNIT;
        assert (value3.sizeValues() == 1L) : "invalid el";
        value.setWeak(l, value3.get0());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="'a option")
    public static Value caml_weak_get(Value value, Value value2) throws Fail.Exception {
        Value value3;
        long l = value2.asLong() + 1L;
        if (l < 1L || l >= value.sizeWeakValues()) {
            Fail.invalidArgument("Weak.get");
        }
        if ((value3 = value.getWeak(l)) == null) {
            return NONE;
        }
        return Value.createBlock(0, value3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="'a option")
    public static Value caml_weak_get_copy(Value value, Value value2) throws Fail.Exception {
        Value value3;
        long l;
        Value value4;
        Value value5;
        block7: {
            block5: {
                int n;
                block6: {
                    block4: {
                        long l2 = value2.asLong() + 1L;
                        if (l2 < 1L || l2 >= value.sizeWeakValues()) {
                            Fail.invalidArgument("Weak.get");
                        }
                        if ((value5 = value.getWeak(l2)) == null) {
                            return NONE;
                        }
                        if (!value5.isBlock()) break block4;
                        n = value5.getTag();
                        if (n >= 251) break block5;
                        break block6;
                    }
                    value4 = value5;
                    return Value.createBlock(0, value4);
                }
                l = value5.sizeValues();
                value3 = Value.createBlock(n, l);
                break block7;
            }
            value4 = value5.duplicate();
            return Value.createBlock(0, value4);
        }
        for (long i = 0L; i < l; ++i) {
            value3.set(i, value5.get(i));
        }
        value4 = value3;
        return Value.createBlock(0, value4);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int"}, returnType="bool")
    public static Value caml_weak_check(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong() + 1L;
        if (l < 1L || l >= value.sizeWeakValues()) {
            Fail.invalidArgument("Weak.get");
        }
        return value.getWeak(l) != null ? Value.TRUE : Value.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a Weak.t", "int", "'a Weak.t", "int", "int"}, returnType="unit")
    public static Value caml_weak_blit(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception {
        long l = value2.asLong() + 1L;
        long l2 = value4.asLong() + 1L;
        long l3 = value5.asLong();
        if (l < 1L || l + l3 > value.sizeWeakValues()) {
            Fail.invalidArgument("Weak.blit");
        }
        if (l2 < 1L || l2 + l3 > value3.sizeWeakValues()) {
            Fail.invalidArgument("Weak.blit");
        }
        if (l2 >= l) {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value3.setWeak(l2 + i, value.getWeak(l + i));
            }
            return Value.UNIT;
        }
        for (long i = 0L; i < l3; ++i) {
            value3.setWeak(l2 + i, value.getWeak(l + i));
        }
        return Value.UNIT;
    }
}

