/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.gui;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.ocamljava.runtime.util.EncodingUtils;

final class CopyThread
extends Thread {
    private static final int BUFFER_SIZE = 65536;
    private final InputStream source;
    private final JTextArea destination;
    private final JComponent toRepaint;

    CopyThread(InputStream inputStream, JTextArea jTextArea, JComponent jComponent) {
        assert (inputStream != null) : "null src";
        assert (jTextArea != null) : "null dst";
        assert (jComponent != null) : "null tr";
        this.source = inputStream;
        this.destination = jTextArea;
        this.toRepaint = jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int n;
        byte[] byArray;
        try {
            byArray = new byte[65536];
            n = this.source.read(byArray);
        }
        catch (IOException iOException) {
            return;
        }
        while (n != -1) {
            JTextArea jTextArea = this.destination;
            synchronized (jTextArea) {
                this.destination.append(EncodingUtils.convertBytesToString(byArray, 0, n));
                try {
                    int n2 = this.destination.getDocument().getLength();
                    int n3 = this.destination.getLineOfOffset(n2);
                    int n4 = this.destination.getLineStartOffset(n3);
                    this.destination.setCaretPosition(n4);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.toRepaint.repaint();
            n = this.source.read(byArray);
        }
    }
}

