/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Instructions;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.LocInfo;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.ValueStack;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

public final class ByteCodeRunner
extends AbstractCodeRunner
implements Instructions {
    private final Interpreter interpreter;
    private ValueStack stack;
    private Value env;
    private Value result;
    private Throwable exception;
    private final List<Integer> backtraceBuffer;
    private Value backtraceLastException;

    public ByteCodeRunner(Interpreter interpreter, Value value, boolean bl) {
        super(interpreter.getContext());
        assert (interpreter != null) : "null interp";
        this.interpreter = interpreter;
        ByteCodeParameters byteCodeParameters = (ByteCodeParameters)this.context.getParameters();
        this.stack = new ValueStack(bl ? byteCodeParameters.getInitStackSize() : byteCodeParameters.getInitStackSize() / 4);
        this.threadStatus = value;
        this.env = null;
        this.backtraceBuffer = new LinkedList<Integer>();
        this.backtraceLastException = Value.UNIT;
    }

    @Override
    public void clearBacktraceInfo() {
        this.backtraceBuffer.clear();
    }

    @Override
    public CodeRunner createNewThread(Value value) {
        return new ByteCodeRunner(this.interpreter, value, false);
    }

    @Override
    public Value callback(Value value, Value ... valueArray) throws Fail.Exception, Fatal.Exception, OCamlJavaException, FalseExit {
        Throwable throwable;
        assert (value != null) : "null closure";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Thread thread = Thread.currentThread();
        boolean bl = thread instanceof OCamlJavaThread;
        if (!bl) {
            this.context.getThreadsState().addAdditionalThread(thread);
        }
        ByteCodeRunner byteCodeRunner = new ByteCodeRunner(this.interpreter, null, false);
        byteCodeRunner.setup(value, valueArray);
        byteCodeRunner.run();
        if (!bl) {
            this.context.getThreadsState().removeAdditionalThread(thread);
        }
        if ((throwable = byteCodeRunner.getException()) != null) {
            if (throwable instanceof Fail.Exception) {
                throw (Fail.Exception)throwable;
            }
            if (throwable instanceof Fatal.Exception) {
                throw (Fatal.Exception)throwable;
            }
            if (byteCodeRunner.exception instanceof FalseExit) {
                AtExit.execute(this);
                throw (FalseExit)byteCodeRunner.exception;
            }
        } else {
            return byteCodeRunner.getResult();
        }
        Fatal.raise("error in callback: " + byteCodeRunner.exception);
        return Value.UNIT;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public void resizeStack(int n) throws Fail.Exception {
        block4: {
            ByteCodeParameters byteCodeParameters = (ByteCodeParameters)this.context.getParameters();
            if (n > byteCodeParameters.getMaxStackSize()) {
                Fail.raiseStackOverflow();
            }
            int n2 = this.stack.maxSize();
            if (n2 >= n) break block4;
            try {
                ValueStack valueStack = new ValueStack(n);
                valueStack.pushSlice(this.stack.popSlice(this.stack.size()));
                this.stack = valueStack;
            }
            catch (Throwable throwable) {
                Fail.raiseStackOverflow();
            }
        }
    }

    public Value getEnv() {
        return this.env;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.exception = null;
        this.result = null;
        try {
            this.result = this.interprete(this.closure, this.args);
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
        if (this.threadStatus == null) return;
        ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
    }

    Throwable getException() {
        return this.exception;
    }

    public Value getResult() {
        return this.result;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value interprete(Value var1_1, Value ... var2_2) throws Fail.Exception, Fatal.Exception, OCamlJavaException {
        var3_3 = Value.UNIT;
        var4_4 = this.context.getCodeState();
        this.env = var4_4.getAtom(0);
        var5_5 = 0;
        var6_6 = -1;
        this.stack.pop(this.stack.size());
        if (var1_1 != null) {
            this.stack.push(var1_1);
            this.stack.push(Value.ZERO);
            this.stack.push(Value.UNIT);
            this.stack.push(Value.createCodeOffset(var4_4.getCallbackTail()));
            var8_7 = var2_2.length;
            for (var9_9 = var8_7 - 1; var9_9 >= 0; --var9_9) {
                this.stack.push(var2_2[var9_9]);
            }
        } else {
            var7_11 = 0;
lbl18:
            // 2 sources

            while (true) {
                Debugger.handleEvent(this, Debugger.EventKind.PROGRAM_START);
                break;
            }
        }
        var3_3 = this.stack.peek(var8_7 + 3);
        var5_5 = var8_7 - 1;
        var7_11 = (int)var3_3.getCode();
        this.env = var3_3;
        ** while (true)
        catch (FalseExit var8_8) {
            return Value.createLong(var8_8.getExitCode());
        }
        var8_7 = 0;
        var9_10 = null;
        var10_12 = null;
        block170: while (true) {
            var9_10 = null;
            var11_13 /* !! */  = var4_4.getCode();
            var12_17 = var4_4.getDispatcher();
            var10_12 = var4_4.getGlobalData();
            var13_18 = var8_7 != 0 ? var4_4.getSavedCode()[var7_11++] : var11_13 /* !! */ [var7_11++];
            var8_7 = 0;
            cfr_temp_0 = -2147483648;
            block171: do {
                switch (cfr_temp_0 == -2147483648 ? var13_18 : cfr_temp_0) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        var3_3 = this.stack.peek(var13_18 - 0);
                        continue block170;
                    }
                    case 8: {
                        var3_3 = this.stack.peek(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 9: 
                    case 10: {
                        this.stack.push(var3_3);
                        continue block170;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.stack.push(var3_3);
                        var3_3 = this.stack.peek(var13_18 - 11 + 1);
                        continue block170;
                    }
                    case 18: {
                        this.stack.push(var3_3);
                        var3_3 = this.stack.peek(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 19: {
                        this.stack.pop(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 20: {
                        this.stack.assign(var11_13 /* !! */ [var7_11++], var3_3);
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 21: {
                        var3_3 = this.env.get1();
                        continue block170;
                    }
                    case 22: {
                        var3_3 = this.env.get2();
                        continue block170;
                    }
                    case 23: {
                        var3_3 = this.env.get3();
                        continue block170;
                    }
                    case 24: {
                        var3_3 = this.env.get4();
                        continue block170;
                    }
                    case 25: {
                        var3_3 = this.env.get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 26: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.get1();
                        continue block170;
                    }
                    case 27: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.get2();
                        continue block170;
                    }
                    case 28: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.get3();
                        continue block170;
                    }
                    case 29: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.get4();
                        continue block170;
                    }
                    case 30: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 31: {
                        this.stack.push(Value.createLong(var5_5));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(var7_11 + var11_13 /* !! */ [var7_11++]));
                        continue block170;
                    }
                    case 32: {
                        var5_5 = var11_13 /* !! */ [var7_11] - 1;
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                    }
                    case 92: {
                        if (!Thread.interrupted()) ** GOTO lbl815
                        var11_13 /* !! */  = (int[])this.context.getSignalsState().getAndClearAsyncException();
                        if (var11_13 /* !! */  == null || var11_13 /* !! */  instanceof FalseExit) return var3_3;
                        var9_10 = (Fail.Exception)var11_13 /* !! */ ;
                        ** GOTO lbl-1000
                    }
                    case 33: {
                        this.stack.inject(1, Value.createLong(var5_5), this.env, Value.createCodeOffset(var7_11));
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        var5_5 = 0;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 34: {
                        this.stack.inject(2, Value.createLong(var5_5), this.env, Value.createCodeOffset(var7_11));
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        var5_5 = 1;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 35: {
                        this.stack.inject(3, Value.createLong(var5_5), this.env, Value.createCodeOffset(var7_11));
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        var5_5 = 2;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 36: {
                        var14_19 = var11_13 /* !! */ [var7_11++];
                        var15_35 = var11_13 /* !! */ [var7_11];
                        this.stack.slide(var14_19, var15_35 - var14_19);
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        var5_5 += var14_19 - 1;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 37: {
                        this.stack.slide(1, var11_13 /* !! */ [var7_11] - 1);
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 38: {
                        this.stack.slide(2, var11_13 /* !! */ [var7_11] - 2);
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        ++var5_5;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 39: {
                        this.stack.slide(3, var11_13 /* !! */ [var7_11] - 3);
                        var7_11 = (int)var3_3.getCode();
                        this.env = var3_3;
                        var5_5 += 2;
                        cfr_temp_0 = 92;
                        continue block171;
                    }
                    case 40: {
                        this.stack.pop(var11_13 /* !! */ [var7_11]);
                        if (var5_5 > 0) {
                            --var5_5;
                            var7_11 = (int)var3_3.getCode();
                            this.env = var3_3;
                            continue block170;
                        }
                        ** GOTO lbl659
                    }
                    case 41: {
                        var14_20 = (int)this.env.sizeValues() - 2;
                        for (var15_36 = var14_20 - 1; var15_36 >= 0; --var15_36) {
                            this.stack.push(this.env.get(var15_36 + 2));
                        }
                        ** GOTO lbl663
                    }
                    case 42: {
                        var14_21 = var11_13 /* !! */ [var7_11++];
                        if (var5_5 >= var14_21) {
                            var5_5 -= var14_21;
                            continue block170;
                        }
                        ** GOTO lbl666
                    }
                    case 43: {
                        var14_22 = var11_13 /* !! */ [var7_11++];
                        if (var14_22 > 0) {
                            this.stack.push(var3_3);
                        }
                        var15_37 = Value.createClosure(var14_22 + 1);
                        var15_37.setCode(var7_11 + var11_13 /* !! */ [var7_11++]);
                        for (var16_67 = 0; var16_67 < var14_22; ++var16_67) {
                            var15_37.set(var16_67 + 1, this.stack.pop());
                        }
                        ** GOTO lbl678
                    }
                    case 44: {
                        var14_23 = var11_13 /* !! */ [var7_11++];
                        var15_38 = var11_13 /* !! */ [var7_11++];
                        if (var15_38 > 0) {
                            this.stack.push(var3_3);
                        }
                        var3_3 = var16_68 = Value.createClosure(2 * var14_23 - 1 + var15_38);
                        for (var17_88 = 0; var17_88 < var15_38; ++var17_88) {
                            var16_68.set(2 * var14_23 - 1 + var17_88, this.stack.pop());
                        }
                        ** GOTO lbl680
                    }
                    case 45: {
                        var3_3 = this.env.offset(-2L);
                        continue block170;
                    }
                    case 46: {
                        var3_3 = this.env;
                        continue block170;
                    }
                    case 47: {
                        var3_3 = this.env.offset(2L);
                        continue block170;
                    }
                    case 48: {
                        var3_3 = this.env.offset(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 49: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.offset(-2L);
                        continue block170;
                    }
                    case 50: {
                        this.stack.push(var3_3);
                        var3_3 = this.env;
                        continue block170;
                    }
                    case 51: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.offset(2L);
                        continue block170;
                    }
                    case 52: {
                        this.stack.push(var3_3);
                        var3_3 = this.env.offset(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 53: {
                        var3_3 = var4_4.getGlobalData().get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 54: {
                        this.stack.push(var3_3);
                        var3_3 = var4_4.getGlobalData().get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 55: {
                        var3_3 = var4_4.getGlobalData().get(var11_13 /* !! */ [var7_11++]);
                        var3_3 = var3_3.get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 56: {
                        this.stack.push(var3_3);
                        var3_3 = var4_4.getGlobalData().get(var11_13 /* !! */ [var7_11++]);
                        var3_3 = var3_3.get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 57: {
                        var4_4.getGlobalData().set(var11_13 /* !! */ [var7_11++], var3_3);
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 58: {
                        var3_3 = var4_4.getAtom(0);
                        continue block170;
                    }
                    case 59: {
                        var3_3 = var4_4.getAtom(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 60: {
                        this.stack.push(var3_3);
                        var3_3 = var4_4.getAtom(0);
                        continue block170;
                    }
                    case 61: {
                        this.stack.push(var3_3);
                        var3_3 = var4_4.getAtom(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 62: {
                        var14_24 = var11_13 /* !! */ [var7_11++];
                        var15_39 = var11_13 /* !! */ [var7_11++];
                        var16_69 = Value.createBlock(var15_39, var14_24);
                        var16_69.set0(var3_3);
                        for (var17_89 = 1; var17_89 < var14_24; ++var17_89) {
                            var16_69.set(var17_89, this.stack.pop());
                        }
                        ** GOTO lbl694
                    }
                    case 63: {
                        var14_25 = var11_13 /* !! */ [var7_11++];
                        var3_3 = Value.createBlock(var14_25, var3_3);
                        continue block170;
                    }
                    case 64: {
                        var14_26 = var11_13 /* !! */ [var7_11++];
                        var15_40 = this.stack.pop();
                        var3_3 = Value.createBlock(var14_26, var3_3, var15_40);
                        continue block170;
                    }
                    case 65: {
                        var14_27 = var11_13 /* !! */ [var7_11++];
                        var15_41 = this.stack.pop();
                        var16_70 = this.stack.pop();
                        var3_3 = Value.createBlock(var14_27, var3_3, var15_41, var16_70);
                        continue block170;
                    }
                    case 66: {
                        var14_28 = var11_13 /* !! */ [var7_11++];
                        var15_42 = Value.createDoubleArray(var14_28);
                        var15_42.setDouble0(var3_3.asDouble());
                        for (var16_71 = 1; var16_71 < var14_28; ++var16_71) {
                            var15_42.setDouble(var16_71, this.stack.pop().asDouble());
                        }
                        ** GOTO lbl696
                    }
                    case 67: {
                        var3_3 = var3_3.get0();
                        continue block170;
                    }
                    case 68: {
                        var3_3 = var3_3.get1();
                        continue block170;
                    }
                    case 69: {
                        var3_3 = var3_3.get2();
                        continue block170;
                    }
                    case 70: {
                        var3_3 = var3_3.get3();
                        continue block170;
                    }
                    case 71: {
                        var3_3 = var3_3.get(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    ** case 72:
                    case 73: {
                        var3_3.set0(this.stack.pop());
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 74: {
                        var3_3.set1(this.stack.pop());
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 75: {
                        var3_3.set2(this.stack.pop());
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 76: {
                        var3_3.set3(this.stack.pop());
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 77: {
                        var3_3.set(var11_13 /* !! */ [var7_11++], this.stack.pop());
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 78: {
                        var14_29 = this.stack.pop().asDouble();
                        if (!var3_3.isDoubleArray()) ** GOTO lbl700
                        var3_3.setDouble(var11_13 /* !! */ [var7_11++], var14_29);
                        ** GOTO lbl701
                    }
                    case 79: {
                        var3_3 = var3_3.arrayLengthWrapped();
                        continue block170;
                    }
                    case 80: {
                        var3_3 = var3_3.get(this.stack.pop().asLong());
                        continue block170;
                    }
                    case 81: {
                        var14_30 = this.stack.pop().asLong();
                        var16_72 = this.stack.pop();
                        var3_3.set(var14_30, var16_72);
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 82: {
                        var3_3 = Value.createLong(var3_3.getUnsignedByte(this.stack.pop().asLong()));
                        continue block170;
                    }
                    case 83: {
                        var14_31 = this.stack.pop().asLong();
                        var16_73 = this.stack.pop().asCastedInt();
                        var3_3.setUnsignedByte(var14_31, var16_73);
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    case 84: {
                        var7_11 += var11_13 /* !! */ [var7_11];
                        continue block170;
                    }
                    case 85: {
                        if (var3_3 != Value.FALSE) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl703
                    }
                    case 86: {
                        if (var3_3 == Value.FALSE) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl705
                    }
                    case 87: {
                        var14_32 = IntegerUtils.signedToUnsigned(var11_13 /* !! */ [var7_11++]);
                        var16_74 = (int)(var14_32 >> 16);
                        var17_90 = (int)(var14_32 & 65535L);
                        if (!var3_3.isBlock()) ** GOTO lbl707
                        var18_94 = var3_3.getTag();
                        if (!(ByteCodeRunner.$assertionsDisabled || var18_94 >= 0 && var18_94 < var16_74)) {
                            throw new AssertionError((Object)"invalid switch index");
                        }
                        ** GOTO lbl711
                    }
                    ** case 88:
                    case 89: {
                        this.stack.push(Value.createLong(var5_5));
                        this.stack.push(this.env);
                        this.stack.push(Value.createLong(var6_6));
                        this.stack.push(Value.createCodeOffset(var7_11 + var11_13 /* !! */ [var7_11]));
                        var6_6 = this.stack.size();
                        ++var7_11;
                        continue block170;
                    }
                    case 90: {
                        var14_33 = Signals.processSignal(this);
                        if (var14_33) {
                            --var7_11;
                            continue block170;
                        }
                    }
                    case 91: {
                        if (var6_6 <= this.context.getDebuggerState().getDebuggerTrapBarrier()) {
                            Debugger.handleEvent(this, Debugger.EventKind.TRAP_BARRIER);
                        }
                        if (var4_4.isBacktraceActive()) {
                            this.stashBacktrace(var3_3, var7_11, var6_6);
                        }
                        if (var6_6 == -1) {
                            if (this.context.getDebuggerState().isDebuggerInUse()) {
                                this.stack.push(var3_3);
                            }
                            Fail.raise(var3_3);
                        }
                        this.stack.pop(this.stack.size() - var6_6);
                        var7_11 = (int)this.stack.pop().asCodeOffset();
                        var6_6 = this.stack.pop().asCastedInt();
                        this.env = this.stack.pop();
                        var5_5 = this.stack.pop().asCastedInt();
                        continue block170;
                    }
                    case 93: {
                        this.stack.push(this.env);
                        var15_43 = var11_13 /* !! */ [var7_11++];
                        var3_3 = var12_17.invoke(var15_43, var3_3);
                        this.env = this.stack.pop();
                        continue block170;
                    }
                    case 94: {
                        this.stack.push(this.env);
                        var15_44 = var11_13 /* !! */ [var7_11++];
                        var3_3 = var12_17.invoke(var15_44, var3_3, this.stack.peek(1));
                        this.env = this.stack.pop();
                        this.stack.pop(1);
                        continue block170;
                    }
                    case 95: {
                        this.stack.push(this.env);
                        var15_45 = var11_13 /* !! */ [var7_11++];
                        var3_3 = var12_17.invoke(var15_45, var3_3, this.stack.peek(1), this.stack.peek(2));
                        this.env = this.stack.pop();
                        this.stack.pop(2);
                        continue block170;
                    }
                    case 96: {
                        this.stack.push(this.env);
                        var15_46 = var11_13 /* !! */ [var7_11++];
                        var3_3 = var12_17.invoke(var15_46, var3_3, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3));
                        this.env = this.stack.pop();
                        this.stack.pop(3);
                        continue block170;
                    }
                    case 97: {
                        this.stack.push(this.env);
                        var15_47 = var11_13 /* !! */ [var7_11++];
                        var3_3 = var12_17.invoke(var15_47, var3_3, this.stack.peek(1), this.stack.peek(2), this.stack.peek(3), this.stack.peek(4));
                        this.env = this.stack.pop();
                        this.stack.pop(4);
                        continue block170;
                    }
                    case 98: {
                        var15_48 = var11_13 /* !! */ [var7_11++];
                        this.stack.push(var3_3);
                        this.stack.push(this.env);
                        var16_75 = var11_13 /* !! */ [var7_11++];
                        var17_91 = new Value[var15_48];
                        for (var18_95 = 0; var18_95 < var15_48; ++var18_95) {
                            var17_91[var18_95] = this.stack.peek(var18_95 + 1);
                        }
                        ** GOTO lbl742
                    }
                    case 99: {
                        var3_3 = Value.ZERO;
                        continue block170;
                    }
                    case 100: {
                        var3_3 = Value.ONE;
                        continue block170;
                    }
                    case 101: {
                        var3_3 = Value.TWO;
                        continue block170;
                    }
                    case 102: {
                        var3_3 = Value.THREE;
                        continue block170;
                    }
                    case 103: {
                        var3_3 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 104: {
                        this.stack.push(var3_3);
                        var3_3 = Value.ZERO;
                        continue block170;
                    }
                    case 105: {
                        this.stack.push(var3_3);
                        var3_3 = Value.ONE;
                        continue block170;
                    }
                    case 106: {
                        this.stack.push(var3_3);
                        var3_3 = Value.TWO;
                        continue block170;
                    }
                    case 107: {
                        this.stack.push(var3_3);
                        var3_3 = Value.THREE;
                        continue block170;
                    }
                    case 108: {
                        this.stack.push(var3_3);
                        var3_3 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        continue block170;
                    }
                    case 109: {
                        var3_3 = Value.createFromRawValue(2L - var3_3.getRawValue());
                        continue block170;
                    }
                    case 110: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() + this.stack.pop().getRawValue() - 1L);
                        continue block170;
                    }
                    case 111: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() - this.stack.pop().getRawValue() + 1L);
                        continue block170;
                    }
                    case 112: {
                        var3_3 = Value.createLong(var3_3.asLong() * this.stack.pop().asLong());
                        continue block170;
                    }
                    case 113: {
                        var15_49 = this.stack.pop().asLong();
                        if (var15_49 != 0L) {
                            var3_3 = Value.createLong(var3_3.asLong() / var15_49);
                            continue block170;
                        }
                        ** GOTO lbl750
                    }
                    case 114: {
                        var15_50 = this.stack.pop().asLong();
                        if (var15_50 != 0L) {
                            var3_3 = Value.createLong(var3_3.asLong() % var15_50);
                            continue block170;
                        }
                        ** GOTO lbl765
                    }
                    case 115: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() & this.stack.pop().getRawValue());
                        continue block170;
                    }
                    case 116: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() | this.stack.pop().getRawValue());
                        continue block170;
                    }
                    case 117: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() ^ this.stack.pop().getRawValue() | 1L);
                        continue block170;
                    }
                    case 118: {
                        var3_3 = Value.createFromRawValue((var3_3.getRawValue() - 1L << (int)this.stack.pop().asLong()) + 1L);
                        continue block170;
                    }
                    case 119: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() - 1L >>> (int)this.stack.pop().asLong() | 1L);
                        continue block170;
                    }
                    case 120: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() - 1L >> (int)this.stack.pop().asLong() | 1L);
                        continue block170;
                    }
                    ** case 121:
                    ** case 122:
                    ** case 123:
                    ** case 124:
                    ** case 125:
                    ** case 126:
                    case 127: {
                        var3_3 = Value.createFromRawValue(var3_3.getRawValue() + (long)(var11_13 /* !! */ [var7_11++] << 1));
                        continue block170;
                    }
                    case 128: {
                        var15_51 = var3_3.get0().getRawValue();
                        var3_3.set0(Value.createFromRawValue(var15_51 + (long)(var11_13 /* !! */ [var7_11++] << 1)));
                        var3_3 = Value.UNIT;
                        continue block170;
                    }
                    ** case 129:
                    case 130: {
                        var3_3 = this.stack.peek(0).get0().get(var3_3.asLong());
                        continue block170;
                    }
                    case 131: {
                        var15_52 = var11_13 /* !! */ [var7_11++];
                        if (Value.compare(Value.createLong(var15_52), var3_3) == 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl781
                    }
                    case 132: {
                        var15_53 = var11_13 /* !! */ [var7_11++];
                        if (Value.compare(Value.createLong(var15_53), var3_3) != 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl783
                    }
                    case 133: {
                        var15_54 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compare(var15_54, var3_3) < 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl785
                    }
                    case 134: {
                        var15_55 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compare(var15_55, var3_3) <= 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl787
                    }
                    case 135: {
                        var15_56 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compare(var15_56, var3_3) > 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl789
                    }
                    case 136: {
                        var15_57 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compare(var15_57, var3_3) >= 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl791
                    }
                    case 137: {
                        if (Value.compareUnsigned(var3_3, this.stack.pop()) < 0) {
                            var3_3 = Value.TRUE;
                            continue block170;
                        }
                        ** GOTO lbl793
                    }
                    case 138: {
                        if (Value.compareUnsigned(var3_3, this.stack.pop()) >= 0) {
                            var3_3 = Value.TRUE;
                            continue block170;
                        }
                        ** GOTO lbl795
                    }
                    case 139: {
                        var15_58 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compareUnsigned(var15_58, var3_3) < 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl797
                    }
                    case 140: {
                        var15_59 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        if (Value.compareUnsigned(var15_59, var3_3) >= 0) {
                            var7_11 += var11_13 /* !! */ [var7_11];
                            continue block170;
                        }
                        ** GOTO lbl799
                    }
                    case 141: {
                        var15_60 = var3_3.get0();
                        this.stack.push(var3_3);
                        var3_3 = Value.createLong(var11_13 /* !! */ [var7_11++]);
                        var16_76 = (long)var11_13 /* !! */ [var7_11] & var15_60.get1().getRawValue();
                        var18_96 = var3_3.getRawValue();
                        if (var15_60.get(3L + var16_76).getRawValue() == var18_96) {
                            var3_3 = var15_60.get(2L + var16_76);
lbl626:
                            // 2 sources

                            while (true) {
                                ++var7_11;
                                continue block170;
                                break;
                            }
                        }
                        ** GOTO lbl801
                    }
                    case 142: {
                        var3_3 = ByteCodeRunner.getMethod(this.stack.peek(0), var3_3.getRawValue());
                        continue block170;
                    }
                    case 144: {
                        if (this.context.getDebuggerState().decrementDebuggerEventCount()) {
                            this.stack.push(Value.createLong(var5_5));
                            this.stack.push(this.env);
                            this.stack.push(Value.createCodeOffset(var7_11 - 1));
                            this.stack.push(var3_3);
                            Debugger.handleEvent(this, Debugger.EventKind.EVENT_COUNT);
                            this.stack.pop(4);
                        }
                        --var7_11;
                        var8_7 = 1;
                        continue block170;
                    }
                    case 145: {
                        this.stack.push(Value.createLong(var5_5));
                        this.stack.push(this.env);
                        this.stack.push(Value.createCodeOffset(var7_11 - 1));
                        this.stack.push(var3_3);
                        Debugger.handleEvent(this, Debugger.EventKind.BREAKPOINT);
                        this.stack.pop(4);
                        --var7_11;
                        var8_7 = 1;
                        continue block170;
                    }
                    default: {
                        Fatal.raise("Fatal error: bad opcode (" + var13_18 + ")");
                        continue block170;
                    }
lbl659:
                    // 1 sources

                    var7_11 = (int)this.stack.pop().asCodeOffset();
                    this.env = this.stack.pop();
                    var5_5 = this.stack.pop().asCastedInt();
                    continue block170;
lbl663:
                    // 1 sources

                    this.env = this.env.get1();
                    var5_5 += var14_20;
                    continue block170;
lbl666:
                    // 1 sources

                    var15_61 = 1 + var5_5;
                    var16_77 = Value.createClosure(var15_61 + 2);
                    var16_77.set1(this.env);
                    for (var17_92 = 0; var17_92 < var15_61; ++var17_92) {
                        var16_77.set(var17_92 + 2, this.stack.pop());
                    }
                    var16_77.setCode(var7_11 - 3);
                    var3_3 = var16_77;
                    var7_11 = (int)this.stack.pop().asCodeOffset();
                    this.env = this.stack.pop();
                    var5_5 = this.stack.pop().asCastedInt();
                    continue block170;
lbl678:
                    // 1 sources

                    var3_3 = var15_37;
                    continue block170;
lbl680:
                    // 1 sources

                    var16_68.setCode(var7_11 + var11_13 /* !! */ [var7_11]);
                    this.stack.push(var3_3);
                    var17_93 = var16_68.asBlock();
                    for (var18_97 = 1; var18_97 < var14_23; ++var18_97) {
                        var19_101 = Value.createInfix(var18_97 * 2);
                        var19_101.setCode(var7_11 + var11_13 /* !! */ [var7_11 + var18_97]);
                        var19_101.setParent(var17_93);
                        var16_68.set(2 * var18_97 - 1, Value.createFromRawValue(var19_101.getHeader()));
                        var20_102 = var19_101;
                        var16_68.set(2 * var18_97, var20_102);
                        this.stack.push(var20_102);
                    }
                    var7_11 += var14_23;
                    continue block170;
lbl694:
                    // 1 sources

                    var3_3 = var16_69;
                    continue block170;
lbl696:
                    // 1 sources

                    var3_3 = var15_42;
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.createDouble(var3_3.isDoubleArray() != false ? var3_3.getDouble(var11_13 /* !! */ [var7_11++]) : var3_3.get(var11_13 /* !! */ [var7_11++]).asDouble());
                    }
                    continue block170;
lbl700:
                    // 1 sources

                    var3_3.set(var11_13 /* !! */ [var7_11++], Value.createDouble(var14_29));
lbl701:
                    // 2 sources

                    var3_3 = Value.UNIT;
                    continue block170;
lbl703:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl705:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl707:
                    // 1 sources

                    var18_98 = var3_3.asCastedInt();
                    if (!ByteCodeRunner.$assertionsDisabled && IntegerUtils.signedToUnsigned(var18_98) >= (long)var17_90) {
                        throw new AssertionError((Object)"invalid switch index");
                    }
                    ** GOTO lbl713
lbl711:
                    // 1 sources

                    var7_11 += var11_13 /* !! */ [var7_11 + var17_90 + var18_94];
                    continue block170;
lbl713:
                    // 1 sources

                    var7_11 += var11_13 /* !! */ [var7_11 + var18_98];
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = var3_3 == Value.FALSE ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
                    catch (Fail.Exception var15_62) {
                        var14_34 = true;
                        var9_10 = var15_62;
                        --var7_11;
                        ** GOTO lbl751
                    }
                    this.stack.pop();
                    var6_6 = this.stack.pop().asCastedInt();
                    this.stack.pop(2);
                    continue block170;
                    catch (Fail.Exception var16_78) {
                        var9_10 = var16_78;
                        ** GOTO lbl751
                    }
                    catch (Fail.Exception var16_79) {
                        var9_10 = var16_79;
                        ** GOTO lbl751
                    }
                    catch (Fail.Exception var16_80) {
                        var9_10 = var16_80;
                        ** GOTO lbl751
                    }
                    catch (Fail.Exception var16_81) {
                        var9_10 = var16_81;
                        ** GOTO lbl751
                    }
                    catch (Fail.Exception var16_82) {
                        var9_10 = var16_82;
                        ** GOTO lbl751
                    }
lbl742:
                    // 1 sources

                    try {
                        var3_3 = var12_17.invoke(var16_75, var17_91);
                        this.env = this.stack.pop();
                        this.stack.pop(var15_48);
                        continue block170;
                    }
                    catch (Fail.Exception var18_99) {
                        var9_10 = var18_99;
                        ** GOTO lbl751
                    }
lbl750:
                    // 1 sources

                    var9_10 = Fail.createZeroDivide();
lbl751:
                    // 9 sources

                    while (true) {
                        var3_3 = var9_10.asValue(var4_4.getGlobalData());
                        if (var4_4.isBacktraceActive()) {
                            this.stashBacktrace(var3_3, var7_11, var6_6);
                        }
                        if (var6_6 == -1) {
                            if (this.context.getDebuggerState().isDebuggerInUse()) {
                                this.stack.push(var3_3);
                            }
                            Fail.raise(var3_3);
                        }
                        this.stack.pop(this.stack.size() - var6_6);
                        var7_11 = (int)this.stack.pop().asCodeOffset();
                        var6_6 = this.stack.pop().asCastedInt();
                        this.env = this.stack.pop();
                        var5_5 = this.stack.pop().asCastedInt();
                        continue block170;
                        break;
                    }
lbl765:
                    // 1 sources

                    var9_10 = Fail.createZeroDivide();
                    ** continue;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) == 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) != 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) < 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) <= 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) > 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = Value.compare(var3_3, this.stack.pop()) >= 0 ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl-1000:
                    // 1 sources

                    {
                        var3_3 = var3_3.isLong() != false ? Value.TRUE : Value.FALSE;
                    }
                    continue block170;
lbl781:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl783:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl785:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl787:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl789:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl791:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl793:
                    // 1 sources

                    var3_3 = Value.FALSE;
                    continue block170;
lbl795:
                    // 1 sources

                    var3_3 = Value.FALSE;
                    continue block170;
lbl797:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl799:
                    // 1 sources

                    ++var7_11;
                    continue block170;
lbl801:
                    // 1 sources

                    var20_103 = 3L;
                    var22_104 = var15_60.get0().getRawValue();
                    while (true) {
                        if (var20_103 < var22_104) {
                            var24_105 = var20_103 + var22_104 >> 1 | 1L;
                            if (var18_96 < var15_60.get(var24_105).getRawValue()) {
                                var22_104 = var24_105 - 2L;
                                continue;
                            }
                        } else {
                            var11_13 /* !! */ [var7_11] = (int)(var20_103 - 3L);
                            var3_3 = var15_60.get(var20_103 - 1L);
                            ** continue;
                        }
                        var20_103 = var24_105;
                    }
lbl815:
                    // 1 sources

                    try {
                        Signals.processSignal(this);
                    }
                    catch (Fail.Exception var11_14) {
                        var9_10 = var11_14;
                    }
lbl-1000:
                    // 3 sources

                    try {}
                    catch (FalseExit var11_16) {
                        return Value.createLong(var11_16.getExitCode());
                    }
                    ** GOTO lbl848
                    catch (FalseExit var11_15) {
                        return Value.createLong(var11_15.getExitCode());
                    }
                    ** GOTO lbl-1000
                    catch (FalseExit var15_66) {
                        return Value.createLong(var15_66.getExitCode());
                    }
                    catch (FalseExit var15_65) {
                        return Value.createLong(var15_65.getExitCode());
                    }
                    catch (FalseExit var18_100) {
                        return var3_3;
                    }
                    catch (FalseExit var16_87) {
                        return var3_3;
                    }
                    catch (FalseExit var16_86) {
                        return var3_3;
                    }
                    catch (FalseExit var16_85) {
                        return var3_3;
                    }
                    catch (FalseExit var16_84) {
                        return var3_3;
                    }
                    catch (FalseExit var16_83) {
                        return var3_3;
                    }
                    catch (FalseExit var15_64) {
                        return Value.createLong(var15_64.getExitCode());
                    }
                    catch (FalseExit var15_63) {
                        return Value.createLong(var15_63.getExitCode());
                    }
lbl848:
                    // 1 sources

                    CurrentContext.FINALIZERS_STATE.runFinalizers();
                    continue block170;
                    case 143: 
                }
                return var3_3;
            } while (true);
            break;
        }
        return var3_3;
    }

    private static Value eventForLocation(Value value, int n) {
        Value value2;
        block6: {
            Value value3;
            block5: {
                Value value4 = null;
                int n2 = n * 4;
                long l = value.sizeValues();
                long l2 = 0L;
                while (true) {
                    if (l2 < l) {
                        for (Value value5 = value.get(l2); value5 != Value.EMPTY_LIST; value5 = value5.get1()) {
                            value3 = value5.get0();
                            int n3 = value3.get(0L).asCastedInt();
                            if (n3 != n2) {
                                if (n3 != n2 + 8) continue;
                                value4 = value3;
                                continue;
                            }
                            break block5;
                        }
                    } else {
                        if (value4 == null) break;
                        value2 = value4;
                        break block6;
                    }
                    ++l2;
                }
                value2 = Value.FALSE;
                break block6;
            }
            return value3;
        }
        return value2;
    }

    private LocInfo extractLocationInfo(Value value, int n) {
        boolean bl;
        Value value2 = ByteCodeRunner.eventForLocation(value, n);
        boolean bl2 = bl = n != -1 && this.context.getCodeState().getCode()[n] == 91;
        if (value2 == Value.FALSE) {
            return new LocInfo(false, bl, "", 0, 0, 0);
        }
        Value value3 = value2.get(2L).get(0L);
        int n2 = value3.get(2L).asCastedInt();
        int n3 = value3.get(3L).asCastedInt();
        return new LocInfo(true, bl, value3.get(0L).asString(), value3.get(1L).asCastedInt(), n3 - n2, value2.get(2L).get(1L).get(3L).asCastedInt() - n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printLocation(PrintStream printStream, LocInfo locInfo, int n) {
        String string;
        block6: {
            block5: {
                block4: {
                    assert (printStream != null) : "null err";
                    assert (locInfo != null) : "null li";
                    if (!locInfo.valid) {
                        if (locInfo.isRaise) return;
                    }
                    if (!locInfo.isRaise) break block4;
                    if (n != 0) break block5;
                    string = "Raised at";
                    break block6;
                }
                string = n == 0 ? "Raised by primitive operation at" : "Called from";
            }
            string = "Re-raised at";
        }
        if (locInfo.valid) {
            printStream.printf("%s file \"%s\", line %d, characters %d-%d\n", string, locInfo.filename, locInfo.lnum, locInfo.startChr, locInfo.endChr);
            return;
        }
        printStream.printf("%s unkown location\n", string);
    }

    @Override
    public void printExceptionBacktrace(PrintStream printStream) {
        assert (printStream != null) : "null err";
        Value value = this.context.getCodeState().getDebugInfo();
        if (value == Value.ZERO) {
            printStream.println("(Program not linked with -g, cannot print stack backtrace)");
        } else {
            int n = this.backtraceBuffer.size();
            for (int i = 0; i < n; ++i) {
                LocInfo locInfo = this.extractLocationInfo(value, this.backtraceBuffer.get(i));
                this.printLocation(printStream, locInfo, i);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Value getExceptionBacktrace() {
        Value value = this.context.getCodeState().getDebugInfo();
        if (value == Value.FALSE) {
            return Value.ZERO;
        }
        int n = this.backtraceBuffer.size();
        Value value2 = Value.createBlock(0, n);
        int n2 = 0;
        while (n2 < n) {
            LocInfo locInfo = this.extractLocationInfo(value, this.backtraceBuffer.get(n2));
            Value value3 = locInfo.valid ? Value.createBlock(0, locInfo.isRaise ? Value.TRUE : Value.FALSE, Value.createString(locInfo.filename), Value.createLong(locInfo.lnum), Value.createLong(locInfo.startChr), Value.createLong(locInfo.endChr)) : Value.createBlock(1, locInfo.isRaise ? Value.TRUE : Value.FALSE);
            value2.set(n2, value3);
            ++n2;
        }
        return Value.createBlock(0, value2);
    }

    private void stashBacktrace(Value value, int n, int n2) throws Fatal.Exception {
        assert (value != null) : "null exception";
        int n3 = n;
        if (value != this.backtraceLastException) {
            this.backtraceBuffer.clear();
            this.backtraceLastException = value;
            if (n3 >= 0 && n3 < this.context.getCodeState().getCode().length) {
                this.backtraceBuffer.add(n3 - 1);
            }
            while (this.stack.size() > 0 && this.stack.size() > n2) {
                Value value2 = this.stack.pop();
                if (!value2.isCodeOffset()) continue;
                this.backtraceBuffer.add((int)value2.asCodeOffset());
            }
        }
    }
}

