/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.externallibs.zip;

import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.externallibs.zip.ZStream;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="zip", module="ZLib", source="zlibstubs.c")
public final class Zlib {
    private static final Value Z_NO_FLUSH = Value.ZERO;
    private static final Value Z_SYNC_FLUSH = Value.ONE;
    private static final Value Z_FULL_FLUSH = Value.TWO;
    private static final Value Z_FINISH = Value.THREE;
    private static final int[] CRC_TABLE = new int[256];

    private Zlib() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "bool"}, returnType="Zlib.stream")
    public static Value camlzip_deflateInit(Value value, Value value2) throws Fail.Exception {
        try {
            Deflater deflater;
            deflater(value.asCastedInt(), value2 == Value.FALSE);
            return ZStream.create(deflater, null);
        }
        catch (Exception exception) {
            Zlib.error("Zlib.deflateInit", exception);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter only supports [Z_FINISH]"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_deflate(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) throws Fail.Exception {
        return Zlib.camlzip_deflate_bytecode(value, value2, value3, value4, value5, value6, value7, value8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter only supports [Z_FINISH]"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_deflate_bytecode(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) throws Fail.Exception {
        try {
            Value value9;
            Deflater deflater = ((ZStream)value.asCustom()).getDeflater();
            long l = deflater.getBytesRead();
            deflater.setInput(value2.getBytes(), value3.asBoundedInt(), value4.asBoundedInt());
            if (value8 == Z_FINISH) {
                deflater.finish();
            }
            int n = deflater.deflate(value5.getBytesForModification(), value6.asBoundedInt(), value7.asBoundedInt());
            if (deflater.finished()) {
                value9 = Value.TRUE;
                return Value.createBlock(0, value9, Value.createLong(deflater.getBytesRead() - l), Value.createLong(n));
            }
            value9 = Value.FALSE;
            return Value.createBlock(0, value9, Value.createLong(deflater.getBytesRead() - l), Value.createLong(n));
        }
        catch (Exception exception) {
            Zlib.error("Zlib.deflate", exception);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Zlib.stream"}, returnType="unit")
    public static Value camlzip_deflateEnd(Value value) throws Fail.Exception {
        try {
            ((ZStream)value.asCustom()).getDeflater().end();
            return Value.UNIT;
        }
        catch (Exception exception) {
            Zlib.error("Zlib.deflateEnd", exception);
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="Zlib.stream")
    public static Value camlzip_inflateInit(Value value) throws Fail.Exception {
        try {
            Inflater inflater;
            inflater(value == Value.FALSE);
            return ZStream.create(null, inflater);
        }
        catch (Exception exception) {
            Zlib.error("Zlib.inflateInit", exception);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter is ignored"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_inflate(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) throws Fail.Exception {
        return Zlib.camlzip_inflate_bytecode(value, value2, value3, value4, value5, value6, value7, value8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"[flush] parameter is ignored"}, parameterTypes={"Zlib.stream", "string", "int", "int", "string", "int", "int", "Zlib.flush_command"}, returnType="bool * int * int")
    public static Value camlzip_inflate_bytecode(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) throws Fail.Exception {
        try {
            Value value9;
            Inflater inflater = ((ZStream)value.asCustom()).getInflater();
            long l = inflater.getBytesRead();
            inflater.setInput(value2.getBytes(), value3.asBoundedInt(), value4.asBoundedInt());
            int n = inflater.inflate(value5.getBytesForModification(), value6.asBoundedInt(), value7.asBoundedInt());
            if (inflater.finished()) {
                value9 = Value.TRUE;
                return Value.createBlock(0, value9, Value.createLong(inflater.getBytesRead() - l), Value.createLong(n));
            }
            value9 = Value.FALSE;
            return Value.createBlock(0, value9, Value.createLong(inflater.getBytesRead() - l), Value.createLong(n));
        }
        catch (Exception exception) {
            Zlib.error("Zlib.inflate", exception);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Zlib.stream"}, returnType="unit")
    public static Value camlzip_inflateEnd(Value value) throws Fail.Exception {
        try {
            ((ZStream)value.asCustom()).getInflater().end();
            return Value.UNIT;
        }
        catch (Exception exception) {
            Zlib.error("Zlib.inflateEnd", exception);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int32", "string", "int", "int"}, returnType="int32")
    public static Value camlzip_update_crc32(Value value, Value value2, Value value3, Value value4) throws Fatal.Exception {
        int n = ~value.asInt32();
        int n2 = value4.asBoundedInt();
        int n3 = value3.asBoundedInt();
        byte[] byArray = value2.getBytes();
        for (int i = 0; i < n2; ++i) {
            n = CRC_TABLE[(n ^ byArray[n3 + i]) & 0xFF] ^ n >>> 8;
        }
        return Value.createInt32(~n);
    }

    private static void error(String string, Exception exception) throws Fail.Exception {
        assert (string != null) : "null prim";
        assert (exception != null) : "null e";
        Value value = CurrentContext.CODE_STATE.getCallback("Zlib.Error");
        if (value == null) {
            Fail.invalidArgument("Exception Zlib.Error not initialized");
        } else {
            String string2 = exception.getMessage();
            Value value2 = Value.createBlock(0, value, Value.createString(string), Value.createString(string2 != null ? string2 : ""));
            Fail.raise(value2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        int n = 0;
        block0: while (n < 256) {
            int n2 = n;
            int n3 = 0;
            while (true) {
                block5: {
                    block4: {
                        block3: {
                            if (n3 >= 8) break block3;
                            if ((n2 & 1) == 0) break block4;
                            n2 = 0xEDB88320 ^ n2 >>> 1;
                            break block5;
                        }
                        ++n;
                        continue block0;
                    }
                    n2 >>>= 1;
                }
                Zlib.CRC_TABLE[n] = n2;
                ++n3;
            }
            break;
        }
        return;
    }
}

