/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Toolkit;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.util.Beep;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/sound.c")
public final class Sound {
    private static final int BUFFER_SIZE = 1024;
    private static final float SAMPLE_RATE = 44100.0f;

    private Sound() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_sound(Value value, Value value2) throws Fail.Exception {
        SourceDataLine sourceDataLine;
        GraphSlot.checkGraph();
        Context context = CurrentContext.CONTEXT;
        if (!context.getParameters().isJavaxSoundUsed()) {
            Toolkit.getDefaultToolkit().beep();
            return Value.UNIT;
        }
        try {
            Beep beep = new Beep(44100.0f, value.asLong(), value2.asLong());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, beep.getFormat());
            sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(beep.getFormat());
            sourceDataLine.start();
            byte[] byArray = new byte[1024];
            while (beep.available() > 0) {
                int n = beep.read(byArray);
                for (int i = sourceDataLine.write(byArray, 0, n); i < n; i += sourceDataLine.write(byArray, i, n - i)) {
                }
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            Toolkit.getDefaultToolkit().beep();
            return Value.UNIT;
        }
        catch (IOException iOException) {
            return Value.UNIT;
        }
        {
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        return Value.UNIT;
    }
}

