/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/mkdir.c")
public final class Mkdir {
    private Mkdir() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Unix.file_perm"}, returnType="unit")
    public static Value unix_mkdir(Value path, Value perm) throws Fail.Exception {
        File f = CurrentContext.getFilesState().getRealFile(path);
        try {
            FileAttribute<?> attr = PermissionsUtils.intToAttributes(perm.asCastedInt());
            if (attr != null) {
                Files.createDirectories(f.toPath(), attr);
            } else {
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
            }
        }
        catch (IOException ioe) {
            Unix.fail("mkdir", ioe);
        }
        return Value.UNIT;
    }
}

