/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlAssertFailureException;
import org.ocamljava.runtime.wrappers.OCamlDivisionByZeroException;
import org.ocamljava.runtime.wrappers.OCamlEndOfFileException;
import org.ocamljava.runtime.wrappers.OCamlFailureException;
import org.ocamljava.runtime.wrappers.OCamlInvalidArgumentException;
import org.ocamljava.runtime.wrappers.OCamlMatchFailureException;
import org.ocamljava.runtime.wrappers.OCamlNotFoundException;
import org.ocamljava.runtime.wrappers.OCamlOutOfMemoryException;
import org.ocamljava.runtime.wrappers.OCamlStackOverflowException;
import org.ocamljava.runtime.wrappers.OCamlSysBlockedIOException;
import org.ocamljava.runtime.wrappers.OCamlSysErrorException;
import org.ocamljava.runtime.wrappers.OCamlUndefinedRecursiveModuleException;

public class OCamlException
extends RuntimeException {
    static final long serialVersionUID = 304215162058080925L;
    public static final Object SLOT = new Object();

    public OCamlException(Fail.Exception fe) {
        super(fe);
        this.setStackTrace(fe.getStackTrace());
    }

    public OCamlException(Value v) {
        super(new Fail.Exception(v));
    }

    public final Fail.Exception getFailException() {
        return (Fail.Exception)this.getCause();
    }

    public final String getOCamlName() {
        Fail.Exception e = (Fail.Exception)this.getCause();
        Value v = e.asValue();
        return v.get0().get0().asString();
    }

    public final String getOCamlStringRepresentation() {
        Fail.Exception e = (Fail.Exception)this.getCause();
        Value v = e.asValue();
        return Misc.convertException(v, null);
    }

    @Override
    public final String toString() {
        return this.getOCamlStringRepresentation();
    }

    public static OCamlException wrap(Fail.Exception fe) {
        assert (fe != null) : "null fe";
        Value v = fe.asValue();
        String id = v.get0().get0().asString();
        Constructor<?> cstr = OCamlException.getExceptionMap().get(id);
        if (cstr != null) {
            try {
                return (OCamlException)cstr.newInstance(fe);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return new OCamlException(fe);
            }
        }
        return new OCamlException(fe);
    }

    public static void register(String id, Class<?> cl) {
        assert (id != null) : "null id";
        assert (cl != null) : "null cl";
        try {
            Map<String, Constructor<?>> map = OCamlException.getExceptionMap();
            map.put(id, cl.getConstructor(Fail.Exception.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static Value getTag(String id) {
        assert (id != null) : "null id";
        try {
            return AbstractNativeRunner.getGlobal("caml_exn_" + id);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static synchronized Map<String, Constructor<?>> getExceptionMap() {
        CodeState cs = CurrentContext.getCodeState();
        Map res = (Map)cs.getSlot(SLOT);
        if (res == null) {
            HashMap slot = new HashMap();
            cs.registerSlot(SLOT, slot);
            return slot;
        }
        return res;
    }

    static {
        try {
            OCamlException.register("Not_found", OCamlNotFoundException.class);
            OCamlException.register("Out_of_memory", OCamlOutOfMemoryException.class);
            OCamlException.register("Stack_overflow", OCamlStackOverflowException.class);
            OCamlException.register("End_of_file", OCamlEndOfFileException.class);
            OCamlException.register("Division_by_zero", OCamlDivisionByZeroException.class);
            OCamlException.register("Sys_blocked_io", OCamlSysBlockedIOException.class);
            OCamlException.register("Failure", OCamlFailureException.class);
            OCamlException.register("Invalid_argument", OCamlInvalidArgumentException.class);
            OCamlException.register("Sys_error", OCamlSysErrorException.class);
            OCamlException.register("Match_failure", OCamlMatchFailureException.class);
            OCamlException.register("Assert_failure", OCamlAssertFailureException.class);
            OCamlException.register("Undefined_recursive_module", OCamlUndefinedRecursiveModuleException.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

