/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.DataFormat;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class MarshalExtern
implements DataFormat {
    private static final int NO_SHARING = 1;
    private static final int CLOSURES = 2;
    private static final int[] EXTERN_FLAGS = new int[]{1, 2};

    private MarshalExtern() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] externValue(Context context, Value value, Value value2) throws IOException, Fail.Exception {
        assert (context != null) : "null ctxt";
        assert (value != null) : "null v";
        assert (value2 != null) : "null flags";
        int n = Misc.convertFlagList(value2, EXTERN_FLAGS);
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        LinkedList<Value> linkedList = new LinkedList<Value>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CustomOperations.SerializationSizes serializationSizes = new CustomOperations.SerializationSizes();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        IO.write32s(dataOutputStream, -2070567234);
        dataOutputStream.write(new byte[16]);
        MarshalExtern.externRec(context, dataOutputStream, value, linkedList, serializationSizes, bl, bl2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(16);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream2);
        dataOutputStream2.writeInt(byArray.length - 20);
        dataOutputStream2.writeInt(linkedList.size());
        dataOutputStream2.writeInt(IntegerUtils.unsignedToSigned(serializationSizes.size32));
        dataOutputStream2.writeInt(IntegerUtils.unsignedToSigned(serializationSizes.size64));
        System.arraycopy(byteArrayOutputStream2.toByteArray(), 0, byArray, 4, 16);
        byteArrayOutputStream2.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void externRec(Context context, DataOutput dataOutput, Value value, List<Value> list, CustomOperations.SerializationSizes serializationSizes, boolean bl, boolean bl2) throws IOException, Fail.Exception {
        assert (context != null) : "null ctxt";
        assert (dataOutput != null) : "null out";
        assert (value != null) : "null val";
        assert (list != null) : "null objTable";
        assert (serializationSizes != null) : "null sizes";
        Value value2 = value;
        LinkedList<StackItem> linkedList = new LinkedList<StackItem>();
        boolean bl3 = false;
        while (true) {
            long l;
            block58: {
                long l2;
                block57: {
                    block56: {
                        int n;
                        int n2;
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        int n3;
                                        block51: {
                                            block50: {
                                                block45: {
                                                    int n4;
                                                    block46: {
                                                        block49: {
                                                            block48: {
                                                                block47: {
                                                                    block44: {
                                                                        block43: {
                                                                            block42: {
                                                                                Value value3;
                                                                                block41: {
                                                                                    block40: {
                                                                                        block39: {
                                                                                            long l3;
                                                                                            block38: {
                                                                                                block37: {
                                                                                                    if (bl3) {
                                                                                                        value2 = null;
                                                                                                        while (value2 == null && !linkedList.isEmpty()) {
                                                                                                            StackItem stackItem = (StackItem)linkedList.get(0);
                                                                                                            value2 = stackItem.nextItem();
                                                                                                            if (value2 != null) continue;
                                                                                                            linkedList.remove(0);
                                                                                                        }
                                                                                                        if (value2 == null) {
                                                                                                            return;
                                                                                                        }
                                                                                                        bl3 = false;
                                                                                                    }
                                                                                                    if (!value2.isLong()) break block37;
                                                                                                    l3 = value2.asLong();
                                                                                                    if (l3 < 0L || l3 >= 64L) break block38;
                                                                                                    IO.write8u(dataOutput, (int)l3 + 64);
                                                                                                    break block39;
                                                                                                }
                                                                                                if (!value2.isBlock()) break block40;
                                                                                                l2 = value2.getHeader();
                                                                                                n4 = value2.getTag();
                                                                                                l = value2.getWoSize();
                                                                                                if (n4 == 250 && (!(value3 = value2.get0()).isBlock() || context.getCodeState().isAtom(value3) || value3.getTag() != 250 && value3.getTag() != 246 && value3.getTag() != 253)) break block41;
                                                                                                if (l != 0L) break block42;
                                                                                                if (n4 >= 16) break block43;
                                                                                                IO.write8u(dataOutput, 128 + n4);
                                                                                                break block44;
                                                                                            }
                                                                                            if (l3 >= -128L && l3 <= 127L) {
                                                                                                IO.write8u(dataOutput, 0);
                                                                                                IO.write8s(dataOutput, (int)l3);
                                                                                            } else if (l3 >= -32768L && l3 <= 32767L) {
                                                                                                IO.write8u(dataOutput, 1);
                                                                                                IO.write16s(dataOutput, (int)l3);
                                                                                            } else if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) {
                                                                                                IO.write8u(dataOutput, 3);
                                                                                                IO.write64s(dataOutput, l3);
                                                                                            } else {
                                                                                                IO.write8u(dataOutput, 2);
                                                                                                IO.write32s(dataOutput, (int)l3);
                                                                                            }
                                                                                        }
                                                                                        bl3 = true;
                                                                                        continue;
                                                                                    }
                                                                                    if (value2.isCodeOffset()) {
                                                                                        int n5 = (int)value2.asCodeOffset();
                                                                                        CodeState.Fragment fragment = context.getCodeState().getFragment(n5);
                                                                                        if (!bl2 || fragment == null) {
                                                                                            Fail.invalidArgument("output_value: functional value");
                                                                                        }
                                                                                        IO.write8u(dataOutput, 16);
                                                                                        IO.write32s(dataOutput, n5 - fragment.codeStart);
                                                                                        dataOutput.write(fragment.codeDigest);
                                                                                        bl3 = true;
                                                                                        continue;
                                                                                    }
                                                                                    break block45;
                                                                                }
                                                                                value2 = value3;
                                                                                continue;
                                                                            }
                                                                            if (bl || n4 == 249) break block46;
                                                                            int n6 = MarshalExtern.indexOf(list, value2);
                                                                            if (n6 == -1) break block47;
                                                                            n2 = list.size() - n6;
                                                                            if (n2 >= 256) break block48;
                                                                            IO.write8u(dataOutput, 4);
                                                                            IO.write8u(dataOutput, n2);
                                                                            break block49;
                                                                        }
                                                                        IO.write8u(dataOutput, 8);
                                                                        IO.write32s(dataOutput, (int)l2);
                                                                    }
                                                                    bl3 = true;
                                                                    continue;
                                                                }
                                                                list.add(value2);
                                                                break block46;
                                                            }
                                                            if (n2 < 65536) {
                                                                IO.write8u(dataOutput, 5);
                                                                IO.write16u(dataOutput, n2);
                                                            } else {
                                                                IO.write8u(dataOutput, 6);
                                                                IO.write32s(dataOutput, n2);
                                                            }
                                                        }
                                                        bl3 = true;
                                                        continue;
                                                    }
                                                    switch (n4) {
                                                        case 252: {
                                                            n3 = (int)value2.sizeBytes();
                                                            if ((long)n3 >= 32L) break block50;
                                                            IO.write8u(dataOutput, 32 + n3);
                                                            break block51;
                                                        }
                                                        case 253: {
                                                            IO.write8u(dataOutput, CODE_DOUBLE_NATIVE);
                                                            if (!PlatformUtils.isBigEndianPlatform()) break block52;
                                                            IO.write64s(dataOutput, Double.doubleToRawLongBits(value2.asDouble()));
                                                            break block53;
                                                        }
                                                        case 254: {
                                                            n2 = (int)value2.sizeDoubles();
                                                            if (n2 >= 256) break block54;
                                                            IO.write8u(dataOutput, CODE_DOUBLE_ARRAY8_NATIVE);
                                                            IO.write8u(dataOutput, n2);
                                                            break block55;
                                                        }
                                                        case 251: {
                                                            Fail.invalidArgument("output_value: abstract value (Abstract)");
                                                            break block56;
                                                        }
                                                        case 249: {
                                                            BlockValue blockValue = value2.asBlock();
                                                            IO.write8u(dataOutput, 17);
                                                            IO.write32s(dataOutput, (int)(8L * blockValue.getWoSize()));
                                                            MarshalExtern.externRec(context, dataOutput, blockValue.getParent(), list, serializationSizes, bl, bl2);
                                                            break block56;
                                                        }
                                                        case 255: {
                                                            CustomOperations customOperations = value2.getCustomOperations();
                                                            if (!customOperations.isSerializable()) {
                                                                Fail.invalidArgument("output_value: abstract value (Custom)");
                                                            }
                                                            IO.write8u(dataOutput, 18);
                                                            dataOutput.write(EncodingUtils.convertStringToBytes(customOperations.getIdentifier()));
                                                            IO.write8u(dataOutput, 0);
                                                            CustomOperations.SerializationSizes serializationSizes2 = customOperations.serialize(dataOutput, value2);
                                                            serializationSizes.size32 += 2L + (serializationSizes2.size32 + 3L >> 2);
                                                            serializationSizes.size64 += 2L + (serializationSizes2.size64 + 7L >> 3);
                                                            break block56;
                                                        }
                                                        default: {
                                                            if (n4 >= 16 || l >= 8L) break block57;
                                                            IO.write8u(dataOutput, 128 + n4 + ((int)l << 4));
                                                            break;
                                                        }
                                                    }
                                                    break block58;
                                                }
                                                Fail.invalidArgument("output_value: abstract value (outside heap)");
                                                continue;
                                            }
                                            if ((long)n3 < 256L) {
                                                IO.write8u(dataOutput, 9);
                                                IO.write8u(dataOutput, n3);
                                            } else {
                                                IO.write8u(dataOutput, 10);
                                                IO.write32u(dataOutput, n3);
                                            }
                                        }
                                        dataOutput.write(value2.getBytes());
                                        serializationSizes.size32 += (long)(1 + (n3 + 4) / 4);
                                        serializationSizes.size64 += (long)(1 + (n3 + 8) / 8);
                                        break block56;
                                    }
                                    IO.write64s(dataOutput, Long.reverseBytes(Double.doubleToRawLongBits(value2.asDouble())));
                                }
                                serializationSizes.size32 += 3L;
                                serializationSizes.size64 += 2L;
                                break block56;
                            }
                            IO.write8u(dataOutput, CODE_DOUBLE_ARRAY32_NATIVE);
                            IO.write32u(dataOutput, n2);
                        }
                        if (PlatformUtils.isBigEndianPlatform()) {
                            for (n = 0; n < n2; ++n) {
                                IO.write64s(dataOutput, Double.doubleToRawLongBits(value2.getDouble(n)));
                            }
                        } else {
                            for (n = 0; n < n2; ++n) {
                                IO.write64s(dataOutput, Long.reverseBytes(Double.doubleToRawLongBits(value2.getDouble(n))));
                            }
                        }
                        serializationSizes.size32 += (long)(1 + n2 * 2);
                        serializationSizes.size64 += (long)(1 + n2);
                    }
                    bl3 = true;
                    continue;
                }
                if (l > Integer.MAX_VALUE) {
                    IO.write8u(dataOutput, 19);
                    IO.write64s(dataOutput, l2);
                } else {
                    IO.write8u(dataOutput, 8);
                    IO.write32s(dataOutput, (int)l2);
                }
            }
            serializationSizes.size32 += 1L + l;
            serializationSizes.size64 += 1L + l;
            Value value4 = value2.get0();
            if (l > 1L) {
                linkedList.add(0, new StackItem(value2, 1L, l));
            }
            value2 = value4;
        }
    }

    private static int indexOf(List<Value> list, Value value) {
        assert (list != null) : "null objTable";
        assert (value != null) : "null v";
        Iterator<Value> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Value value2 = iterator.next();
            boolean bl = value2.isBlock();
            boolean bl2 = value.isBlock();
            if (!(bl && bl2 && value2 == value || !bl && !bl2 && value2.getRawValue() == value.getRawValue())) {
                ++n;
                continue;
            }
            return n;
        }
        return -1;
    }

    private static final class StackItem {
        private final Value value;
        private long next;
        private final long size;

        StackItem(Value value, long l, long l2) {
            this.value = value;
            this.next = l;
            this.size = l2;
        }

        Value nextItem() {
            if (this.next < this.size) {
                Value value = this.value.get(this.next);
                ++this.next;
                return value;
            }
            return null;
        }
    }
}

