/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.values.Value;

public final class Primitives2Marshalled
extends AbstractPrimitivesConverter {
    private final FileOutputStream out;
    private final List<Value> values;

    private Primitives2Marshalled(String string, String string2) throws IOException {
        super(string, null);
        assert (string2 != null) : "null f";
        this.out = new FileOutputStream(string2);
        this.values = new ArrayList<Value>();
    }

    @Override
    protected void beforeWalk() {
        this.values.clear();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void visitClass(String string) {
        Object object;
        int n;
        ArrayList<Value> arrayList;
        ArrayList<Value[]> arrayList2;
        ArrayList<String> arrayList3;
        Object object2;
        try {
            Class<?> clazz = Class.forName(string);
            object2 = clazz.getAnnotation(PrimitiveProvider.class);
            if (object2 == null) return;
            arrayList3 = new ArrayList<String>();
            arrayList2 = new ArrayList<Value[]>();
            arrayList = new ArrayList<Value>();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n2 = methodArray.length;
            for (n = 0; n < n2; ++n) {
                object = methodArray[n];
                Primitive primitive = ((Method)object).getAnnotation(Primitive.class);
                if (primitive == null) continue;
                arrayList3.add(((Method)object).getName());
                arrayList2.add(Primitives2Marshalled.convertTypeArray(((Method)object).getParameterTypes(), primitive.parameterTypes()));
                arrayList.add(Primitives2Marshalled.convertType(((Method)object).getReturnType(), primitive.returnType()));
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return;
        }
        catch (Throwable throwable) {
            object2 = System.err;
            ((PrintStream)object2).printf("error: exception while processing class '%s'\n", string);
            throwable.printStackTrace((PrintStream)object2);
            System.exit(1);
            return;
        }
        {
            int n3 = arrayList3.size();
            Value value = Value.createBlock(0, n3);
            for (n = 0; n < n3; ++n) {
                object = Value.createBlock(0, Value.createString((String)arrayList3.get(n)), Value.createBlock(0, (Value[])arrayList2.get(n)), (Value)arrayList.get(n));
                value.set(n, (Value)object);
            }
            this.values.add(Value.createBlock(0, Value.createString(string), value));
        }
    }

    @Override
    protected void afterWalk() {
    }

    private void write() throws IOException {
        int n = this.values.size();
        Value value = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value.set(i, this.values.get(i));
        }
        try {
            ContextWithoutRuntimeLock contextWithoutRuntimeLock = new ContextWithoutRuntimeLock(Parameters.defaultByteCodeParameters(), false, new File("."));
            this.out.write(MarshalExtern.externValue(contextWithoutRuntimeLock, value, Value.EMPTY_LIST));
        }
        catch (Fail.Exception exception) {
            throw new IOException("error in marshalling");
        }
    }

    private static Value convertType(Class<?> clazz, String string) {
        block10: {
            block11: {
                block9: {
                    block7: {
                        block8: {
                            block6: {
                                block5: {
                                    block3: {
                                        block2: {
                                            block4: {
                                                assert (clazz != null) : "null t";
                                                assert (string != null) : "null a";
                                                if (Void.TYPE.equals(clazz)) break block2;
                                                if (Integer.TYPE.equals(clazz)) break block3;
                                                if (!Long.TYPE.equals(clazz)) break block4;
                                                if ("int".equals(string)) break block5;
                                                if ("int64".equals(string)) break block6;
                                                if (!"nativeint".equals(string)) break block7;
                                                break block8;
                                            }
                                            if (Double.TYPE.equals(clazz)) break block9;
                                            if (!Value.class.equals(clazz)) break block10;
                                            break block11;
                                        }
                                        return Value.ZERO;
                                    }
                                    return Value.ONE;
                                }
                                return Value.TWO;
                            }
                            return Value.THREE;
                        }
                        return Value.FOUR;
                    }
                    PrintStream printStream = System.err;
                    printStream.printf("error: cannot convert Java type '%s' with annotation '%s'\n", clazz.toString(), string);
                    System.exit(1);
                    return null;
                }
                return Value.FIVE;
            }
            return Value.SIX;
        }
        PrintStream printStream = System.err;
        printStream.printf("error: cannot convert Java type '%s'\n", clazz.toString());
        System.exit(1);
        return null;
    }

    private static Value[] convertTypeArray(Class<?>[] classArray, String[] stringArray) {
        assert (classArray != null) : "null t";
        assert (stringArray != null) : "null a";
        assert (classArray.length == stringArray.length) : "t and a should have the same length";
        int n = classArray.length;
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Primitives2Marshalled.convertType(classArray[i], stringArray[i]);
        }
        return valueArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        if (stringArray.length != 2) {
            printStream.println("error: a path, and a file should be provided");
            System.exit(1);
            return;
        }
        try {
            Primitives2Marshalled primitives2Marshalled = new Primitives2Marshalled(stringArray[0], stringArray[1]);
            primitives2Marshalled.walkFileTree();
            primitives2Marshalled.write();
        }
        catch (IOException iOException) {
            printStream.printf("i/o error: %s\n", iOException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

