/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="TimeUnit", source="")
public final class TimeUnit {
    private TimeUnit() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"TimeUnit.t", "TimeUnit.t", "int64"}, returnType="int64")
    public static Value ocamljava_timeunit_convert(Value value, Value value2, Value value3) {
        java.util.concurrent.TimeUnit timeUnit = TimeUnit.decode(value);
        java.util.concurrent.TimeUnit timeUnit2 = TimeUnit.decode(value2);
        long l = value3.asInt64();
        long l2 = timeUnit2.convert(l, timeUnit);
        return Value.createInt64(l2);
    }

    static java.util.concurrent.TimeUnit decode(Value value) {
        switch ((int)value.asLong()) {
            default: {
                assert (false) : "should not happen";
                break;
            }
            case 0: {
                return java.util.concurrent.TimeUnit.NANOSECONDS;
            }
            case 1: {
                return java.util.concurrent.TimeUnit.MICROSECONDS;
            }
            case 2: {
                return java.util.concurrent.TimeUnit.MILLISECONDS;
            }
            case 3: {
                return java.util.concurrent.TimeUnit.SECONDS;
            }
            case 4: {
                return java.util.concurrent.TimeUnit.MINUTES;
            }
            case 5: {
                return java.util.concurrent.TimeUnit.HOURS;
            }
            case 6: {
                return java.util.concurrent.TimeUnit.DAYS;
            }
        }
        return null;
    }
}

