/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.values.Value;

public final class Fail {
    private static final ThreadLocal<Value> BACKTRACE = ThreadLocalFactory.backTraceStorage();
    private static final int OUT_OF_MEMORY_EXCEPTION = 0;
    private static final int SYS_ERROR_EXCEPTION = 1;
    private static final int FAILURE_EXCEPTION = 2;
    private static final int INVALID_EXCEPTION = 3;
    private static final int END_OF_FILE_EXCEPTION = 4;
    private static final int ZERO_DIVIDE_EXCEPTION = 5;
    private static final int NOT_FOUND_EXCEPTION = 6;
    private static final int MATCH_FAILURE_EXCEPTION = 7;
    private static final int STACK_OVERFLOW_EXCEPTION = 8;
    private static final int SYS_BLOCKED_IO_EXCEPTION = 9;
    private static final int ASSERT_FAILURE_EXCEPTION = 10;
    private static final int UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11;
    private static final int JAVA_EXCEPTION = 12;

    private Fail() {
    }

    public static void raise(Value value) throws Exception {
        assert (value != null) : "null v";
        throw new Exception(Kind.VALUE, value, null);
    }

    public static void raiseWithConstant(Value value) throws Exception {
        assert (value != null) : "null tag";
        Fail.raise(Value.createBlock(0, value));
    }

    public static void raiseWithArg(Value value, Value value2) throws Exception {
        assert (value != null) : "null tag";
        assert (value2 != null) : "null arg";
        Fail.raise(Value.createBlock(0, value, value2));
    }

    public static void raiseWithArgs(Value value, Value ... valueArray) throws Exception {
        assert (value != null) : "null tag";
        assert (valueArray != null) : "null args";
        int n = valueArray.length;
        Value value2 = Value.createBlock(0, 1 + n);
        value2.set0(value);
        for (int i = 0; i < n; ++i) {
            value2.set(1 + i, valueArray[i]);
        }
        Fail.raise(value2);
    }

    public static void raiseWithString(Value value, String string) throws Exception {
        assert (value != null) : "null tag";
        assert (string != null) : "null msg";
        Fail.raiseWithArg(value, Value.createString(string));
    }

    public static Exception createConstantFromField(Kind kind) {
        assert (kind != null) : "null k";
        assert (kind != Kind.VALUE) : "k should not equal Kind.VALUE";
        return new Exception(kind, null, null);
    }

    public static Exception createWithArg(Value value, Value value2) {
        assert (value != null) : "null tag";
        assert (value2 != null) : "null arg";
        return new Exception(Kind.VALUE, Value.createBlock(0, value, value2), null);
    }

    public static Exception createWithString(Value value, String string) {
        assert (value != null) : "null tag";
        assert (string != null) : "null msg";
        return Fail.createWithArg(value, Value.createString(string));
    }

    private static void raiseConstantFromField(Kind kind) throws Exception {
        assert (kind != null) : "null k";
        assert (kind != Kind.VALUE) : "k should not equal Kind.VALUE";
        throw new Exception(kind, null, null);
    }

    private static void raiseWithStringFromField(Kind kind, String string) throws Exception {
        assert (kind != null) : "null k";
        assert (kind != Kind.VALUE) : "k should not equal Kind.VALUE";
        throw new Exception(kind, null, string);
    }

    public static void failWith(String string) throws Exception {
        assert (string != null) : "null msg";
        Fail.raiseWithStringFromField(Kind.FAILURE, string);
    }

    public static void invalidArgument(String string) throws Exception {
        assert (string != null) : "null msg";
        Fail.raiseWithStringFromField(Kind.INVALID, string);
    }

    public static void arrayBoundError() throws Exception {
        Fail.invalidArgument("index out of bounds");
    }

    public static void raiseOutOfMemory() throws Exception {
        Fail.raiseConstantFromField(Kind.OUT_OF_MEMORY);
    }

    public static void raiseStackOverflow() throws Exception {
        Fail.raiseConstantFromField(Kind.STACK_OVERFLOW);
    }

    public static void raiseSysError(String string) throws Exception {
        Fail.raiseWithStringFromField(Kind.SYS_ERROR, string);
    }

    public static void raiseEndOfFile() throws Exception {
        Fail.raiseConstantFromField(Kind.END_OF_FILE);
    }

    public static void raiseZeroDivide() throws Exception {
        Fail.raiseConstantFromField(Kind.ZERO_DIVIDE);
    }

    public static void raiseNotFound() throws Exception {
        Fail.raiseConstantFromField(Kind.NOT_FOUND);
    }

    public static void raiseSysBlockedIO() throws Exception {
        Fail.raiseConstantFromField(Kind.SYS_BLOCKED_IO);
    }

    static Exception createZeroDivide() {
        return new Exception(Kind.ZERO_DIVIDE, null, null);
    }

    static Exception createStackOverflow() {
        return new Exception(Kind.STACK_OVERFLOW, null, null);
    }

    public static void whereami() {
        try {
            throw new Throwable();
        }
        catch (Throwable throwable) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 1; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                System.out.printf(" *** %s.%s(%s:%d)\n", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
            return;
        }
    }

    public static Value asValue(Throwable throwable) throws Fatal.Exception, FalseExit {
        if (!(throwable instanceof Exception)) {
            if (throwable instanceof Fatal.Exception) {
                throw (Fatal.Exception)throwable;
            }
            if (throwable instanceof FalseExit) {
                throw (FalseExit)throwable;
            }
        } else {
            return ((Exception)throwable).asValue();
        }
        System.out.println("Fatal Java exception: " + throwable.toString());
        Fail.whereami();
        throwable.printStackTrace(System.out);
        System.exit(1);
        return null;
    }

    public static final class Exception
    extends java.lang.Exception {
        static final long serialVersionUID = -7455675788690537618L;
        private final Kind kind;
        private final Value value;
        private final String msg;

        public Exception(Value value) {
            this.kind = Kind.VALUE;
            this.value = value;
            this.msg = null;
        }

        private Exception(Kind kind, Value value, String string) {
            super(kind.toString());
            this.kind = kind;
            this.value = value;
            this.msg = string;
        }

        private Kind getKind() {
            return this.kind;
        }

        private Value getValue() {
            return this.value;
        }

        public Value asValue() {
            Value value;
            block1: {
                block2: {
                    block0: {
                        AbstractNativeRunner abstractNativeRunner = (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
                        abstractNativeRunner.setBacktraceInfo(this);
                        if (this.kind == Kind.VALUE) break block0;
                        value = abstractNativeRunner.getGlobalFromInstance(this.kind.getPredefName());
                        if (this.msg == null) break block1;
                        break block2;
                    }
                    return this.value;
                }
                return Value.createBlock(0, value, Value.createString(this.msg));
            }
            return Value.createBlock(0, value);
        }

        public Value asValue(Value value) {
            Value value2;
            block1: {
                block2: {
                    block0: {
                        if (this.kind == Kind.VALUE) break block0;
                        value2 = value.get(this.kind.getIndex());
                        if (this.msg == null) break block1;
                        break block2;
                    }
                    return this.value;
                }
                return Value.createBlock(0, value2, Value.createString(this.msg));
            }
            return Value.createBlock(0, value2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return BACKTRACE.get() == Value.TRUE ? super.fillInStackTrace() : this;
        }
    }

    public static enum Kind {
        VALUE(-1, null),
        FAILURE(2, "Failure"),
        INVALID(3, "Invalid_argument"),
        OUT_OF_MEMORY(0, "Out_of_memory"),
        STACK_OVERFLOW(8, "Stack_overflow"),
        SYS_ERROR(1, "Sys_error"),
        END_OF_FILE(4, "End_of_file"),
        ZERO_DIVIDE(5, "Division_by_zero"),
        NOT_FOUND(6, "Not_found"),
        SYS_BLOCKED_IO(9, "Sys_blocked_io");

        private final int index;
        private final String predefName;

        private Kind(int n2, String string2) {
            this.index = n2;
            this.predefName = "caml_exn_" + string2;
        }

        private int getIndex() {
            return this.index;
        }

        private String getPredefName() {
            return this.predefName;
        }
    }
}

