/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/itimer.c")
public final class Itimer {
    private static final Object[] SLOTS = new Object[]{new Object(), new Object(), new Object()};
    private static final SignalKind[] SIGNALS = new SignalKind[]{SignalKind.ALRM, SignalKind.VTALRM, SignalKind.PROF};

    private Itimer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"All three timers are based on real time."}, parameterTypes={"Unix.interval_timer", "Unix.interval_timer_status"}, returnType="Unix.interval_timer_status")
    public static Value unix_setitimer(Value value, Value value2) {
        long l;
        long l2;
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        Context context = codeRunner.getContext();
        long l3 = (long)(value2.getDouble0() * 1000.0);
        long l4 = (long)(value2.getDouble1() * 1000.0);
        int n = value.asCastedInt();
        Unix.AlarmThread alarmThread = (Unix.AlarmThread)context.getCodeState().getSlot(SLOTS[n]);
        if (alarmThread != null) {
            l2 = alarmThread.getInterval();
            l = alarmThread.unactivate();
        } else {
            l2 = 0L;
            l = 0L;
        }
        if (l4 == 0L) return Itimer.createStatus(l2, l);
        context.getCodeState().registerSlot(SLOTS[n], new Unix.AlarmThread(codeRunner, l4, l3, SIGNALS[n]));
        return Itimer.createStatus(l2, l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.interval_timer"}, returnType="Unix.interval_timer_status")
    public static Value unix_getitimer(Value value) {
        long l;
        long l2;
        Unix.AlarmThread alarmThread = (Unix.AlarmThread)CurrentContext.CODE_STATE.getSlot(SLOTS[value.asCastedInt()]);
        if (alarmThread != null) {
            l2 = alarmThread.getInterval();
            l = alarmThread.getValue();
        } else {
            l2 = 0L;
            l = 0L;
        }
        return Itimer.createStatus(l2, l);
    }

    private static Value createStatus(long l, long l2) {
        return Value.createDoubleArray((double)l / 1000.0, (double)l2 / 1000.0);
    }
}

