/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.values.Value;

public final class Fail {
    private static final ThreadLocal<Value> BACKTRACE = ThreadLocalFactory.backTraceStorage();
    private static final int OUT_OF_MEMORY_EXCEPTION = 0;
    private static final int SYS_ERROR_EXCEPTION = 1;
    private static final int FAILURE_EXCEPTION = 2;
    private static final int INVALID_EXCEPTION = 3;
    private static final int END_OF_FILE_EXCEPTION = 4;
    private static final int ZERO_DIVIDE_EXCEPTION = 5;
    private static final int NOT_FOUND_EXCEPTION = 6;
    private static final int MATCH_FAILURE_EXCEPTION = 7;
    private static final int STACK_OVERFLOW_EXCEPTION = 8;
    private static final int SYS_BLOCKED_IO_EXCEPTION = 9;
    private static final int ASSERT_FAILURE_EXCEPTION = 10;
    private static final int UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11;
    private static final int JAVA_EXCEPTION = 12;

    private Fail() {
    }

    public static void raise(Value v) throws Exception {
        assert (v != null) : "null v";
        throw new Exception(Kind.VALUE, v, null);
    }

    public static void raiseWithConstant(Value tag) throws Exception {
        assert (tag != null) : "null tag";
        Fail.raise(Value.createBlock(0, tag));
    }

    public static void raiseWithArg(Value tag, Value arg) throws Exception {
        assert (tag != null) : "null tag";
        assert (arg != null) : "null arg";
        Fail.raise(Value.createBlock(0, tag, arg));
    }

    public static void raiseWithArgs(Value tag, Value ... args) throws Exception {
        assert (tag != null) : "null tag";
        assert (args != null) : "null args";
        int len = args.length;
        Value b = Value.createBlock(0, 1 + len);
        b.set0(tag);
        for (int i = 0; i < len; ++i) {
            b.set(1 + i, args[i]);
        }
        Fail.raise(b);
    }

    public static void raiseWithString(Value tag, String msg) throws Exception {
        assert (tag != null) : "null tag";
        assert (msg != null) : "null msg";
        Fail.raiseWithArg(tag, Value.createString(msg));
    }

    public static Exception createConstantFromField(Kind k) {
        assert (k != null) : "null k";
        assert (k != Kind.VALUE) : "k should not equal Kind.VALUE";
        return new Exception(k, null, null);
    }

    public static Exception createWithArg(Value tag, Value arg) {
        assert (tag != null) : "null tag";
        assert (arg != null) : "null arg";
        return new Exception(Kind.VALUE, Value.createBlock(0, tag, arg), null);
    }

    public static Exception createWithString(Value tag, String msg) {
        assert (tag != null) : "null tag";
        assert (msg != null) : "null msg";
        return Fail.createWithArg(tag, Value.createString(msg));
    }

    private static void raiseConstantFromField(Kind k) throws Exception {
        assert (k != null) : "null k";
        assert (k != Kind.VALUE) : "k should not equal Kind.VALUE";
        throw new Exception(k, null, null);
    }

    private static void raiseWithStringFromField(Kind k, String msg) throws Exception {
        assert (k != null) : "null k";
        assert (k != Kind.VALUE) : "k should not equal Kind.VALUE";
        throw new Exception(k, null, msg);
    }

    public static void failWith(String msg) throws Exception {
        assert (msg != null) : "null msg";
        Fail.raiseWithStringFromField(Kind.FAILURE, msg);
    }

    public static void invalidArgument(String msg) throws Exception {
        assert (msg != null) : "null msg";
        Fail.raiseWithStringFromField(Kind.INVALID, msg);
    }

    public static void arrayBoundError() throws Exception {
        Fail.invalidArgument("index out of bounds");
    }

    public static void raiseOutOfMemory() throws Exception {
        Fail.raiseConstantFromField(Kind.OUT_OF_MEMORY);
    }

    public static void raiseStackOverflow() throws Exception {
        Fail.raiseConstantFromField(Kind.STACK_OVERFLOW);
    }

    public static void raiseSysError(String msg) throws Exception {
        Fail.raiseWithStringFromField(Kind.SYS_ERROR, msg);
    }

    public static void raiseEndOfFile() throws Exception {
        Fail.raiseConstantFromField(Kind.END_OF_FILE);
    }

    public static void raiseZeroDivide() throws Exception {
        Fail.raiseConstantFromField(Kind.ZERO_DIVIDE);
    }

    public static void raiseNotFound() throws Exception {
        Fail.raiseConstantFromField(Kind.NOT_FOUND);
    }

    public static void raiseSysBlockedIO() throws Exception {
        Fail.raiseConstantFromField(Kind.SYS_BLOCKED_IO);
    }

    static Exception createZeroDivide() {
        return new Exception(Kind.ZERO_DIVIDE, null, null);
    }

    static Exception createStackOverflow() {
        return new Exception(Kind.STACK_OVERFLOW, null, null);
    }

    public static void whereami() {
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            StackTraceElement[] elems = t.getStackTrace();
            int len = elems.length;
            for (int i = 1; i < len; ++i) {
                StackTraceElement e = elems[i];
                System.out.printf(" *** %s.%s(%s:%d)\n", e.getClassName(), e.getMethodName(), e.getFileName(), e.getLineNumber());
            }
            return;
        }
    }

    public static Value asValue(Throwable t) throws Fatal.Exception, FalseExit {
        if (t instanceof Exception) {
            return ((Exception)t).asValue();
        }
        if (t instanceof Fatal.Exception) {
            throw (Fatal.Exception)t;
        }
        if (t instanceof FalseExit) {
            throw (FalseExit)t;
        }
        System.out.println("Fatal Java exception: " + t.toString());
        Fail.whereami();
        t.printStackTrace(System.out);
        System.exit(1);
        return null;
    }

    public static final class Exception
    extends java.lang.Exception {
        static final long serialVersionUID = -7455675788690537618L;
        private final Kind kind;
        private final Value value;
        private final String msg;

        public Exception(Value v) {
            this.kind = Kind.VALUE;
            this.value = v;
            this.msg = null;
        }

        private Exception(Kind k, Value v, String m) {
            super(k.toString());
            this.kind = k;
            this.value = v;
            this.msg = m;
        }

        private Kind getKind() {
            return this.kind;
        }

        private Value getValue() {
            return this.value;
        }

        public Value asValue() {
            AbstractNativeRunner runner = (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
            runner.setBacktraceInfo(this);
            if (this.kind == Kind.VALUE) {
                return this.value;
            }
            Value tag = runner.getGlobalFromInstance(this.kind.getPredefName());
            if (this.msg != null) {
                return Value.createBlock(0, tag, Value.createString(this.msg));
            }
            return Value.createBlock(0, tag);
        }

        public Value asValue(Value globalData) {
            if (this.kind == Kind.VALUE) {
                return this.value;
            }
            Value tag = globalData.get(this.kind.getIndex());
            if (this.msg != null) {
                return Value.createBlock(0, tag, Value.createString(this.msg));
            }
            return Value.createBlock(0, tag);
        }

        @Override
        public Throwable fillInStackTrace() {
            return BACKTRACE.get() == Value.TRUE ? super.fillInStackTrace() : this;
        }
    }

    public static enum Kind {
        VALUE(-1, null),
        FAILURE(2, "Failure"),
        INVALID(3, "Invalid_argument"),
        OUT_OF_MEMORY(0, "Out_of_memory"),
        STACK_OVERFLOW(8, "Stack_overflow"),
        SYS_ERROR(1, "Sys_error"),
        END_OF_FILE(4, "End_of_file"),
        ZERO_DIVIDE(5, "Division_by_zero"),
        NOT_FOUND(6, "Not_found"),
        SYS_BLOCKED_IO(9, "Sys_blocked_io");

        private final int index;
        private final String predefName;

        private Kind(int idx, String predef) {
            this.index = idx;
            this.predefName = "caml_exn_" + predef;
        }

        private int getIndex() {
            return this.index;
        }

        private String getPredefName() {
            return this.predefName;
        }
    }
}

