/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlList<T extends OCamlValue>
extends OCamlValue
implements Iterable<T> {
    private final Wrapper<T> wrapper;

    private OCamlList(Wrapper<T> w, Value v) {
        super(v);
        assert (w != null) : "null w";
        this.wrapper = w;
    }

    public Wrapper<? extends OCamlList<T>> getWrapper() {
        return OCamlList.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        switch (idx) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public boolean isEmpty() {
        return this.value.isLong();
    }

    public long length() {
        long res = 0L;
        Value curr = this.value;
        while (curr.isBlock()) {
            ++res;
            curr = curr.get1();
        }
        return res;
    }

    public T head() {
        if (this.value.isBlock()) {
            return this.wrapper.wrap(this.value.get0());
        }
        return null;
    }

    public OCamlList<T> tail() {
        if (this.value.isBlock()) {
            return new OCamlList<T>(this.wrapper, this.value.get1());
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Value next;
            {
                this.next = OCamlList.this.value;
            }

            @Override
            public boolean hasNext() {
                return this.next.isBlock();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Value res = this.next.get0();
                    this.next = this.next.get1();
                    return OCamlList.this.wrapper.wrap(res);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlList) {
            OCamlList that = (OCamlList)obj;
            return this == that;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlList(");
        Value curr = this.value;
        while (curr.isBlock() && sb.length() < 256) {
            if (curr != this.value) {
                sb.append(", ");
            }
            Value v = curr.get0();
            curr = curr.get1();
            T w = this.wrapper.wrap(v);
            sb.append(((OCamlValue)w).toString());
        }
        if (curr.isBlock()) {
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public static <T extends OCamlValue> OCamlList<T> create(Wrapper<T> w, List<T> v) {
        assert (w != null) : "null w";
        assert (v != null) : "null v";
        Value wrapped = Value.EMPTY_LIST;
        ListIterator<T> it = v.listIterator(v.size());
        OCamlValue e = null;
        while (it.hasPrevious()) {
            e = (OCamlValue)it.previous();
            wrapped = Value.createBlock(0, e.value(), wrapped);
        }
        return new OCamlList<T>(w, wrapped);
    }

    public static <T extends OCamlValue> OCamlList<T> create(Wrapper<T> w) {
        assert (w != null) : "null w";
        return new OCamlList<T>(w, Value.EMPTY_LIST);
    }

    public static <T extends OCamlValue> OCamlList<T> create(T hd, OCamlList<T> tl) {
        assert (hd != null) : "null hd";
        assert (tl != null) : "null tl";
        Value v = Value.createBlock(0, hd.value(), tl.value());
        return new OCamlList<OCamlValue>(hd.getWrapper(), v);
    }

    public static <T extends OCamlValue> OCamlList<T> wrap(Wrapper<T> w, Value v) {
        assert (w != null) : "null w";
        assert (v != null) : "null v";
        return new OCamlList<T>(w, v);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlList<T>> wrapper(final Wrapper<T> w) {
        return new ComposedWrapper<OCamlList<T>>(new Wrapper[]{w}){

            @Override
            public OCamlList<T> wrap(Value v) {
                return new OCamlList(w, v);
            }
        };
    }
}

