/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import java.io.File;
import java.util.ArrayList;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.labltk.CamlCallbackCommand;
import org.ocamljava.runtime.primitives.otherlibs.labltk.Misc;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkMain.c")
public final class CltkMain {
    private static final String RCNAME = ".camltkrc";
    private static final String CAMLCB = "camlcb";

    private CltkMain() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string list"}, returnType="unit")
    public static Value camltk_opentk(Value argv) throws Fail.Exception {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Context ctxt = runner.getContext();
        CodeState codeState = ctxt.getCodeState();
        TKSlot slot = (TKSlot)codeState.getSlot(TKSlot.SLOT);
        Interp interp = null;
        if (argv == Value.EMPTY_LIST) {
            Fail.failWith((String)"camltk_opentk: argv is empty");
        }
        String argv0 = argv.get0().asString();
        try {
            int idxName;
            interp = new Interp();
            slot.setInterpreter(interp);
            Value interpCaml = codeState.getCallback("cltclinterp");
            if (interpCaml != null) {
                interpCaml.set0(Value.createInstance((Object)interp));
            }
            interp.setVar("argv0", TclString.newInstance((String)argv0), 1);
            Value tmp = argv.get1();
            int argc = 0;
            TclObject tclArgv = TclList.newInstance();
            ArrayList<String> args = new ArrayList<String>();
            while (tmp != Value.EMPTY_LIST) {
                String s = tmp.get0().asString();
                args.add(s);
                TclList.append((Interp)interp, (TclObject)tclArgv, (TclObject)TclString.newInstance((String)s));
                tmp = tmp.get1();
                ++argc;
            }
            if (argc != 0) {
                interp.setVar("argv", tclArgv, 1);
                interp.setVar("argc", TclInteger.newInstance((int)argc), 1);
            }
            Misc.evalResource(interp, "/com/onemoonscientific/swank/library/init.tcl");
            int size = args.size();
            int idxGeometry = args.indexOf("-geometry");
            if (idxGeometry >= 0 && idxGeometry < size - 1) {
                Misc.eval(interp, "wm geometry . " + (String)args.get(idxGeometry + 1));
            }
            if ((idxName = args.indexOf("-name")) >= 0 && idxName < size - 1) {
                StringBuilder sb = new StringBuilder();
                block13: for (char ch : ((String)args.get(idxName + 1)).toCharArray()) {
                    switch (ch) {
                        case '\"': {
                            sb.append("\\\"");
                            continue block13;
                        }
                        case '\\': {
                            sb.append("\\\\");
                            continue block13;
                        }
                        default: {
                            sb.append(ch);
                        }
                    }
                }
                Misc.eval(interp, "wm title . \"" + sb.toString() + "\"");
            }
        }
        catch (TclException te) {
            slot.tkError(te);
        }
        try {
            interp.createCommand(CAMLCB, (Command)new CamlCallbackCommand(runner, slot));
            interp.setVar("tcl_interactive", TclString.newInstance((String)"0"), 1);
            interp.setVar("BreakBindingsSequence", TclString.newInstance((String)"0"), 1);
        }
        catch (TclException te) {
            slot.tkError(te);
        }
        try {
            String file;
            String home = System.getenv("HOME");
            if (home != null && new File(file = home + "/" + RCNAME).canRead()) {
                try {
                    Misc.evalFile(interp, file);
                }
                catch (TclException te) {
                    slot.tkError(te);
                }
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value camltk_finalize(Value unit) throws Fail.Exception {
        try {
            Misc.disposeInterp(TKSlot.checkInit().getInterpreter());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Value.UNIT;
    }
}

