/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMSlot;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMVariable;
import org.ocamljava.runtime.values.Value;

final class STMTransaction
implements Comparable<STMTransaction> {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int identifier = NEXT_ID.getAndIncrement();
    private final int readVersion;
    private final SortedMap<STMVariable, Value> writeSet;
    private final SortedSet<STMVariable> readSet;
    private final Thread originalThread;
    private boolean invalidated;

    STMTransaction(int n) {
        this.readVersion = n;
        this.writeSet = new TreeMap<STMVariable, Value>();
        this.readSet = new TreeSet<STMVariable>();
        this.invalidated = false;
        this.originalThread = Thread.currentThread();
    }

    long getReadVersion() {
        return this.readVersion;
    }

    Value readVariable(STMVariable sTMVariable) throws Fail.Exception {
        block1: {
            Value value;
            block2: {
                Value value2;
                block0: {
                    this.checkNotInvalidated();
                    value2 = (Value)this.writeSet.get(sTMVariable);
                    if (value2 != null) break block0;
                    value = sTMVariable.get();
                    if (sTMVariable.getWriteLock().availablePermits() <= 0 || sTMVariable.getVersionNumber() > this.readVersion) break block1;
                    break block2;
                }
                return value2;
            }
            this.readSet.add(sTMVariable);
            return value;
        }
        this.invalidate();
        STMTransaction.raiseRetry();
        return null;
    }

    void writeVariable(STMVariable sTMVariable, Value value) throws Fail.Exception {
        this.checkNotInvalidated();
        this.writeSet.put(sTMVariable, value);
    }

    void commit() throws Fail.Exception {
        for (STMVariable iterator2 : this.writeSet.keySet()) {
            iterator2.getWriteLock().acquireUninterruptibly(1);
        }
        int n = STMSlot.get().getGlobalVersionClock().incrementAndGet();
        Iterator iterator = this.readSet.iterator();
        while (true) {
            Object object;
            Object object2;
            if (iterator.hasNext()) {
                STMVariable sTMVariable = (STMVariable)iterator.next();
                if ((this.writeSet.keySet().contains(sTMVariable) || sTMVariable.getWriteLock().availablePermits() != 0) && sTMVariable.getVersionNumber() <= this.readVersion) continue;
                object2 = this.writeSet.keySet().iterator();
            } else {
                for (Map.Entry<STMVariable, Value> entry : this.writeSet.entrySet()) {
                    object2 = entry.getKey();
                    object = entry.getValue();
                    ((STMVariable)object2).set((Value)object, n);
                }
                break;
            }
            while (object2.hasNext()) {
                object = (STMVariable)object2.next();
                ((STMVariable)object).getWriteLock().release();
            }
            this.invalidate();
            STMTransaction.raiseRetry();
        }
        for (STMVariable sTMVariable : this.writeSet.keySet()) {
            sTMVariable.getWriteLock().release();
        }
        this.invalidate();
    }

    void invalidate() {
        this.invalidated = true;
        this.writeSet.clear();
        this.readSet.clear();
    }

    void checkNotInvalidated() throws Fail.Exception {
        if (this.invalidated) {
            Fail.failWith("Invalidated transaction");
        }
        if (Thread.currentThread() != this.originalThread) {
            Fail.failWith("Accessor called from another thread");
        }
    }

    public int hashCode() {
        return this.identifier;
    }

    public boolean equals(Object object) {
        if (object instanceof STMTransaction) {
            STMTransaction sTMTransaction = (STMTransaction)object;
            return sTMTransaction.identifier == this.identifier;
        }
        return false;
    }

    @Override
    public int compareTo(STMTransaction sTMTransaction) {
        return Integer.compare(this.identifier, sTMTransaction.identifier);
    }

    static void raiseRetry() throws Fail.Exception {
        Value value = CurrentContext.CODE_STATE.getCallback("Concurrent.STM.Retry");
        if (value != null) {
            Fail.raiseWithConstant(value);
        } else {
            Fail.invalidArgument("Exception Concurrent.STM.Retry not initialized");
        }
    }
}

