/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeBasicBlockValue
extends AbstractBasicBlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private Value[][] values;

    LargeBasicBlockValue(int n, long l) {
        super(n, l);
        int n2 = (int)(l >> 31) + 1;
        int n3 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new Value[n2][];
        int n4 = 0;
        while (true) {
            if (n4 >= n2 - 1) {
                this.values[n2 - 1] = new Value[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    this.values[n2 - 1][n4] = Value.ZERO;
                }
                break;
            }
            this.values[n4] = new Value[Integer.MIN_VALUE];
            for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                this.values[n4][i] = Value.ZERO;
            }
            ++n4;
        }
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        return this.values[n][n2];
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[0][n];
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        this.values[n][n2] = value;
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.values[0][n] = value;
    }

    @Override
    public long sizeValues() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long l) {
        Value[][] valueArray = this.values;
        int n = (int)(l >> 31) + 1;
        int n2 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new Value[n][];
        int n3 = 0;
        while (true) {
            if (n3 >= n - 1) {
                this.values[n - 1] = new Value[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.values[n - 1][n3] = valueArray[n - 1][n3];
                }
                break;
            }
            this.values[n3] = new Value[Integer.MIN_VALUE];
            for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                this.values[n3][i] = valueArray[n3][i];
            }
            ++n3;
        }
    }

    @Override
    public void copy(BlockValue blockValue) {
        long l = Math.min(this.length, blockValue.sizeValues());
        for (long i = 0L; i < l; ++i) {
            this.set(i, blockValue.get(i));
        }
    }

    @Override
    public LargeBasicBlockValue duplicate() {
        long l = this.length;
        LargeBasicBlockValue largeBasicBlockValue = new LargeBasicBlockValue(this.getTag(), l);
        for (long i = 0L; i < l; ++i) {
            largeBasicBlockValue.set(i, this.get(i));
        }
        return largeBasicBlockValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        int n = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < n; ++i) {
            valueArray[i] = this.get(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < n2; ++i) {
            valueArray[n + i] = this.get(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.get(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeValues());
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.get(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        LargeBasicBlockValue largeBasicBlockValue = new LargeBasicBlockValue(this.getTag(), l2);
        for (long i = 0L; i < l2; ++i) {
            largeBasicBlockValue.set(i, this.get(i + l));
        }
        return largeBasicBlockValue;
    }

    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (l2 < l) {
            for (long i = 0L; i < l3; ++i) {
                value.set(l2 + i, this.get(l + i));
            }
        } else {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value.set(l2 + i, this.get(l + i));
            }
        }
    }

    public int hashCode() {
        int n = 0;
        Value[] valueArray = this.values[0];
        int n2 = Math.min(32, valueArray.length);
        for (int i = 0; i < n2; ++i) {
            n += valueArray[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof LargeBasicBlockValue) {
            LargeBasicBlockValue largeBasicBlockValue = (LargeBasicBlockValue)object;
            int n = this.values.length;
            int n2 = largeBasicBlockValue.values.length;
            if (n == n) {
                int n3;
                for (n3 = 0; n3 < n && Arrays.equals(this.values[n3], largeBasicBlockValue.values[n3]); ++n3) {
                }
                return n3 == n;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LargeBasicBlockValue(");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.values[i].length;
            for (int j = 0; j < n2; ++j) {
                if (i + j != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.values[i][j]);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long l) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(l));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        assert (value != null) : "null x";
        this.set(l, value);
    }

    @Override
    public long sizeLongs() {
        return this.length;
    }

    @Override
    public long sizeDoubles() {
        return this.length;
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        this.set(n, Value.createFromRawLong(l));
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        this.set(l, Value.createFromRawLong(l2));
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        return this.get(n).getRawValue();
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        return this.get(l).getRawValue();
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.set(n, Value.createDouble(d));
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.set(l, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.get(n).asDouble();
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.get(l).asDouble();
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.set(n, Value.createDouble(d));
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.set(l, Value.createDouble(d));
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.get(n).asDouble();
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.get(l).asDouble();
    }

    @Override
    public void setRawLong0(long l) {
        this.set(0, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong0() {
        return this.get(0).getRawValue();
    }

    @Override
    public void setGenericDouble0(double d) {
        this.set(0, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble0() {
        return this.get(0).asDouble();
    }

    @Override
    public void setDouble0(double d) {
        this.set(0, Value.createDouble(d));
    }

    @Override
    public double getDouble0() {
        return this.get(0).asDouble();
    }

    @Override
    public void set0(Value value) {
        this.set(0, value);
    }

    @Override
    public Value get0() {
        return this.get(0);
    }

    @Override
    public void setRawLong1(long l) {
        this.set(1, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong1() {
        return this.get(1).getRawValue();
    }

    @Override
    public void setGenericDouble1(double d) {
        this.set(1, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble1() {
        return this.get(1).asDouble();
    }

    @Override
    public void setDouble1(double d) {
        this.set(1, Value.createDouble(d));
    }

    @Override
    public double getDouble1() {
        return this.get(1).asDouble();
    }

    @Override
    public void set1(Value value) {
        this.set(1, value);
    }

    @Override
    public Value get1() {
        return this.get(1);
    }

    @Override
    public void setRawLong2(long l) {
        this.set(2, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong2() {
        return this.get(2).getRawValue();
    }

    @Override
    public void setGenericDouble2(double d) {
        this.set(2, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble2() {
        return this.get(2).asDouble();
    }

    @Override
    public void setDouble2(double d) {
        this.set(2, Value.createDouble(d));
    }

    @Override
    public double getDouble2() {
        return this.get(2).asDouble();
    }

    @Override
    public void set2(Value value) {
        this.set(2, value);
    }

    @Override
    public Value get2() {
        return this.get(2);
    }

    @Override
    public void setRawLong3(long l) {
        this.set(3, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong3() {
        return this.get(3).getRawValue();
    }

    @Override
    public void setGenericDouble3(double d) {
        this.set(3, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble3() {
        return this.get(3).asDouble();
    }

    @Override
    public void setDouble3(double d) {
        this.set(3, Value.createDouble(d));
    }

    @Override
    public double getDouble3() {
        return this.get(3).asDouble();
    }

    @Override
    public void set3(Value value) {
        this.set(3, value);
    }

    @Override
    public Value get3() {
        return this.get(3);
    }

    @Override
    public void setRawLong4(long l) {
        this.set(4, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong4() {
        return this.get(4).getRawValue();
    }

    @Override
    public void setGenericDouble4(double d) {
        this.set(4, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble4() {
        return this.get(4).asDouble();
    }

    @Override
    public void setDouble4(double d) {
        this.set(4, Value.createDouble(d));
    }

    @Override
    public double getDouble4() {
        return this.get(4).asDouble();
    }

    @Override
    public void set4(Value value) {
        this.set(4, value);
    }

    @Override
    public Value get4() {
        return this.get(4);
    }

    @Override
    public void setRawLong5(long l) {
        this.set(5, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong5() {
        return this.get(5).getRawValue();
    }

    @Override
    public void setGenericDouble5(double d) {
        this.set(5, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble5() {
        return this.get(5).asDouble();
    }

    @Override
    public void setDouble5(double d) {
        this.set(5, Value.createDouble(d));
    }

    @Override
    public double getDouble5() {
        return this.get(5).asDouble();
    }

    @Override
    public void set5(Value value) {
        this.set(5, value);
    }

    @Override
    public Value get5() {
        return this.get(5);
    }

    @Override
    public void setRawLong6(long l) {
        this.set(6, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong6() {
        return this.get(6).getRawValue();
    }

    @Override
    public void setGenericDouble6(double d) {
        this.set(6, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble6() {
        return this.get(6).asDouble();
    }

    @Override
    public void setDouble6(double d) {
        this.set(6, Value.createDouble(d));
    }

    @Override
    public double getDouble6() {
        return this.get(6).asDouble();
    }

    @Override
    public void set6(Value value) {
        this.set(6, value);
    }

    @Override
    public Value get6() {
        return this.get(6);
    }

    @Override
    public void setRawLong7(long l) {
        this.set(7, Value.createFromRawLong(l));
    }

    @Override
    public long getRawLong7() {
        return this.get(7).getRawValue();
    }

    @Override
    public void setGenericDouble7(double d) {
        this.set(7, Value.createDouble(d));
    }

    @Override
    public double getGenericDouble7() {
        return this.get(7).asDouble();
    }

    @Override
    public void setDouble7(double d) {
        this.set(7, Value.createDouble(d));
    }

    @Override
    public double getDouble7() {
        return this.get(7).asDouble();
    }

    @Override
    public void set7(Value value) {
        this.set(7, value);
    }

    @Override
    public Value get7() {
        return this.get(7);
    }
}

