/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="CountDownLatch", source="")
public final class CountDownLatch {
    private CountDownLatch() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="CountDownLatch.t")
    public static Value ocamljava_countdownlatch_make(Value value) throws Fail.Exception {
        try {
            return Value.createInstance(new java.util.concurrent.CountDownLatch(value.asInt32()));
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.CountDownLatch.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_await(Value value) throws Fail.Exception {
        java.util.concurrent.CountDownLatch countDownLatch = (java.util.concurrent.CountDownLatch)value.asCustom();
        try {
            countDownLatch.await();
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.CountDownLatch.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_await_time(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.CountDownLatch countDownLatch = (java.util.concurrent.CountDownLatch)value.asCustom();
        try {
            countDownLatch.await(value2.asInt64(), TimeUnit.decode(value3));
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.CountDownLatch.await_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="unit")
    public static Value ocamljava_countdownlatch_count_down(Value value) {
        java.util.concurrent.CountDownLatch countDownLatch = (java.util.concurrent.CountDownLatch)value.asCustom();
        countDownLatch.countDown();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CountDownLatch.t"}, returnType="int64")
    public static Value ocamljava_countdownlatch_get_count(Value value) {
        java.util.concurrent.CountDownLatch countDownLatch = (java.util.concurrent.CountDownLatch)value.asCustom();
        long l = countDownLatch.getCount();
        return Value.createInt64(l);
    }
}

