/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Point;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/events.c")
public final class Events {
    static final int EVENT_BUTTON_DOWN = 0;
    static final int EVENT_BUTTON_UP = 1;
    static final int EVENT_KEY_PRESSED = 2;
    static final int EVENT_MOUSE_MOTION = 3;
    static final int EVENT_POLL = 4;

    private Events() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.event list"}, returnType="Graphics.status")
    public static Value caml_gr_wait_event(Value value) throws Fail.Exception, FalseExit {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        Value value2 = value;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (true) {
            if (value2 == Value.EMPTY_LIST) {
                if (!bl5) return graphSlot.waitEvent(bl, bl2, bl3, bl4);
                return Events.waitEventPoll(graphSlot);
            }
            switch (value2.get0().asCastedInt()) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
                case 3: {
                    bl4 = true;
                    break;
                }
                case 4: {
                    bl5 = true;
                    break;
                }
                default: {
                    assert (false) : "invalid Graphics.event";
                    break;
                }
            }
            value2 = value2.get1();
        }
    }

    private static Value waitEventPoll(GraphSlot graphSlot) {
        int n;
        int n2;
        Point point = graphSlot.getFrame().getMousePosition();
        if (point != null) {
            n2 = point.x;
            n = point.y;
        } else {
            n2 = -1;
            n = -1;
        }
        return Events.allocateResult(graphSlot, n2, n, graphSlot.isMouseButton(), graphSlot.getKey());
    }

    /*
     * Enabled aggressive block sorting
     */
    static Value allocateResult(GraphSlot graphSlot, int n, int n2, boolean bl, Integer n3) {
        Value value;
        Value value2 = Value.createLong(n);
        Value value3 = Value.createLong(n2 == -1 ? -1L : (long)graphSlot.convertY(n2));
        Value value4 = bl ? Value.TRUE : Value.FALSE;
        Value value5 = n3 != null ? Value.TRUE : Value.FALSE;
        if (n3 == null) {
            value = Value.ZERO;
            return Value.createBlock(0, value2, value3, value4, value5, value);
        }
        value = Value.createLong(n3.intValue());
        return Value.createBlock(0, value2, value3, value4, value5, value);
    }
}

