/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/open.c")
public final class Open {
    private static final int[] OPEN_FLAGS = new int[]{0, 1, 1, 4, 8, 512, 1024, 2048, 0, 0, 0, 0, 0};

    private Open() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Only supports filenames handled by Java."}, parameterTypes={"string", "Unix.open_flag list", "Unix.file_perm"}, returnType="Unix.file_descr")
    public static Value unix_open(Value value, Value value2, Value value3) throws Fail.Exception, FalseExit {
        FilesState filesState = CurrentContext.FILES_STATE;
        File file = filesState.getRealFile(value);
        int n = Misc.convertFlagList(value2, OPEN_FLAGS);
        int n2 = value3.asCastedInt();
        try {
            Value value5;
            Value value4 = value5 = Value.createLong(filesState.addChannel(new Channel(file, n, n2)));
            return value4;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("open", iOException);
            return Value.UNIT;
        }
    }
}

