/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.toplevel;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.context.FileHook;
import org.ocamljava.runtime.gui.InOutPanel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.CustomOperations;

abstract class AbstractTopLevel {
    private static final String TITLE = "OCaml toplevel";
    private static final int WIDTH = 600;
    private static final int HEIGHT = 400;
    private InOutPanel panel;
    private Throwable exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractTopLevel(String string, RandomAccessInputStream randomAccessInputStream, String[] stringArray, FileHook fileHook, boolean bl) {
        assert (string != null) : "null path";
        assert (randomAccessInputStream != null) : "null stream";
        assert (stringArray != null) : "null args";
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedOutputStream pipedOutputStream2 = new PipedOutputStream();
        this.exception = null;
        try {
            ByteCodeParameters byteCodeParameters = Parameters.defaultByteCodeParameters();
            byteCodeParameters = Parameters.setFile(byteCodeParameters, string);
            byteCodeParameters = Parameters.setUnparsedElements(byteCodeParameters, stringArray);
            byteCodeParameters = Parameters.setBooleanParameter(byteCodeParameters, CommonParameters.BooleanParameterID.STOP_JVM, bl);
            byteCodeParameters = Parameters.setInputStreamParameter(byteCodeParameters, CommonParameters.InputStreamParameterID.IN, (InputStream)pipedInputStream);
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.OUT, new PrintStream(pipedOutputStream, true));
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.ERR, new PrintStream(pipedOutputStream2, true));
            Interpreter interpreter = new Interpreter(byteCodeParameters, new File("."), randomAccessInputStream, new CustomOperations[0]);
            if (fileHook != null) {
                interpreter.getContext().getFilesState().setFileHook(fileHook);
            }
            this.panel = new InOutPanel(interpreter, new PrintStream(new PipedOutputStream(pipedInputStream), true), new PipedInputStream(pipedOutputStream), new PipedInputStream(pipedOutputStream2));
            return;
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
    }

    final Throwable getException() {
        return this.exception;
    }

    final InOutPanel getPanel() {
        return this.panel;
    }

    protected final JFrame createFrame() {
        block7: {
            block4: {
                block8: {
                    Throwable throwable;
                    block6: {
                        block5: {
                            if (this.exception == null) break block4;
                            if (!(this.exception instanceof OCamlJavaException)) break block5;
                            throwable = this.exception.getCause();
                            if (throwable instanceof Fail.Exception || throwable instanceof Fatal.Exception) break block6;
                            System.out.println("error: " + this.exception.getMessage());
                            break block7;
                        }
                        if (!(this.exception instanceof Fatal.Exception)) break block8;
                        System.out.println("fatal error: " + this.exception.getMessage());
                        break block7;
                    }
                    System.out.println("error: " + throwable.getMessage());
                    break block7;
                }
                if (this.exception instanceof IOException) {
                    System.out.println("i/o error: " + this.exception.getMessage());
                } else if (this.exception instanceof Exception) {
                    System.out.println("internal error: " + this.exception.getMessage());
                    this.exception.printStackTrace(System.err);
                } else {
                    System.out.println("Java error: " + this.exception.getMessage());
                    this.exception.printStackTrace(System.err);
                }
                break block7;
            }
            JFrame jFrame = new JFrame(TITLE);
            jFrame.getContentPane().add((Component)this.panel, "Center");
            jFrame.setSize(600, 400);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setVisible(true);
            return jFrame;
        }
        System.exit(1);
        return null;
    }
}

