/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;

class PlotLegend {
    LegendTitle legend = null;

    PlotLegend(LegendItemSource legendSource) {
        this.initLegend(legendSource);
    }

    void initLegend(LegendItemSource legendSource) {
        if (legendSource != null) {
            this.legend = new LegendTitle(legendSource);
            if (this.legend != null) {
                this.legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
                this.legend.setBorder(new BlockBorder());
                this.legend.setBackgroundPaint((Paint)Color.white);
                this.legend.setPosition(RectangleEdge.BOTTOM);
            }
        }
    }

    Rectangle2D arrangeLegend(Graphics2D g2, Rectangle2D area) {
        if (this.legend == null) {
            throw new IllegalArgumentException("Null 't' argument.");
        }
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        double areaWidth = area.getWidth();
        if (areaWidth <= 0.0) {
            return null;
        }
        double areaHeight = area.getHeight();
        if (areaHeight <= 0.0) {
            return null;
        }
        RectangleConstraint constraint = new RectangleConstraint(areaWidth, new Range(0.0, areaWidth), LengthConstraintType.RANGE, areaHeight, new Range(0.0, areaHeight), LengthConstraintType.RANGE);
        Object retValue = null;
        Size2D size = this.legend.arrange(g2, constraint);
        Rectangle2D legendArea = this.createAlignedRectangle2D(size, area, this.legend.getHorizontalAlignment(), VerticalAlignment.BOTTOM);
        area.setRect(area.getX(), area.getY(), area.getWidth(), area.getHeight() - size.height);
        return legendArea;
    }

    void drawLegend(Graphics2D g2, Rectangle2D legendArea) {
        this.legend.draw(g2, legendArea, null);
    }

    private Rectangle2D createAlignedRectangle2D(Size2D dimensions, Rectangle2D frame, HorizontalAlignment hAlign, VerticalAlignment vAlign) {
        double x = Double.NaN;
        double y = Double.NaN;
        if (hAlign == HorizontalAlignment.LEFT) {
            x = frame.getX();
        } else if (hAlign == HorizontalAlignment.CENTER) {
            x = frame.getCenterX() - dimensions.width / 2.0;
        } else if (hAlign == HorizontalAlignment.RIGHT) {
            x = frame.getMaxX() - dimensions.width;
        }
        if (vAlign == VerticalAlignment.TOP) {
            y = frame.getY();
        } else if (vAlign == VerticalAlignment.CENTER) {
            y = frame.getCenterY() - dimensions.height / 2.0;
        } else if (vAlign == VerticalAlignment.BOTTOM) {
            y = frame.getMaxY() - dimensions.height;
        }
        return new Rectangle2D.Double(x, y, dimensions.width, dimensions.height);
    }
}

