/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.DebuggerState;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

public final class Debugger {
    private static final Map<Integer, Request> REQUEST_MAP = new HashMap<Integer, Request>();
    private static final Map<Integer, Reply> REPLY_MAP = new HashMap<Integer, Reply>();

    private Debugger() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init(Context context) throws Fatal.Exception {
        Socket socket;
        DebuggerState debuggerState;
        block7: {
            String string;
            String string2;
            assert (context != null) : "null ctxt";
            debuggerState = context.getDebuggerState();
            try {
                string2 = System.getenv("CAML_DEBUG_SOCKET");
                if (string2 == null) break block7;
            }
            catch (SecurityException securityException) {
                return;
            }
            int n = string2.indexOf(":");
            String string3 = n >= 0 ? string2.substring(n + 1) : null;
            String string4 = string = n >= 0 ? string2.substring(0, n) : string2;
            if (string3 == null) {
                Fatal.raise("Unix socket not supported");
                return;
            }
            try {
                socket = new Socket(string, Integer.parseInt(string3));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                if (!debuggerState.isDebuggerInUse()) {
                    IO.write32s(dataOutputStream, -1);
                }
                IO.write32u(dataOutputStream, 0L);
                dataOutputStream.flush();
            }
            catch (Exception exception) {
                String string5 = String.format("cannot connect to debugger at %s\nerror: %s", string2, exception.getMessage());
                Fatal.raise(string5);
                return;
            }
        }
        return;
        debuggerState.setDebuggerInUse(true);
        debuggerState.setDebuggerSocket(socket);
        debuggerState.setDebuggerTrapBarrier(0);
    }

    /*
     * Exception decompiling
     */
    public static void handleEvent(ByteCodeRunner var0, EventKind var1_1) throws Fail.Exception, Fatal.Exception, FalseExit {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void putVal(DataOutputStream dataOutputStream, List<Value> list, Value value) throws IOException {
        assert (dataOutputStream != null) : "null out";
        assert (list != null) : "null l";
        assert (value != null) : "null v";
        if (!value.isBlock()) {
            IO.write64s(dataOutputStream, value.getRawValue());
        } else {
            int n;
            int n2 = list.size();
            for (n = 0; n < n2 && list.get(n) != value; ++n) {
            }
            if (n < n2) {
                IO.write64s(dataOutputStream, n << 1);
            } else {
                list.add(value);
                IO.write64s(dataOutputStream, n2 << 1);
            }
        }
    }

    private static Value getVal(DataInputStream dataInputStream, List<Value> list) throws Fatal.Exception, IOException {
        assert (dataInputStream != null) : "null in";
        assert (list != null) : "null l";
        long l = IO.read64s(dataInputStream);
        if ((l & 1L) == 0L) {
            int n = (int)l >> 1;
            if (n >= 0 && n < list.size()) {
                return list.get(n);
            }
            Fatal.raise("debugger: unknown value");
            return null;
        }
        return Value.createFromRawValue(l);
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind;
        static final /* synthetic */ int[] $SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            $SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request = new int[Request.values().length];
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_SET_EVENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_SET_BREAKPOINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_RESET_INSTR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_CHECKPOINT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_STOP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_WAIT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_INITIAL_FRAME.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_FRAME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_SET_FRAME.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_UP_FRAME.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_SET_TRAP_BARRIER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_LOCAL.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_ENVIRONMENT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_GLOBAL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_ACCU.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_HEADER.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_FIELD.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_MARSHAL_OBJ.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_GET_CLOSURE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$Request[Request.REQ_SET_FORK_MODE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind = new int[EventKind.values().length];
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.PROGRAM_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.EVENT_COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.BREAKPOINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.PROGRAM_EXIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.TRAP_BARRIER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$ocamljava$runtime$kernel$Debugger$EventKind[EventKind.UNCAUGHT_EXC.ordinal()] = 6;
                return;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static final class Reply
    extends Enum<Reply> {
        public static final /* enum */ Reply REP_EVENT = new Reply('e');
        public static final /* enum */ Reply REP_BREAKPOINT = new Reply('b');
        public static final /* enum */ Reply REP_EXITED = new Reply('x');
        public static final /* enum */ Reply REP_TRAP = new Reply('s');
        public static final /* enum */ Reply REP_UNCAUGHT_EXC = new Reply('u');
        private final int code;
        private static final /* synthetic */ Reply[] $VALUES;

        public static Reply[] values() {
            return (Reply[])$VALUES.clone();
        }

        public static Reply valueOf(String string) {
            return Enum.valueOf(Reply.class, string);
        }

        private Reply(char c) {
            int n2;
            this.code = n2 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(c));
            REPLY_MAP.put(n2, this);
        }

        public static Reply fromCharCode(int n) {
            Reply reply = (Reply)((Object)REPLY_MAP.get(n));
            assert (reply != null) : "invalid code";
            return reply;
        }

        public int getCharCode() {
            return this.code;
        }

        static {
            $VALUES = new Reply[]{REP_EVENT, REP_BREAKPOINT, REP_EXITED, REP_TRAP, REP_UNCAUGHT_EXC};
        }
    }

    public static final class Request
    extends Enum<Request> {
        public static final /* enum */ Request REQ_SET_EVENT = new Request('e');
        public static final /* enum */ Request REQ_SET_BREAKPOINT = new Request('B');
        public static final /* enum */ Request REQ_RESET_INSTR = new Request('i');
        public static final /* enum */ Request REQ_CHECKPOINT = new Request('c');
        public static final /* enum */ Request REQ_GO = new Request('g');
        public static final /* enum */ Request REQ_STOP = new Request('s');
        public static final /* enum */ Request REQ_WAIT = new Request('w');
        public static final /* enum */ Request REQ_INITIAL_FRAME = new Request('0');
        public static final /* enum */ Request REQ_GET_FRAME = new Request('f');
        public static final /* enum */ Request REQ_SET_FRAME = new Request('S');
        public static final /* enum */ Request REQ_UP_FRAME = new Request('U');
        public static final /* enum */ Request REQ_SET_TRAP_BARRIER = new Request('b');
        public static final /* enum */ Request REQ_GET_LOCAL = new Request('L');
        public static final /* enum */ Request REQ_GET_ENVIRONMENT = new Request('E');
        public static final /* enum */ Request REQ_GET_GLOBAL = new Request('G');
        public static final /* enum */ Request REQ_GET_ACCU = new Request('A');
        public static final /* enum */ Request REQ_GET_HEADER = new Request('H');
        public static final /* enum */ Request REQ_GET_FIELD = new Request('F');
        public static final /* enum */ Request REQ_MARSHAL_OBJ = new Request('M');
        public static final /* enum */ Request REQ_GET_CLOSURE = new Request('C');
        public static final /* enum */ Request REQ_SET_FORK_MODE = new Request('K');
        private final int code;
        private static final /* synthetic */ Request[] $VALUES;

        public static Request[] values() {
            return (Request[])$VALUES.clone();
        }

        public static Request valueOf(String string) {
            return Enum.valueOf(Request.class, string);
        }

        private Request(char c) {
            int n2;
            this.code = n2 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(c));
            REQUEST_MAP.put(n2, this);
        }

        public static Request fromCharCode(int n) {
            Request request = (Request)((Object)REQUEST_MAP.get(n));
            assert (request != null) : "invalid code";
            return request;
        }

        public int getCharCode() {
            return this.code;
        }

        static {
            $VALUES = new Request[]{REQ_SET_EVENT, REQ_SET_BREAKPOINT, REQ_RESET_INSTR, REQ_CHECKPOINT, REQ_GO, REQ_STOP, REQ_WAIT, REQ_INITIAL_FRAME, REQ_GET_FRAME, REQ_SET_FRAME, REQ_UP_FRAME, REQ_SET_TRAP_BARRIER, REQ_GET_LOCAL, REQ_GET_ENVIRONMENT, REQ_GET_GLOBAL, REQ_GET_ACCU, REQ_GET_HEADER, REQ_GET_FIELD, REQ_MARSHAL_OBJ, REQ_GET_CLOSURE, REQ_SET_FORK_MODE};
        }
    }

    public static enum EventKind {
        EVENT_COUNT,
        BREAKPOINT,
        PROGRAM_START,
        PROGRAM_EXIT,
        TRAP_BARRIER,
        UNCAUGHT_EXC;

    }
}

