/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.Arrays;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="String", source="byterun/str.c")
public final class Str {
    private Str() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_ml_string_length(Value value) {
        return value.sizeBytesWrapped();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="string")
    public static Value caml_create_string(Value value) throws Fail.Exception {
        long l = value.asLong();
        if (l > 0x1FFFFFFFFFFFFF7L) {
            Fail.invalidArgument("String.create");
        }
        return Value.createString(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="char")
    public static Value caml_string_get(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        return Value.createLong(value.getUnsignedByte(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "char"}, returnType="unit")
    public static Value caml_string_set(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        value.setUnsignedByte(l, value3.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_equal(Value value, Value value2) {
        long l;
        long l2;
        block7: {
            block6: {
                Value value3;
                block5: {
                    block3: {
                        block2: {
                            block4: {
                                long l3;
                                block1: {
                                    byte[] byArray;
                                    l2 = value.sizeBytes();
                                    l3 = value2.sizeBytes();
                                    if (l2 > Integer.MAX_VALUE || l3 > Integer.MAX_VALUE) break block1;
                                    byte[] byArray2 = value.getBytes();
                                    if (byArray2 == (byArray = value2.getBytes())) break block2;
                                    int n = byArray2.length;
                                    if (n != byArray.length) break block3;
                                    if (!Arrays.equals(byArray2, byArray)) break block4;
                                    value3 = Value.TRUE;
                                    break block5;
                                }
                                if (l2 != l3) break block6;
                                for (l = 0L; l < l2 && value.getByte(l) == value2.getByte(l); ++l) {
                                }
                                break block7;
                            }
                            value3 = Value.FALSE;
                            break block5;
                        }
                        return Value.TRUE;
                    }
                    return Value.FALSE;
                }
                return value3;
            }
            return Value.FALSE;
        }
        return l == l2 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_notequal(Value value, Value value2) {
        return Str.caml_string_equal(value, value2) == Value.TRUE ? Value.FALSE : Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="int")
    public static Value caml_string_compare(Value value, Value value2) {
        return Value.createLong(Str.compare(value, value2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessthan(Value value, Value value2) {
        return Str.compare(value, value2) < 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessequal(Value value, Value value2) {
        return Str.compare(value, value2) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterthan(Value value, Value value2) {
        return Str.compare(value, value2) > 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterequal(Value value, Value value2) {
        return Str.compare(value, value2) >= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "string", "int", "int"}, returnType="bool")
    public static Value caml_blit_string(Value value, Value value2, Value value3, Value value4, Value value5) {
        long l = value.sizeBytes();
        long l2 = value3.sizeBytes();
        if (l <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            System.arraycopy(value.getBytes(), value2.asCastedInt(), value3.getBytesForModification(), value4.asCastedInt(), value5.asCastedInt());
        } else {
            long l3 = value2.asLong();
            long l4 = value4.asLong();
            long l5 = value5.asLong();
            int n = 0;
            while ((long)n < l5) {
                value3.setByte((long)n + l4, value.getByte((long)n + l3));
                ++n;
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int", "char"}, returnType="unit")
    public static Value caml_fill_string(Value value, Value value2, Value value3, Value value4) {
        long l = value.sizeBytes();
        if (l <= Integer.MAX_VALUE) {
            int n = value2.asCastedInt();
            int n2 = n + value3.asCastedInt();
            byte by = (byte)IntegerUtils.unsignedToSignedByte(value4.asCastedInt() & 0xFF);
            byte[] byArray = value.getBytesForModification();
            for (int i = n; i < n2; ++i) {
                byArray[i] = by;
            }
        } else {
            long l2 = value2.asLong();
            long l3 = l2 + value3.asLong();
            byte by = (byte)IntegerUtils.unsignedToSignedByte(value4.asCastedInt() & 0xFF);
            for (long i = l2; i < l3; ++i) {
                value.setByte(i, by);
            }
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"No locale is used."}, parameterTypes={"char"}, returnType="bool")
    public static Value caml_is_printable(Value value) {
        int n = value.asCastedInt() & 0xFF;
        return n >= 32 && n <= 126 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="bool")
    public static Value caml_bitvect_test(Value value, Value value2) {
        long l = value2.asLong();
        return (value.getUnsignedByte(l >> 3) & 1 << (int)(l & 7L)) != 0 ? Value.TRUE : Value.FALSE;
    }

    static int compare(Value value, Value value2) {
        block18: {
            block19: {
                block17: {
                    block15: {
                        block16: {
                            block14: {
                                block11: {
                                    block12: {
                                        block10: {
                                            block8: {
                                                block9: {
                                                    block7: {
                                                        block3: {
                                                            long l;
                                                            long l2;
                                                            block13: {
                                                                long l3;
                                                                long l4;
                                                                block5: {
                                                                    int n;
                                                                    int n2;
                                                                    block6: {
                                                                        int n3;
                                                                        int n4;
                                                                        byte[] byArray;
                                                                        byte[] byArray2;
                                                                        block4: {
                                                                            block2: {
                                                                                l2 = value.sizeBytes();
                                                                                l = value2.sizeBytes();
                                                                                if (l2 > Integer.MAX_VALUE || l > Integer.MAX_VALUE) break block2;
                                                                                byArray2 = value.getBytes();
                                                                                if (byArray2 == (byArray = value2.getBytes())) break block3;
                                                                                n2 = byArray2.length;
                                                                                n = byArray.length;
                                                                                n4 = Math.min(n2, n);
                                                                                for (n3 = 0; n3 < n4 && byArray2[n3] == byArray[n3]; ++n3) {
                                                                                }
                                                                                break block4;
                                                                            }
                                                                            l4 = Math.min(l2, l);
                                                                            for (l3 = 0L; l3 < l4 && value.getByte(l3) == value2.getByte(l3); ++l3) {
                                                                            }
                                                                            break block5;
                                                                        }
                                                                        if (n3 >= n4) break block6;
                                                                        int n5 = IntegerUtils.signedToUnsignedByte(byArray2[n3]) - IntegerUtils.signedToUnsignedByte(byArray[n3]);
                                                                        if (n5 < 0) break block7;
                                                                        if (n5 <= 0) break block8;
                                                                        break block9;
                                                                    }
                                                                    if (n2 < n) break block10;
                                                                    if (n2 <= n) break block11;
                                                                    break block12;
                                                                }
                                                                if (l3 >= l4) break block13;
                                                                int n = IntegerUtils.signedToUnsignedByte(value.getByte(l3)) - IntegerUtils.signedToUnsignedByte(value2.getByte(l3));
                                                                if (n < 0) break block14;
                                                                if (n <= 0) break block15;
                                                                break block16;
                                                            }
                                                            if (l2 < l) break block17;
                                                            if (l2 <= l) break block18;
                                                            break block19;
                                                        }
                                                        return 0;
                                                    }
                                                    return -1;
                                                }
                                                return 1;
                                            }
                                            return 0;
                                        }
                                        return -1;
                                    }
                                    return 1;
                                }
                                return 0;
                            }
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

