/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Invoker;
import org.ocamljava.runtime.values.Value;

final class MethodHandleDispatcher
implements Dispatcher {
    private int size;
    private String[] names;
    private Method[] implementations;
    private MethodHandle[] handles;

    MethodHandleDispatcher(String[] stringArray, Method[] methodArray) throws IllegalAccessException {
        assert (stringArray != null) : "null nams";
        assert (methodArray != null) : "null impls";
        assert (stringArray.length == methodArray.length) : "nams and impls should have the same length";
        this.size = stringArray.length;
        this.names = Arrays.copyOf(stringArray, stringArray.length);
        this.implementations = Arrays.copyOf(methodArray, methodArray.length);
        this.handles = new MethodHandle[methodArray.length];
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (int i = 0; i < this.handles.length; ++i) {
            this.handles[i] = lookup.unreflect(methodArray[i]);
        }
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public Method[] getMethods() {
        return this.implementations;
    }

    @Override
    public String getName(int n) {
        if (n >= 0 && n < this.size) {
            return this.names[n];
        }
        return null;
    }

    @Override
    public Method getMethod(int n) {
        if (n >= 0 && n < this.size) {
            return this.implementations[n];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value[] valueArray) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (valueArray != null) : "null params";
        try {
            Value value = Invoker.call(this.handles[n], valueArray);
            return value;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value value) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        try {
            Value value2 = this.handles[n].invokeExact(value);
            return value2;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value value, Value value2) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        try {
            Value value3 = this.handles[n].invokeExact(value, value2);
            return value3;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value value, Value value2, Value value3) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        try {
            Value value4 = this.handles[n].invokeExact(value, value2, value3);
            return value4;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        assert (value4 != null) : "null p3";
        try {
            Value value5 = this.handles[n].invokeExact(value, value2, value3, value4);
            return value5;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4, Value value5) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        assert (value4 != null) : "null p3";
        assert (value5 != null) : "null p4";
        try {
            Value value6 = this.handles[n].invokeExact(value, value2, value3, value4, value5);
            return value6;
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            this.reportFatal(n, throwable);
            return null;
        }
    }

    @Override
    public int addPrimitive(String string, Method method) throws IllegalAccessException {
        assert (string != null) : "null name";
        assert (method != null) : "null impl";
        int n = this.size++;
        Method[] methodArray = new Method[this.size];
        System.arraycopy(this.implementations, 0, methodArray, 0, n);
        methodArray[n] = method;
        this.implementations = methodArray;
        String[] stringArray = new String[this.size];
        System.arraycopy(this.names, 0, stringArray, 0, n);
        stringArray[n] = string;
        this.names = stringArray;
        MethodHandle[] methodHandleArray = new MethodHandle[this.size];
        System.arraycopy(this.handles, 0, methodHandleArray, 0, n);
        methodHandleArray[n] = MethodHandles.lookup().unreflect(method);
        this.handles = methodHandleArray;
        return n;
    }

    private void reportFatal(int n, Throwable throwable) throws Fatal.Exception {
        assert (throwable != null) : "null t";
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("primitive error: ");
        stringWriter.append(this.getName(n));
        stringWriter.append('\n');
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Fatal.raise(stringWriter.toString());
    }
}

