/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlFunction;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlLazy<T extends OCamlValue>
extends OCamlValue {
    private final Wrapper<T> wrapper;

    private OCamlLazy(Wrapper<T> wrapper, Value value) {
        super(value);
        assert (wrapper != null) : "null w";
        this.wrapper = wrapper;
    }

    public Wrapper<? extends OCamlLazy<T>> getWrapper() {
        return OCamlLazy.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        switch (n) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get() {
        if (this.value.isLong()) {
            return this.wrapper.wrap(this.value);
        }
        switch (this.value.getTag()) {
            case 246: {
                return null;
            }
            case 250: {
                return this.wrapper.wrap(this.value.get0());
            }
        }
        return this.wrapper.wrap(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T force() {
        if (this.value.isLong()) return this.wrapper.wrap(this.value);
        switch (this.value.getTag()) {
            case 246: {
                try {
                    Value value = NativeApply.apply(this.value.get0(), Value.UNIT);
                    this.value.setTag(250);
                    this.value.set0(value);
                    T t = this.wrapper.wrap(value);
                    return t;
                }
                catch (Throwable throwable) {
                    assert (false) : "exception during lazy evaluation";
                    return null;
                }
            }
            case 250: {
                return this.wrapper.wrap(this.value.get0());
            }
        }
        return this.wrapper.wrap(this.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlLazy) {
            OCamlLazy oCamlLazy = (OCamlLazy)object;
            return this == oCamlLazy;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlLazy(");
        T t = this.get();
        if (t == null) {
            stringBuilder.append("...");
        } else {
            stringBuilder.append(((OCamlValue)this.wrapper.wrap(((OCamlValue)t).value())).toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static <T extends OCamlValue> OCamlLazy<T> create(T t) {
        return new OCamlLazy<OCamlValue>(t.getWrapper(), Value.createBlock(250, t.value()));
    }

    public static <T extends OCamlValue> OCamlLazy<T> create(Wrapper<T> wrapper, OCamlFunction<OCamlUnit, T> oCamlFunction) {
        Value value = oCamlFunction.getClosure(OCamlUnit.WRAPPER);
        return new OCamlLazy<T>(wrapper, Value.createBlock(246, value));
    }

    public static <T extends OCamlValue> OCamlLazy<T> wrap(Wrapper<T> wrapper, Value value) {
        assert (value != null) : "null v";
        return new OCamlLazy<T>(wrapper, value);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlLazy<T>> wrapper(final Wrapper<T> wrapper) {
        return new ComposedWrapper<OCamlLazy<T>>(new Wrapper[]{wrapper}){

            @Override
            public OCamlLazy<T> wrap(Value value) {
                return new OCamlLazy(wrapper, value);
            }
        };
    }
}

