/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.SimpleThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Thread", source="")
public final class Thread {
    private Thread() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t option", "string option", "('a -> unit)", "'a"}, returnType="Thread.t")
    public static Value ocamljava_thread_make(Value value, Value value2, Value value3, Value value4) {
        ThreadGroup threadGroup = value.isLong() ? null : (ThreadGroup)value.get0().asCustom();
        String string = value2.isLong() ? "<unnamed thread>" : value2.get0().asString();
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        SimpleThread simpleThread = new SimpleThread(threadGroup, string, codeRunner, value3, value4);
        return Value.createInstance(simpleThread);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value ocamljava_thread_current_thread(Value value) {
        java.lang.Thread thread = java.lang.Thread.currentThread();
        return Value.createInstance(thread);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="string")
    public static Value ocamljava_thread_get_id(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        long l = thread.getId();
        return Value.createInt64(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="string")
    public static Value ocamljava_thread_get_name(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        String string = thread.getName();
        return Value.createString(string);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="int32")
    public static Value ocamljava_thread_get_priority(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        int n = thread.getPriority();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="Thread.state")
    public static Value ocamljava_thread_get_state(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        Thread.State state = thread.getState();
        return Thread.encode(state);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="ThreadGroup.t option")
    public static Value ocamljava_thread_get_thread_group(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        ThreadGroup threadGroup = thread.getThreadGroup();
        return threadGroup == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(threadGroup));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_interrupt(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        thread.interrupt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="bool")
    public static Value ocamljava_thread_interrupted(Value value) {
        return java.lang.Thread.interrupted() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_alive(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        boolean bl = thread.isAlive();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_daemon(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        boolean bl = thread.isDaemon();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_interrupted(Value value) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        boolean bl = thread.isInterrupted();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_join(Value value) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.join();
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Thread.join");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int64"}, returnType="unit")
    public static Value ocamljava_thread_join_time(Value value, Value value2) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.join(value2.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Thread.join_time");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.join_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int64", "int32"}, returnType="unit")
    public static Value ocamljava_thread_join_time_nanos(Value value, Value value2, Value value3) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.join(value2.asInt64(), value3.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Thread.join_time_nanos");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.join_time_nanos");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "string"}, returnType="unit")
    public static Value ocamljava_thread_set_daemon(Value value, Value value2) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.setDaemon(value2 != Value.FALSE);
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.set_daemon");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "string"}, returnType="unit")
    public static Value ocamljava_thread_set_name(Value value, Value value2) {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        thread.setName(value2.asString());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int32"}, returnType="unit")
    public static Value ocamljava_thread_set_priority(Value value, Value value2) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.setPriority(value2.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.set_priority");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64"}, returnType="unit")
    public static Value ocamljava_thread_sleep(Value value) throws Fail.Exception {
        try {
            java.lang.Thread.sleep(value.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Thread.sleep");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64", "int32"}, returnType="unit")
    public static Value ocamljava_thread_sleep_nanos(Value value, Value value2) throws Fail.Exception {
        try {
            java.lang.Thread.sleep(value.asInt64(), value2.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Thread.sleep_nanos");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.sleep_nanos");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_start(Value value) throws Fail.Exception {
        java.lang.Thread thread = (java.lang.Thread)value.asCustom();
        try {
            thread.start();
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Thread.start");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="unit")
    public static Value ocamljava_thread_yield(Value value) {
        java.lang.Thread.yield();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_max_priority(Value value) {
        return Value.createInt32(10);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_min_priority(Value value) {
        return Value.createInt32(1);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_norm_priority(Value value) {
        return Value.createInt32(5);
    }

    static Value encode(Thread.State state) {
        switch (1.$SwitchMap$java$lang$Thread$State[state.ordinal()]) {
            default: {
                assert (false) : "should not happen";
                break;
            }
            case 1: {
                return Value.ZERO;
            }
            case 2: {
                return Value.ONE;
            }
            case 3: {
                return Value.TWO;
            }
            case 4: {
                return Value.THREE;
            }
            case 5: {
                return Value.FOUR;
            }
            case 6: {
                return Value.FIVE;
            }
        }
        return null;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$java$lang$Thread$State;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            $SwitchMap$java$lang$Thread$State = new int[Thread.State.values().length];
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.RUNNABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.BLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.WAITING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.TIMED_WAITING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$java$lang$Thread$State[Thread.State.TERMINATED.ordinal()] = 6;
                return;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                return;
            }
        }
    }
}

