/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/accept.c")
public final class Accept {
    private Accept() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="Unix.file_descr * Unix.sockaddr")
    public static Value unix_accept(Value value) throws Fail.Exception, FalseExit {
        Context context = CurrentContext.CONTEXT;
        Channel channel = context.getFilesState().getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("accept", "invalid descriptor");
            return Value.UNIT;
        }
        ServerSocketChannel serverSocketChannel = channel.asServerSocket();
        if (serverSocketChannel == null) {
            Unix.fail("accept", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            SocketChannel socketChannel = serverSocketChannel.accept();
            int n = context.getFilesState().addChannel(new Channel(socketChannel));
            Value value3 = Value.createBlock(0, Value.createLong(n), Unix.createSockAddr((InetSocketAddress)socketChannel.getRemoteAddress()));
            return value3;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("accept", iOException);
            return Value.UNIT;
        }
    }
}

