/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlFloat;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlArray<T extends OCamlValue>
extends OCamlValue
implements Iterable<T> {
    private final Wrapper<T> wrapper;

    private OCamlArray(Wrapper<T> wrapper, Value value) {
        super(value);
        assert (wrapper != null) : "null w";
        this.wrapper = wrapper;
    }

    public Wrapper<? extends OCamlArray<T>> getWrapper() {
        return OCamlArray.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        switch (n) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public T get(int n) {
        return this.wrapper.wrap(this.value.get(n));
    }

    public void set(int n, T t) {
        this.value.set(n, ((OCamlValue)t).value());
    }

    public long length() {
        return this.value.sizeValues();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private long next = 0L;

            @Override
            public boolean hasNext() {
                return this.next < OCamlArray.this.value.sizeValues();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Value value = OCamlArray.this.value.get(this.next++);
                return OCamlArray.this.wrapper.wrap(value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlArray) {
            OCamlArray oCamlArray = (OCamlArray)object;
            return this == oCamlArray;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlArray(");
        int n = 0;
        int n2 = (int)this.value.sizeValues();
        while (n < n2 && stringBuilder.length() < 256) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            Value value = this.value.get(n++);
            T t = this.wrapper.wrap(value);
            stringBuilder.append(((OCamlValue)t).toString());
        }
        if (n < n2) {
            stringBuilder.append("...");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static <T extends OCamlValue> OCamlArray<T> create(int n, T t) {
        Value value;
        assert (n >= 0) : "negative sz";
        assert (t != null) : "null v";
        if (!(t instanceof OCamlFloat)) {
            value = Value.createBlock(0, n);
            for (int i = 0; i < n; ++i) {
                value.set(i, t.value());
            }
        } else {
            double d = ((OCamlFloat)t).doubleValue();
            Value value2 = Value.createDoubleArray(n);
            for (int i = 0; i < n; ++i) {
                value2.setDouble(i, d);
            }
            return new OCamlArray<OCamlValue>(t.getWrapper(), value2);
        }
        return new OCamlArray<OCamlValue>(t.getWrapper(), value);
    }

    public static <T extends OCamlValue> OCamlArray<T> create(Wrapper<T> wrapper, T[] TArray) {
        Value value;
        assert (wrapper != null) : "null w";
        assert (TArray != null) : "null v";
        int n = TArray.length;
        if (n <= 0 || !(TArray[0] instanceof OCamlFloat)) {
            value = Value.createBlock(0, n);
            for (int i = 0; i < n; ++i) {
                value.set(i, ((OCamlValue)TArray[i]).value());
            }
        } else {
            Value value2 = Value.createDoubleArray(n);
            for (int i = 0; i < n; ++i) {
                value2.setDouble(i, ((OCamlFloat)TArray[i]).doubleValue());
            }
            return new OCamlArray<T>(wrapper, value2);
        }
        return new OCamlArray<T>(wrapper, value);
    }

    public static <T extends OCamlValue> OCamlArray<T> wrap(Wrapper<T> wrapper, Value value) {
        assert (value != null) : "null v";
        return new OCamlArray<T>(wrapper, value);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlArray<T>> wrapper(final Wrapper<T> wrapper) {
        return new ComposedWrapper<OCamlArray<T>>(new Wrapper[]{wrapper}){

            @Override
            public OCamlArray<T> wrap(Value value) {
                return new OCamlArray(wrapper, value);
            }
        };
    }
}

