/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.SwkJTextPane;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class SwkDefaultStyledDocument
extends DefaultStyledDocument
implements DocumentListener {
    static Hashtable resourceDB = null;
    String name = null;
    TclObject tclObject = null;
    Hashtable marks = null;
    Vector paragraphs;
    Position endPosition = null;
    int[] indexes = null;
    Vector rangeOffsets = new Vector();
    int swkwidth;
    boolean removeInProgress = false;
    private Hashtable styleHash = new Hashtable();

    SwkDefaultStyledDocument() {
        this.init();
        this.marks = new Hashtable();
        this.paragraphs = new Vector();
        this.endPosition = this.getEndPosition();
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkDefaultStyledDocument.initResources();
        }
    }

    protected void init() {
        this.addDocumentListener(this);
    }

    public void styleUpdated(SwkJTextPane swkjtextpane, Style style, boolean remove) {
        String tagName = (String)style.getAttribute("tagName");
        if (tagName == null) {
            return;
        }
        StyleContext rStyle = new StyleContext();
        this.endPosition = this.getEndPosition();
        int endOffset = this.endPosition.getOffset();
        if (endOffset <= 0) {
            return;
        }
        Hashtable ht = (Hashtable)this.styleHash.get(tagName);
        String[] styleList = null;
        Style nextStyle = null;
        if (ht != null) {
            Vector<Element> cleanUp = new Vector<Element>();
            Enumeration<Object> e = ht.keys();
            while (e.hasMoreElements()) {
                String checkName;
                Element el = (Element)e.nextElement();
                int start = el.getStartOffset();
                int end = el.getEndOffset();
                AttributeSet attrs = el.getAttributes();
                if (attrs == null || (checkName = (String)attrs.getAttribute("tagName")) == null) continue;
                int checkIndex = checkName.indexOf(tagName);
                int lastChar = checkIndex + tagName.length();
                if (!(checkIndex == -1 || checkIndex != 0 && checkName.charAt(checkIndex - 1) != ' ' || lastChar != checkName.length() && checkName.charAt(lastChar) != ' ')) {
                    styleList = checkName.split("\\s", -1);
                    if (remove) {
                        this.setCharacterAttributes(start, end - start, rStyle.getEmptySet(), true);
                        continue;
                    }
                    Style groupedStyle = swkjtextpane.getStyle(checkName);
                    for (int j = 0; j < styleList.length; ++j) {
                        nextStyle = styleList.length == 1 ? style : swkjtextpane.getStyle(styleList[j].toString());
                        if (j == 0) {
                            // empty if block
                        }
                        groupedStyle.addAttributes(nextStyle);
                    }
                    groupedStyle.addAttribute("tagName", checkName);
                    if (groupedStyle != null) {
                        this.setCharacterAttributes(start, end - start, groupedStyle, true);
                    }
                    AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(this, start, end - start, DocumentEvent.EventType.CHANGE);
                    this.fireChangedUpdate(ev);
                    continue;
                }
                cleanUp.addElement(el);
            }
            e = cleanUp.elements();
            while (e.hasMoreElements()) {
                Element bad = (Element)e.nextElement();
                ht.remove(bad);
            }
        }
    }

    public void insertUpdate(DocumentEvent ev) {
        this.updateStyleHash(ev);
    }

    public void removeUpdate(DocumentEvent ev) {
        this.updateStyleHash(ev);
    }

    public void changedUpdate(DocumentEvent ev) {
        if (this.removeInProgress) {
            return;
        }
        int offset = ev.getOffset();
        Element elem = ((SwkDefaultStyledDocument)ev.getDocument()).getCharacterElement(offset);
        this.addToStyleHash(elem);
    }

    protected void updateStyleHash(DocumentEvent ev) {
        int offset = ev.getOffset();
        Element elem = ((SwkDefaultStyledDocument)ev.getDocument()).getCharacterElement(offset);
        Element parent = elem.getParentElement();
        DocumentEvent.ElementChange chg = ev.getChange(parent);
        if (chg != null) {
            Element[] removed = chg.getChildrenRemoved();
            for (int i = 0; i < removed.length; ++i) {
                this.removeFromStyleHash(removed[i]);
            }
            Element[] added = chg.getChildrenAdded();
            for (int i = 0; i < added.length; ++i) {
                this.addToStyleHash(added[i]);
            }
        }
    }

    protected void addToStyleHash(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        String[] tagList = null;
        if (attrs != null) {
            String tagNames = (String)attrs.getAttribute("tagName");
            if (tagNames == null) {
                return;
            }
            tagList = tagNames.split("\\s", -1);
            String tagName = null;
            for (int i = 0; i < tagList.length; ++i) {
                tagName = tagList[i];
                Hashtable<Element, Object> ht = (Hashtable<Element, Object>)this.styleHash.get(tagName);
                if (ht == null) {
                    ht = new Hashtable<Element, Object>();
                    this.styleHash.put(tagName, ht);
                }
                if (ht.containsKey(elem)) continue;
                ht.put(elem, new Object());
            }
        }
    }

    protected void removeFromStyleHash(Element elem) {
        AttributeSet attrs = elem.getAttributes();
        String[] tagList = null;
        if (attrs != null) {
            String tagNames = (String)attrs.getAttribute("tagName");
            if (tagNames == null) {
                return;
            }
            tagList = tagNames.split("\\s", -1);
            String tagName = null;
            for (int i = 0; i < tagList.length; ++i) {
                tagName = tagList[i];
                Hashtable ht = (Hashtable)this.styleHash.get(tagName);
                if (ht == null) continue;
                ht.remove(elem);
            }
        }
    }

    public void indexParagraphs() {
        Element elem;
        ElementIterator elIter = new ElementIterator(this);
        this.paragraphs.setSize(0);
        while ((elem = elIter.next()) != null) {
            if (!elem.getName().equals("paragraph")) continue;
            this.paragraphs.addElement(elem);
        }
    }

    /*
     * Unable to fully structure code
     */
    void removeStyleFromRange(SwkJTextPane swkjtextpane, int index1, int index2, String tagName) {
        this.removeInProgress = true;
        rStyle = new StyleContext();
        this.endPosition = this.getEndPosition();
        endOffset = this.endPosition.getOffset();
        nextPos = index1;
        sbuf = new StringBuffer();
        do lbl-1000:
        // 4 sources

        {
            block9: {
                block8: {
                    e1 = this.getCharacterElement(nextPos);
                    start = e1.getStartOffset();
                    nextPos = end = e1.getEndOffset();
                    adjustStart = start;
                    adjustEnd = end;
                    if (index1 > adjustStart) {
                        adjustStart = index1;
                    }
                    if (index2 < adjustEnd) {
                        adjustEnd = index2;
                    }
                    if ((attrs = e1.getAttributes()) != null) break block8;
                    if (end < index2 && end < endOffset) ** GOTO lbl-1000
                    break;
                }
                checkName = (String)attrs.getAttribute("tagName");
                if (checkName != null) break block9;
                if (end < index2 && end < endOffset) ** GOTO lbl-1000
                break;
            }
            checkIndex = checkName.indexOf(tagName);
            lastChar = checkIndex + tagName.length();
            if (checkIndex == -1 || checkIndex != 0 && checkName.charAt(checkIndex - 1) != ' ' || lastChar != checkName.length() && checkName.charAt(lastChar) != ' ') continue;
            styleList = checkName.split("\\s", -1);
            if (tagName.equals(checkName)) {
                this.setCharacterAttributes(adjustStart, adjustEnd - adjustStart, rStyle.getEmptySet(), true);
                continue;
            }
            sbuf.setLength(0);
            for (j = 0; j < styleList.length; ++j) {
                if (styleList[j].equals(tagName)) continue;
                if (sbuf.length() > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(styleList[j]);
            }
            newTag = sbuf.toString();
            groupedStyle = swkjtextpane.getStyle(newTag);
            if (groupedStyle == null) {
                groupedStyle = swkjtextpane.addStyle(newTag, null);
                for (j = 0; j < styleList.length; ++j) {
                    if (styleList[j].equals(tagName) || (style = swkjtextpane.getStyle(styleList[j].toString())) == null) continue;
                    groupedStyle.addAttributes(style);
                }
            }
            groupedStyle.addAttribute("tagName", newTag);
            this.setCharacterAttributes(start, end - start, groupedStyle, true);
        } while (end < index2 && end < endOffset);
        this.removeInProgress = false;
    }

    /*
     * Unable to fully structure code
     */
    void addStyleToRange(SwkJTextPane swkjtextpane, int index1, int index2, String tagName) {
        rStyle = new StyleContext();
        this.endPosition = this.getEndPosition();
        endOffset = this.endPosition.getOffset();
        nextPos = index1;
        do lbl-1000:
        // 3 sources

        {
            block8: {
                e1 = this.getCharacterElement(nextPos);
                start = e1.getStartOffset();
                end = e1.getEndOffset();
                nextPos = end + 1;
                adjustStart = start;
                adjustEnd = end;
                if (index1 > adjustStart) {
                    adjustStart = index1;
                }
                if (index2 < adjustEnd) {
                    adjustEnd = index2;
                }
                if ((attrs = e1.getAttributes()) != null) break block8;
                if (end < index2 && end < endOffset) ** GOTO lbl-1000
                break;
            }
            oldName = (String)attrs.getAttribute("tagName");
            newName = null;
            if (oldName == null) {
                oldName = "";
            }
            checkIndex = oldName.indexOf(tagName);
            lastChar = checkIndex + tagName.length();
            if (!(checkIndex == -1 || checkIndex != 0 && oldName.charAt(checkIndex - 1) != ' ' || lastChar != oldName.length() && oldName.charAt(lastChar) != ' ')) {
                newName = oldName;
                continue;
            }
            newName = oldName != "" ? oldName + " " + tagName : tagName;
            styleList = newName.split("\\s", -1);
            groupedStyle = swkjtextpane.getStyle(newName);
            if (groupedStyle == null) {
                groupedStyle = swkjtextpane.addStyle(newName, null);
                for (j = 0; j < styleList.length; ++j) {
                    style = swkjtextpane.getStyle(styleList[j]);
                    groupedStyle.addAttributes(style);
                }
                groupedStyle.addAttribute("tagName", newName);
            }
            this.setCharacterAttributes(adjustStart, adjustEnd - adjustStart, groupedStyle, true);
        } while (end < index2 && end < endOffset);
    }

    public void setMarkGravity(SwkJTextPane swkjtextpane, String markName, String direction) throws IllegalArgumentException {
        int offset = 0;
        SwkPosition swkPosition = (SwkPosition)this.marks.get(markName);
        if (swkPosition == null) {
            throw new IllegalArgumentException("there is no mark named \"" + markName + "\"");
        }
        if (direction.equals("left")) {
            if (swkPosition.bias == Position.Bias.Backward) {
                return;
            }
            offset = swkPosition.position.getOffset();
            if (--offset < 0) {
                offset = 0;
            }
            swkPosition = new SwkPosition();
            try {
                swkPosition.position = this.createPosition(offset);
            }
            catch (BadLocationException badLoc) {
                throw new IllegalArgumentException("bad location in mark gravity");
            }
            swkPosition.bias = Position.Bias.Backward;
            this.marks.put(markName, swkPosition);
        } else if (direction.equals("right")) {
            if (swkPosition.bias == Position.Bias.Forward) {
                return;
            }
            offset = swkPosition.position.getOffset();
            this.endPosition = this.getEndPosition();
            int endOffset = this.endPosition.getOffset();
            if (++offset > endOffset) {
                offset = endOffset;
            }
            swkPosition = new SwkPosition();
            try {
                swkPosition.position = this.createPosition(offset);
            }
            catch (BadLocationException badLoc) {
                throw new IllegalArgumentException("bad location in mark gravity");
            }
            swkPosition.bias = Position.Bias.Forward;
            this.marks.put(markName, swkPosition);
        } else {
            throw new IllegalArgumentException("bad mark gravity \"" + direction + "\": must be left or right");
        }
    }

    public void setMark(SwkJTextPane swkjtextpane, String markName, String index) throws IllegalArgumentException {
        if (markName.toString().equals("end")) {
            return;
        }
        int offset = this.getIndexLC(swkjtextpane, index);
        this.endPosition = this.getEndPosition();
        int endOffset = this.endPosition.getOffset();
        if (offset >= endOffset) {
            offset = endOffset - 1;
        }
        if (markName.toString().equals("insert")) {
            swkjtextpane.setCaretPosition(offset);
            return;
        }
        try {
            SwkPosition swkPosition = new SwkPosition();
            swkPosition.position = this.createPosition(offset);
            this.marks.put(markName, swkPosition);
        }
        catch (BadLocationException badLoc) {
            System.out.println(badLoc.toString());
        }
    }

    public void unsetMarks(String[] markStrings) {
        for (int i = 0; i < markStrings.length; ++i) {
            this.marks.remove(markStrings[i]);
        }
    }

    public ArrayList getMarks() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = this.marks.keys();
        while (e.hasMoreElements()) {
            String mark = (String)e.nextElement();
            if (mark.startsWith(".")) continue;
            list.add(mark);
        }
        return list;
    }

    public ArrayList getTags() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = this.styleHash.keys();
        while (e.hasMoreElements()) {
            String tagName = (String)e.nextElement();
            list.add(tagName);
        }
        return list;
    }

    public Result compareIndices(SwkJTextPane swkjtextpane, String indexArg1, String op, String indexArg2) {
        int index1 = this.getIndexLC(swkjtextpane, indexArg1);
        int index2 = this.getIndexLC(swkjtextpane, indexArg2);
        Result result = new Result();
        result.setValue(false);
        if (op.equals("==")) {
            if (index1 == index2) {
                result.setValue(true);
            }
        } else if (op.equals("!=")) {
            if (index1 != index2) {
                result.setValue(true);
            }
        } else if (op.equals("<")) {
            if (index1 < index2) {
                result.setValue(true);
            }
        } else if (op.equals("<=")) {
            if (index1 <= index2) {
                result.setValue(true);
            }
        } else if (op.equals(">")) {
            if (index1 > index2) {
                result.setValue(true);
            }
        } else if (op.equals(">=")) {
            if (index1 >= index2) {
                result.setValue(true);
            }
        } else {
            result.setError("bad comparison operator \"" + op + "\": must be <, <=, ==, >=, >, or !=");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIndexLC(SwkJTextPane swkjtextpane, String indexArg) throws IllegalArgumentException {
        String baseString;
        String[] indexVals = indexArg.split("\\s", -1);
        String base = indexVals[0];
        String badTextIndex = "bad text index \"" + indexArg + "\"";
        int endCharPosition = base.toString().length();
        int dotPosition = base.toString().indexOf(".");
        int plusPosition = base.toString().indexOf("+");
        int minusPosition = base.toString().indexOf("-");
        if (dotPosition == -1 && (plusPosition == 0 || minusPosition == 0)) {
            throw new IllegalArgumentException(badTextIndex);
        }
        if (minusPosition == dotPosition + 1) {
            minusPosition = -1;
        }
        if (plusPosition > 0 && minusPosition > 0) {
            throw new IllegalArgumentException(badTextIndex);
        }
        if (plusPosition > 0 && plusPosition < dotPosition) {
            throw new IllegalArgumentException(badTextIndex);
        }
        if (minusPosition > 0 && minusPosition < dotPosition) {
            throw new IllegalArgumentException(badTextIndex);
        }
        if (plusPosition > 0) {
            endCharPosition = plusPosition;
            baseString = base.toString().substring(0, plusPosition).trim();
            indexVals[0] = base.substring(plusPosition);
        } else if (minusPosition > 0) {
            endCharPosition = minusPosition;
            baseString = base.substring(0, minusPosition).trim();
            indexVals[0] = base.substring(minusPosition);
        } else {
            baseString = base;
            indexVals[0] = null;
        }
        int offset = 0;
        int lineIndex = 1;
        int charIndex = 0;
        this.endPosition = this.getEndPosition();
        int endOffset = this.endPosition.getOffset();
        if (baseString.equals("end")) {
            offset = endOffset;
        } else if (baseString.equals("sel.first")) {
            offset = swkjtextpane.getSelectionStart();
        } else if (baseString.equals("sel.last")) {
            offset = swkjtextpane.getSelectionEnd();
        } else if (baseString.equals("insert")) {
            if (swkjtextpane == null) {
                return 0;
            }
            offset = swkjtextpane.getCaretPosition();
        } else {
            SwkPosition swkPosition = null;
            if (dotPosition > 0) {
                swkPosition = (SwkPosition)this.marks.get(baseString.substring(0, dotPosition));
                if (swkPosition != null) {
                    throw new IllegalArgumentException(badTextIndex);
                }
            } else {
                swkPosition = (SwkPosition)this.marks.get(baseString);
            }
            if (swkPosition != null) {
                offset = swkPosition.getOffset();
            } else if (baseString.startsWith("@")) {
                if (baseString.length() <= 1) throw new IllegalArgumentException(badTextIndex);
                int commaPos = baseString.indexOf(44);
                if (commaPos < 0) {
                    throw new IllegalArgumentException(badTextIndex);
                }
                String xS = baseString.substring(1, commaPos);
                String yS = baseString.substring(commaPos + 1);
                int x = Integer.valueOf(xS);
                int y = Integer.valueOf(yS);
                offset = swkjtextpane.viewToModel(new Point(x, y));
            } else if (dotPosition >= 0 && dotPosition < baseString.length() - 1) {
                block56: {
                    lineIndex = -1;
                    charIndex = 0;
                    try {
                        lineIndex = Integer.parseInt(baseString.substring(0, dotPosition));
                    }
                    catch (NumberFormatException nfE) {
                        if (baseString.substring(dotPosition + 1).equals("first")) {
                            offset = this.getRangeOffset(baseString.substring(0, dotPosition), 1);
                            if (offset < 0) {
                                throw new IllegalArgumentException("text doesn't contain any characters tagged with \"" + baseString.substring(0, dotPosition) + "\"");
                            }
                        }
                        if (!baseString.substring(dotPosition + 1).equals("last")) throw new IllegalArgumentException(badTextIndex);
                        offset = this.getRangeOffset(baseString.substring(0, dotPosition), 2);
                        if (offset >= 0) break block56;
                        throw new IllegalArgumentException("text doesn't contain any characters tagged with \"" + baseString.substring(0, dotPosition) + "\"");
                    }
                }
                if (lineIndex > 0) {
                    try {
                        charIndex = Integer.parseInt(baseString.substring(dotPosition + 1));
                    }
                    catch (NumberFormatException nfE) {
                        if (!baseString.substring(dotPosition + 1).equals("end")) throw new IllegalArgumentException(badTextIndex);
                        charIndex = Integer.MAX_VALUE;
                    }
                    this.indexParagraphs();
                    if (this.paragraphs.size() == 0) {
                        return 0;
                    }
                    if (lineIndex < 1) {
                        return 0;
                    }
                    if (lineIndex > this.paragraphs.size()) {
                        offset = endOffset;
                    } else {
                        Element elem = (Element)this.paragraphs.elementAt(lineIndex - 1);
                        if (elem != null) {
                            offset = charIndex < 0 ? elem.getStartOffset() : (charIndex >= elem.getEndOffset() - elem.getStartOffset() ? elem.getEndOffset() - 1 : elem.getStartOffset() + charIndex);
                        }
                    }
                }
            }
        }
        boolean gotSign = false;
        boolean gotValue = false;
        int delta = 0;
        int cpos = 0;
        int sign = 1;
        boolean gotUnits = false;
        for (int i = 0; i < indexVals.length; ++i) {
            if (indexVals[i] == null) continue;
            String modString = indexVals[i].toString();
            if (modString.equals("-")) {
                gotSign = true;
                gotUnits = false;
                sign = -1 * sign;
                continue;
            }
            if (modString.equals("+")) {
                gotUnits = false;
                gotSign = true;
                continue;
            }
            cpos = modString.length();
            int start = 0;
            if (modString.charAt(0) == '-') {
                start = 1;
                sign = -1 * sign;
                gotSign = true;
            } else if (modString.charAt(0) == '+') {
                start = 1;
                sign = 1;
                gotSign = true;
            }
            for (int j = start; j < modString.length(); ++j) {
                if (Character.isDigit(modString.charAt(j))) continue;
                cpos = j;
                break;
            }
            if (cpos > start) {
                delta = Integer.parseInt(modString.substring(start, cpos));
                gotValue = true;
                gotUnits = false;
            }
            if (cpos == modString.length()) continue;
            if ("chars".startsWith(modString.substring(cpos))) {
                if (!gotValue) throw new IllegalArgumentException(badTextIndex);
                gotUnits = true;
                gotSign = false;
                gotValue = false;
                if ((offset += sign * delta) >= 0) continue;
                offset = 0;
                continue;
            }
            if (gotValue && modString.substring(cpos).length() < 6 && "lines".startsWith(modString.substring(cpos))) {
                if (!gotValue) throw new IllegalArgumentException(badTextIndex);
                offset = this.indexMath(offset, sign * delta, 0);
                gotSign = false;
                gotValue = false;
                sign = 1;
                continue;
            }
            if (modString.substring(cpos).length() > 4 && "lineend".startsWith(modString)) {
                if (gotSign || gotValue) {
                    throw new IllegalArgumentException(badTextIndex);
                }
                gotUnits = true;
                offset = this.indexMath(offset, 0, 1);
                gotSign = false;
                gotValue = false;
                sign = 1;
                continue;
            }
            if (modString.substring(cpos).length() > 4 && "linestart".startsWith(modString)) {
                if (gotSign || gotValue) {
                    throw new IllegalArgumentException(badTextIndex);
                }
                gotUnits = true;
                offset = this.indexMath(offset, 0, -1);
                gotSign = false;
                gotValue = false;
                sign = 1;
                continue;
            }
            if (modString.substring(cpos).length() > 4 && "wordend".startsWith(modString)) {
                if (gotSign || gotValue) {
                    throw new IllegalArgumentException(badTextIndex);
                }
                offset = this.getWordEnd(offset);
                gotUnits = true;
                gotSign = false;
                gotValue = false;
                sign = 1;
                continue;
            }
            if (modString.substring(cpos).length() <= 4 || !"wordstart".startsWith(modString)) throw new IllegalArgumentException(badTextIndex);
            if (gotSign || gotValue) {
                throw new IllegalArgumentException(badTextIndex);
            }
            offset = this.getWordStart(offset);
            gotUnits = true;
            gotSign = false;
            gotValue = false;
            sign = 1;
        }
        if (!gotValue && !gotSign || gotUnits) return offset;
        throw new IllegalArgumentException("bad text index \"" + indexArg.toString() + "\"");
    }

    public String getIndex(SwkJTextPane swkjtextpane, String indexArg) {
        int offset = this.getIndexLC(swkjtextpane, indexArg);
        return this.getIndexFromOffset(offset, null);
    }

    public int indexMath(int offset, int dLine, int mode) {
        this.indexParagraphs();
        Element elem = null;
        int charIndex = 0;
        int endOffset = this.endPosition.getOffset();
        boolean foundOffset = false;
        int j = 0;
        for (j = 0; j < this.paragraphs.size(); ++j) {
            elem = (Element)this.paragraphs.elementAt(j);
            if (offset < elem.getStartOffset() || offset >= elem.getEndOffset()) continue;
            foundOffset = true;
            break;
        }
        if (!foundOffset) {
            return 0;
        }
        charIndex = offset - elem.getStartOffset();
        if ((j += dLine) < 0) {
            j = 0;
        } else if (j >= this.paragraphs.size()) {
            j = this.paragraphs.size() - 1;
        }
        elem = (Element)this.paragraphs.elementAt(j);
        offset = mode == -1 ? elem.getStartOffset() : (mode == 1 ? elem.getEndOffset() - 1 : (elem.getStartOffset() + charIndex <= elem.getEndOffset() ? elem.getStartOffset() + charIndex : elem.getEndOffset()));
        return offset;
    }

    public String getIndexFromOffset(int offset, TclObject[] indexVals) {
        this.indexParagraphs();
        Element elem = null;
        int charIndex = 0;
        int endOffset = this.endPosition.getOffset();
        if (offset >= endOffset) {
            return this.paragraphs.size() + 1 + ".0";
        }
        for (int j = 0; j < this.paragraphs.size(); ++j) {
            elem = (Element)this.paragraphs.elementAt(j);
            if (offset < elem.getStartOffset() || offset >= elem.getEndOffset()) continue;
            charIndex = offset - elem.getStartOffset();
            if (indexVals != null && indexVals.length == 2 && indexVals[1].toString().startsWith("lines")) {
                charIndex = 0;
            }
            if (indexVals != null && indexVals.length == 2 && indexVals[1].toString().startsWith("linee")) {
                charIndex = elem.getEndOffset() - elem.getStartOffset();
            }
            return j + 1 + "." + charIndex;
        }
        return "1.0";
    }

    public int getParagraph(int offset) {
        int endOffset = this.endPosition.getOffset();
        if (offset > endOffset) {
            return -1;
        }
        if (offset == endOffset) {
            return this.paragraphs.size() - 1;
        }
        Element elem = null;
        for (int j = 0; j < this.paragraphs.size(); ++j) {
            elem = (Element)this.paragraphs.elementAt(j);
            if (offset < elem.getStartOffset() || offset >= elem.getEndOffset()) continue;
            return j;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    public void removeStyle(SwkJTextPane swkjtextpane, String tagName) {
        Style style = swkjtextpane.getStyle(tagName);
        if (style == null) {
            return;
        }
        int endOffset = this.endPosition.getOffset();
        this.removeStyleFromRange(swkjtextpane, 0, endOffset - 1, tagName);
        Hashtable ht = (Hashtable)this.styleHash.get(tagName);
        if (ht == null) {
            return;
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Element bad = (Element)e.nextElement();
            ht.remove(bad);
        }
        this.styleHash.remove(tagName);
    }

    private int compare(int i, int j) {
        if ((Integer)this.rangeOffsets.elementAt(i) > (Integer)this.rangeOffsets.elementAt(j)) {
            return 1;
        }
        if ((Integer)this.rangeOffsets.elementAt(i) < (Integer)this.rangeOffsets.elementAt(j)) {
            return -1;
        }
        return 0;
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public String getRanges(String tagName, int mode) {
        return this.getRangeString(tagName, mode);
    }

    public String getRangeString(String tagName, int mode) {
        int[] indexes = this.getRangeArray(tagName);
        if (indexes == null) {
            return null;
        }
        if (mode == 0) {
            return this.getRangeString(indexes);
        }
        return this.getRangeString(indexes, mode);
    }

    public int getRangeOffset(String tagName, int mode) {
        int[] indexes = this.getRangeArray(tagName);
        if (indexes == null) {
            return -1;
        }
        return this.getRangeOffset(indexes, mode);
    }

    public int[] getRangeArray(String tagName) {
        Hashtable ht = (Hashtable)this.styleHash.get(tagName);
        String[] styleList = null;
        Object nextStyle = null;
        TclObject list = TclList.newInstance();
        this.rangeOffsets.setSize(0);
        if (ht != null) {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String checkName;
                Element el = (Element)e.nextElement();
                int start = el.getStartOffset();
                int end = el.getEndOffset();
                AttributeSet attrs = el.getAttributes();
                if (attrs == null || (checkName = (String)attrs.getAttribute("tagName")) == null) continue;
                int checkIndex = checkName.indexOf(tagName);
                int lastChar = checkIndex + tagName.length();
                if (checkIndex == -1 || checkIndex != 0 && checkName.charAt(checkIndex - 1) != ' ' || lastChar != checkName.length() && checkName.charAt(lastChar) != ' ') continue;
                styleList = checkName.split("\\s", -1);
                for (int j = 0; j < styleList.length; ++j) {
                    if (styleList[j].equals(tagName)) continue;
                }
                this.rangeOffsets.addElement(new Integer(start));
                this.rangeOffsets.addElement(new Integer(end));
            }
        }
        if (this.rangeOffsets.size() == 0) {
            return null;
        }
        this.indexes = new int[this.rangeOffsets.size()];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
        return this.indexes;
    }

    public String getRangeString(int[] indexes) {
        int level = 0;
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < indexes.length; ++i) {
            int j = indexes[i];
            if (j % 2 == 0) {
                if (level == 0) {
                    int start = (Integer)this.rangeOffsets.elementAt(j);
                    if (i != 0) {
                        sbuf.append(" ");
                    }
                    sbuf.append(this.getIndexFromOffset(start, null));
                }
                ++level;
                continue;
            }
            if (--level != 0) continue;
            int end = (Integer)this.rangeOffsets.elementAt(j);
            sbuf.append(" " + this.getIndexFromOffset(end, null));
        }
        return sbuf.toString();
    }

    public String getRangeString(int[] indexes, int mode) {
        if (mode == 1) {
            if (indexes.length == 0) {
                return "";
            }
            int firstIndex = indexes[0];
            int start = (Integer)this.rangeOffsets.elementAt(firstIndex);
            return this.getIndexFromOffset(start, null);
        }
        if (indexes.length == 0) {
            return "";
        }
        int lastIndex = indexes[indexes.length - 1];
        int end = (Integer)this.rangeOffsets.elementAt(lastIndex);
        return this.getIndexFromOffset(end, null);
    }

    public int getRangeOffset(int[] indexes, int mode) {
        if (mode == 1) {
            if (indexes.length == 0) {
                return 0;
            }
            int firstIndex = indexes[0];
            int start = (Integer)this.rangeOffsets.elementAt(firstIndex);
            return start;
        }
        if (indexes.length == 0) {
            return 0;
        }
        int lastIndex = indexes[indexes.length - 1];
        int end = (Integer)this.rangeOffsets.elementAt(lastIndex);
        return end;
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("asynchronousLoadPriority", "AsynchronousLoadPriority");
        resourceDB.put("-asynchronousloadpriority", resourceObject);
        resourceObject = new ResourceObject("documentProperties", "DocumentProperties");
        resourceDB.put("-documentproperties", resourceObject);
        resourceObject = new ResourceObject("width", "Width");
        resourceDB.put("-width", resourceObject);
    }

    static boolean looksLikeInt(String s, int len, int i) {
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        char c = s.charAt(i);
        if (c == '+' || c == '-') {
            if (++i >= len) {
                return false;
            }
            c = s.charAt(i);
        }
        if (!Character.isDigit(c)) {
            return false;
        }
        while (i < len && Character.isDigit(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return true;
        }
        c = s.charAt(i);
        return c != '.' && c != 'e' && c != 'E';
    }

    int getWordStart(int offset) {
        if (!this.isWordChar(offset)) {
            return offset;
        }
        while (offset >= 0 && this.isWordChar(offset)) {
            --offset;
        }
        return offset + 1;
    }

    int getWordEnd(int offset) {
        int endOffset = this.endPosition.getOffset();
        if (!this.isWordChar(offset)) {
            if (offset < endOffset) {
                return offset + 1;
            }
            return endOffset;
        }
        while (offset <= endOffset && this.isWordChar(offset)) {
            ++offset;
        }
        return offset;
    }

    boolean isWordChar(int offset) {
        char ch;
        int endOffset = this.endPosition.getOffset();
        try {
            ch = this.getText(offset, 1).charAt(0);
        }
        catch (BadLocationException badLoc) {
            return false;
        }
        return Character.isDigit(ch) || Character.isLetter(ch) || ch == '_';
    }

    class SwkPosition {
        Position position = null;
        Position.Bias bias = Position.Bias.Forward;

        SwkPosition() {
        }

        int getOffset() {
            int offset = this.position.getOffset();
            if (this.bias == Position.Bias.Backward) {
                return offset + 1;
            }
            return offset;
        }
    }
}

