/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class SwkFilenameFilter
implements FilenameFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public SwkFilenameFilter() {
    }

    public SwkFilenameFilter(String extension) {
        this(extension, null);
    }

    public SwkFilenameFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public SwkFilenameFilter(Interp interp, TclObject extensions, String description) throws TclException {
        this();
        TclObject[] argv = TclList.getElements((Interp)interp, (TclObject)extensions);
        for (int i = 0; i < argv.length; ++i) {
            this.addExtension(argv[i].toString());
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File path, String fileName) {
        if (path != null) {
            if (!path.isDirectory()) {
                return false;
            }
            Enumeration enumeration = this.filters.keys();
            while (enumeration.hasMoreElements()) {
                String filter = (String)enumeration.nextElement();
                if (!Util.stringMatch((String)fileName, (String)filter)) continue;
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", " + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

