/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SmoothParameter
extends CanvasParameter {
    private static String name = "smooth";
    private static String defValue = "";
    private String newValue = defValue;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-smooth".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        ItemLine swkLine = (ItemLine)swkShape;
        return TclString.newInstance((String)swkLine.smooth);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        boolean doSmooth = false;
        if (!arg.toString().equals("")) {
            doSmooth = arg.toString().equals("bezier") ? true : TclBoolean.get((Interp)interp, (TclObject)arg);
        }
        this.newValue = !doSmooth ? "" : arg.toString();
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof ItemLine) {
            ItemLine swkLine = (ItemLine)swkShape;
            swkLine.smooth = this.newValue;
        }
    }
}

