/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;

public final class ThreadsState {
    private CodeRunner mainCodeRunner = null;
    private OCamlJavaThread mainThread = null;
    private final ThreadGroup threadGroup;
    private final Set<Thread> additThreads;

    ThreadsState(boolean bl) {
        this.threadGroup = new ThreadGroup(OCamlJavaThread.getNextThreadGroupName(bl));
        this.additThreads = new HashSet<Thread>();
    }

    public CodeRunner getMainCodeRunner() {
        return this.mainCodeRunner;
    }

    public void setMainCodeRunner(CodeRunner codeRunner) {
        assert (codeRunner != null) : "null cr";
        this.mainCodeRunner = codeRunner;
    }

    public OCamlJavaThread getMainThread() {
        return this.mainThread;
    }

    public void setMainThread(OCamlJavaThread oCamlJavaThread) {
        assert (oCamlJavaThread != null) : "null ct";
        this.mainThread = oCamlJavaThread;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionalThread(Thread thread) {
        assert (thread != null) : "null t";
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            this.additThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAdditionalThread(Thread thread) {
        assert (thread != null) : "null t";
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            this.additThreads.remove(thread);
        }
        if (thread != Thread.currentThread()) return;
        ThreadLocalFactory.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interruptAdditionalThreads() {
        Set<Thread> set = this.additThreads;
        synchronized (set) {
            Iterator<Thread> iterator = this.additThreads.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.additThreads.clear();
                    return;
                }
                Thread thread = iterator.next();
                thread.interrupt();
            }
        }
    }
}

