/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Mutex;

final class Condition {
    private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
    private static final Object LOCK = new Object();

    Condition() {
    }

    void signal() {
        LockSupport.unpark(this.waiters.poll());
    }

    void broadcast() {
        Thread thread = this.waiters.poll();
        while (thread != null) {
            LockSupport.unpark(thread);
            thread = this.waiters.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void wait(Context context, Mutex mutex) throws Fail.Exception, FalseExit {
        Object object = LOCK;
        synchronized (object) {
            try {
                mutex.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                Fail.raiseSysError("Condition.wait: " + illegalMonitorStateException.toString());
            }
            Thread thread = Thread.currentThread();
            this.waiters.add(thread);
        }
        Thread.yield();
        LockSupport.park();
        mutex.lock(context);
    }
}

