/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Array", source="byterun/array.c")
public final class Array {
    private Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get_addr(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        return value.get(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_get_float(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return Value.createDouble(value.getDouble(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get(Value value, Value value2) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_get_float(value, value2);
        }
        return Array.caml_array_get_addr(value, value2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set_addr(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        value.set(l, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int", "float"}, returnType="unit")
    public static Value caml_array_set_float(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        value.setDouble(l, value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set(Value value, Value value2, Value value3) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_set_float(value, value2, value3);
        }
        return Array.caml_array_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_unsafe_get_float(Value value, Value value2) {
        return Value.createDouble(value.getDouble(value2.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_unsafe_get(Value value, Value value2) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_get_float(value, value2);
        }
        return value.get(value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_addr(Value value, Value value2, Value value3) {
        value.set(value2.asLong(), value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_float(Value value, Value value2, Value value3) {
        value.setDouble(value2.asLong(), value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set(Value value, Value value2, Value value3) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_set_float(value, value2, value3);
        }
        return Array.caml_array_unsafe_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "'a"}, returnType="'a array")
    public static Value caml_make_vect(Value value, Value value2) throws Fail.Exception {
        Value value3;
        block7: {
            Value value4;
            block6: {
                block4: {
                    long l;
                    block5: {
                        l = value.asLong();
                        if (l == 0L) break block4;
                        if (!value2.isDouble()) break block5;
                        double d = value2.asDouble();
                        if (l * 1L > 0x3FFFFFFFFFFFFFL) {
                            Fail.invalidArgument("Array.make");
                        }
                        value4 = Value.createDoubleArray(l);
                        int n = 0;
                        while ((long)n < l) {
                            value4.setDouble(n, d);
                            ++n;
                        }
                        break block6;
                    }
                    if (l > 0x3FFFFFFFFFFFFFL) {
                        Fail.invalidArgument("Array.make");
                    }
                    value3 = Value.createBlock(0, l);
                    int n = 0;
                    while ((long)n < l) {
                        value3.set(n, value2);
                        ++n;
                    }
                    break block7;
                }
                return CurrentContext.CODE_STATE.getAtom(0);
            }
            return value4;
        }
        return value3;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array"}, returnType="'a array")
    public static Value caml_make_array(Value value) {
        Value value2;
        block3: {
            block2: {
                block1: {
                    long l = value.getWoSize();
                    if (l == 0L) break block1;
                    Value value3 = value.get0();
                    if (value3.isLong() || !value3.isDouble()) break block2;
                    value2 = Value.createDoubleArray(l);
                    for (long i = 0L; i < l; ++i) {
                        value2.setDouble(i, value.get(i).asDouble());
                    }
                    break block3;
                }
                return value;
            }
            return value;
        }
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a array", "int", "int"}, returnType="unit")
    public static Value caml_array_blit(Value value, Value value2, Value value3, Value value4, Value value5) {
        value.blitArray(value2.asLong(), value3, value4.asLong(), value5.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "int"}, returnType="'a array")
    public static Value caml_array_sub(Value value, Value value2, Value value3) {
        return value.subArray(value2.asLong(), value3.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "'a array"}, returnType="'a array")
    public static Value caml_array_append(Value value, Value value2) {
        return Array.concat(new Value[]{value, value2});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array list"}, returnType="'a array")
    public static Value caml_array_concat(Value value) {
        int n = 0;
        Value value2 = value;
        while (value2.isBlock()) {
            ++n;
            value2 = value2.get1();
        }
        Value[] valueArray = new Value[n];
        int n2 = 0;
        value2 = value;
        while (value2.isBlock()) {
            valueArray[n2++] = value2.get0();
            value2 = value2.get1();
        }
        return Array.concat(valueArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Value concat(Value[] valueArray) {
        int n;
        long l;
        block26: {
            block24: {
                block27: {
                    block18: {
                        block25: {
                            block19: {
                                block23: {
                                    boolean bl = false;
                                    boolean bl2 = true;
                                    l = 0L;
                                    n = valueArray.length;
                                    int n2 = 0;
                                    while (true) {
                                        block22: {
                                            Value value;
                                            block21: {
                                                block20: {
                                                    if (n2 >= n) break block20;
                                                    value = valueArray[n2];
                                                    if (!value.isDoubleArray()) break block21;
                                                    bl = true;
                                                    bl2 = false;
                                                    l += value.sizeDoubles();
                                                    break block22;
                                                }
                                                if (!bl) break;
                                                if (l >= Value.MAX_INTEGER) break block18;
                                                break block19;
                                            }
                                            if (value.isLongBlock()) {
                                                l += value.sizeLongs();
                                            } else {
                                                bl2 = false;
                                                l += value.sizeValues();
                                            }
                                        }
                                        ++n2;
                                    }
                                    if (!bl2) break block23;
                                    if (l >= Value.MAX_INTEGER) break block24;
                                    break block25;
                                }
                                if (l >= Value.MAX_INTEGER) break block26;
                                break block27;
                            }
                            double[] dArray = new double[(int)l];
                            int n3 = 0;
                            int n4 = 0;
                            while (true) {
                                if (n4 >= n) {
                                    return Value.createDoubleArray(dArray);
                                }
                                Value value = valueArray[n4];
                                value.copyDoublesIntoArray(dArray, n3);
                                n3 = (int)((long)n3 + (value.isDoubleArray() ? value.sizeDoubles() : value.sizeValues()));
                                ++n4;
                            }
                        }
                        long[] lArray = new long[(int)l];
                        int n5 = 0;
                        int n6 = 0;
                        while (true) {
                            if (n6 >= n) {
                                return Value.createLongBlock(0, lArray);
                            }
                            Value value = valueArray[n6];
                            value.copyRawLongsIntoArray(lArray, n5);
                            n5 = (int)((long)n5 + (value.isLongBlock() ? value.sizeLongs() : value.sizeValues()));
                            ++n6;
                        }
                    }
                    Value value = Value.createDoubleArray(l);
                    long l2 = 0L;
                    int n7 = 0;
                    while (true) {
                        if (n7 >= n) {
                            return value;
                        }
                        Value value2 = valueArray[n7];
                        long l3 = value2.isDoubleArray() ? value2.sizeDoubles() : value2.sizeValues();
                        for (long i = 0L; i < l3; ++i) {
                            value.setDouble(l2 + i, value2.getDouble(i));
                        }
                        l2 += l3;
                        ++n7;
                    }
                }
                Value[] valueArray2 = new Value[(int)l];
                int n8 = 0;
                int n9 = 0;
                while (true) {
                    if (n9 >= n) {
                        return Value.createBlock(0, valueArray2);
                    }
                    Value value = valueArray[n9];
                    value.copyValuesIntoArray(valueArray2, n8);
                    n8 = (int)((long)n8 + (value.isDoubleArray() ? value.sizeDoubles() : value.sizeValues()));
                    ++n9;
                }
            }
            Value value = Value.createLongBlock(0, l);
            long l4 = 0L;
            int n10 = 0;
            while (true) {
                if (n10 >= n) {
                    return value;
                }
                Value value3 = valueArray[n10];
                long l5 = value3.isLongBlock() ? value3.sizeLongs() : value3.sizeValues();
                for (long i = 0L; i < l5; ++i) {
                    value.setRawLong(l4 + i, value3.getRawLong(i));
                }
                l4 += l5;
                ++n10;
            }
        }
        Value value = Value.createBlock(0, l);
        long l6 = 0L;
        int n11 = 0;
        while (n11 < n) {
            Value value4 = valueArray[n11];
            long l7 = value4.isDoubleArray() ? value4.sizeDoubles() : value4.sizeValues();
            for (long i = 0L; i < l7; ++i) {
                value.set(l6 + i, value4.get(i));
            }
            l6 += l7;
            ++n11;
        }
        return value;
    }
}

