/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/bind.c")
public final class Bind {
    private Bind() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "Unit.sockaddr"}, returnType="unit")
    public static Value unix_bind(Value value, Value value2) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel != null) {
            try {
                channel.bind(new InetSocketAddress(InetAddress.getByAddress(value2.get0().getBytes()), value2.get1().asCastedInt()));
            }
            catch (InterruptedIOException interruptedIOException) {
                FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
                falseExit.fillInStackTrace();
                throw falseExit;
            }
            catch (IOException iOException) {
                Unix.fail("bind", iOException);
            }
        } else {
            Unix.fail("bind", "invalid descriptor");
            return Value.UNIT;
        }
        return Value.UNIT;
    }
}

