/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.invoke.MethodHandle;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractValue;
import org.ocamljava.runtime.values.BasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CachedStringValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.CustomValue;
import org.ocamljava.runtime.values.DoubleArrayValue;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.DoubleValue;
import org.ocamljava.runtime.values.InfixBlockValue;
import org.ocamljava.runtime.values.Int32Value;
import org.ocamljava.runtime.values.Int64Value;
import org.ocamljava.runtime.values.LargeBasicBlockValue;
import org.ocamljava.runtime.values.LargeDoubleArrayValue;
import org.ocamljava.runtime.values.LargeLongBlockValue;
import org.ocamljava.runtime.values.LargeStringValue;
import org.ocamljava.runtime.values.LargeWeakBlockValue;
import org.ocamljava.runtime.values.LongBlockValue;
import org.ocamljava.runtime.values.LongBlockValue0;
import org.ocamljava.runtime.values.LongBlockValue1;
import org.ocamljava.runtime.values.LongBlockValue2;
import org.ocamljava.runtime.values.LongBlockValue3;
import org.ocamljava.runtime.values.LongBlockValue4;
import org.ocamljava.runtime.values.LongBlockValue5;
import org.ocamljava.runtime.values.LongBlockValue6;
import org.ocamljava.runtime.values.LongBlockValue7;
import org.ocamljava.runtime.values.LongBlockValue8;
import org.ocamljava.runtime.values.LongValue;
import org.ocamljava.runtime.values.MethodHandleValue;
import org.ocamljava.runtime.values.NativeIntValue;
import org.ocamljava.runtime.values.OffsetValue;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.StringValue;
import org.ocamljava.runtime.values.WeakBlockValue;

public abstract class Value {
    public static final int LONG_SIZE = 8;
    public static final Value UNIT;
    public static final Value FALSE;
    public static final Value TRUE;
    public static final Value EMPTY_LIST;
    public static final Value ZERO;
    public static final Value ONE;
    public static final Value TWO;
    public static final Value THREE;
    public static final Value FOUR;
    public static final Value FIVE;
    public static final Value SIX;
    public static final Value SEVEN;
    public static final Value EIGHT;
    public static final Value MINUS_ONE;
    public static final Value MINUS_TWO;
    public static final long MAX_LONG = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN_LONG = -4611686018427387904L;
    public static final long MIN_CACHED_VALUE = -128L;
    public static final long MAX_CACHED_VALUE = 255L;
    public static final long MIN_RAW_CACHED_VALUE = -255L;
    public static final long MAX_RAW_CACHED_VALUE = 511L;
    public static final int MAX_HASH_ELEMENTS = 32;
    private static final long UNIT_AS_LONG = 0L;
    private static final long FALSE_AS_LONG = 0L;
    private static final long TRUE_AS_LONG = 1L;
    private static final long EMPTY_LIST_AS_LONG = 0L;
    private static final LongValue[] CACHED_VALUES;
    private static final LongValue[] RAW_CACHED_VALUES;
    public static long MAX_INTEGER;
    public static long MIN_INTEGER;
    private static final long INTEGER_CARDINALITY;

    public static Value createLong(long l) {
        if (l >= -128L && l <= 255L) {
            return CACHED_VALUES[(int)(l - -128L)];
        }
        long l2 = l << 1;
        return new LongValue(l2 >> 1, l2 | 1L);
    }

    public static Value createCodeOffset(long l) {
        return new OffsetValue(l << 1 >> 1);
    }

    public static Value createFromRawValue(long l) {
        if ((l & 1L) != 0L) {
            return Value.createLong(l >> 1);
        }
        return new OffsetValue(l >> 1);
    }

    public static Value createFromRawLong(long l) {
        if (l < -255L || l > 511L) {
            assert ((l & 1L) != 0L) : "invalid value";
        } else {
            LongValue longValue = RAW_CACHED_VALUES[(int)(l - -255L)];
            assert (longValue != null) : "null res";
            return longValue;
        }
        return new LongValue(l >> 1, l);
    }

    public static Value createString(long l) {
        if (l < MAX_INTEGER) {
            return new StringValue((int)l);
        }
        return new LargeStringValue(l);
    }

    public static Value createString(byte[] byArray) {
        return new StringValue(byArray);
    }

    public static Value createString(String string) {
        return new CachedStringValue(string);
    }

    public static Value createInt(long l) {
        return Value.createLong(l);
    }

    public static Value createInt32(int n) {
        return new Int32Value(n);
    }

    public static Value createNativeInt(long l) {
        return new NativeIntValue(l);
    }

    public static Value createInt64(long l) {
        return new Int64Value(l);
    }

    public static Value createChannel(Channel channel) {
        assert (channel != null) : "null ch";
        return Value.createCustom(PredefinedCustomOperations.CHANNEL_OPS, 65580L, channel);
    }

    public static Value createInstance(Object object) {
        return Value.createCustom(PredefinedCustomOperations.JAVA_OPS, 8L, object);
    }

    public static Value createStringArray(String[] stringArray) {
        assert (stringArray != null) : "null s";
        int n = stringArray.length;
        Value value = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value.set(i, Value.createString(stringArray[i]));
        }
        return value;
    }

    public static Value createCustom(CustomOperations customOperations, long l, Object object) {
        CustomValue customValue = new CustomValue(customOperations, l, object);
        if (customOperations.isFinalized()) {
            CurrentContext.FINALIZERS_STATE.addFinalizer(customValue);
        }
        return customValue;
    }

    public static Value createCustom(CustomOperations customOperations, long l) {
        return Value.createCustom(customOperations, l, null);
    }

    public static Value createAbstract(long l, Object object) {
        return new AbstractValue(l, object);
    }

    public static Value createBlock(int n, long l) {
        if (l < MAX_INTEGER) {
            int n2 = (int)l;
            switch (n2) {
                case 0: {
                    return new BasicBlockValue0(n);
                }
                case 1: {
                    return new BasicBlockValue1(n, ZERO);
                }
                case 2: {
                    return new BasicBlockValue2(n, ZERO, ZERO);
                }
                case 3: {
                    return new BasicBlockValue3(n, ZERO, ZERO, ZERO);
                }
                case 4: {
                    return new BasicBlockValue4(n, ZERO, ZERO, ZERO, ZERO);
                }
                case 5: {
                    return new BasicBlockValue5(n, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 6: {
                    return new BasicBlockValue6(n, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 7: {
                    return new BasicBlockValue7(n, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
                case 8: {
                    return new BasicBlockValue8(n, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO);
                }
            }
            return new BasicBlockValue(n, n2);
        }
        return new LargeBasicBlockValue(n, l);
    }

    public static Value createBlock(int n) {
        return new BasicBlockValue0(n);
    }

    public static Value createBlock(int n, Value value) {
        return new BasicBlockValue1(n, value);
    }

    public static Value createBlock(int n, Value value, Value value2) {
        return new BasicBlockValue2(n, value, value2);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3) {
        return new BasicBlockValue3(n, value, value2, value3);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3, Value value4) {
        return new BasicBlockValue4(n, value, value2, value3, value4);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3, Value value4, Value value5) {
        return new BasicBlockValue5(n, value, value2, value3, value4, value5);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return new BasicBlockValue6(n, value, value2, value3, value4, value5, value6);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return new BasicBlockValue7(n, value, value2, value3, value4, value5, value6, value7);
    }

    public static Value createBlock(int n, Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        return new BasicBlockValue8(n, value, value2, value3, value4, value5, value6, value7, value8);
    }

    public static Value createBlock(int n, Value[] valueArray) {
        int n2 = valueArray.length;
        switch (n2) {
            case 0: {
                return new BasicBlockValue0(n);
            }
            case 1: {
                return new BasicBlockValue1(n, valueArray[0]);
            }
            case 2: {
                return new BasicBlockValue2(n, valueArray[0], valueArray[1]);
            }
            case 3: {
                return new BasicBlockValue3(n, valueArray[0], valueArray[1], valueArray[2]);
            }
            case 4: {
                return new BasicBlockValue4(n, valueArray[0], valueArray[1], valueArray[2], valueArray[3]);
            }
            case 5: {
                return new BasicBlockValue5(n, valueArray[0], valueArray[1], valueArray[2], valueArray[3], valueArray[4]);
            }
            case 6: {
                return new BasicBlockValue6(n, valueArray[0], valueArray[1], valueArray[2], valueArray[3], valueArray[4], valueArray[5]);
            }
            case 7: {
                return new BasicBlockValue7(n, valueArray[0], valueArray[1], valueArray[2], valueArray[3], valueArray[4], valueArray[5], valueArray[6]);
            }
            case 8: {
                return new BasicBlockValue8(n, valueArray[0], valueArray[1], valueArray[2], valueArray[3], valueArray[4], valueArray[5], valueArray[6], valueArray[7]);
            }
        }
        return new BasicBlockValue(n, valueArray);
    }

    public abstract Value get(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract Value get(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract Value get0();

    public abstract Value get1();

    public abstract Value get2();

    public abstract Value get3();

    public abstract Value get4();

    public abstract Value get5();

    public abstract Value get6();

    public abstract Value get7();

    public abstract void set(long var1, Value var3) throws ArrayIndexOutOfBoundsException;

    public abstract void set(int var1, Value var2) throws ArrayIndexOutOfBoundsException;

    public abstract void set0(Value var1);

    public abstract void set1(Value var1);

    public abstract void set2(Value var1);

    public abstract void set3(Value var1);

    public abstract void set4(Value var1);

    public abstract void set5(Value var1);

    public abstract void set6(Value var1);

    public abstract void set7(Value var1);

    public abstract long sizeValues();

    public static Value createDoubleArray(long l) {
        if (l < MAX_INTEGER) {
            int n = (int)l;
            switch (n) {
                case 0: {
                    return new DoubleArrayValue0();
                }
                case 1: {
                    return new DoubleArrayValue1();
                }
                case 2: {
                    return new DoubleArrayValue2();
                }
                case 3: {
                    return new DoubleArrayValue3();
                }
                case 4: {
                    return new DoubleArrayValue4();
                }
                case 5: {
                    return new DoubleArrayValue5();
                }
                case 6: {
                    return new DoubleArrayValue6();
                }
                case 7: {
                    return new DoubleArrayValue7();
                }
                case 8: {
                    return new DoubleArrayValue8();
                }
            }
            return new DoubleArrayValue(n);
        }
        return new LargeDoubleArrayValue(l);
    }

    public static Value createDoubleArray() {
        return new DoubleArrayValue0();
    }

    public static Value createDoubleArray(double d) {
        return new DoubleArrayValue1(d);
    }

    public static Value createDoubleArray(double d, double d2) {
        return new DoubleArrayValue2(d, d2);
    }

    public static Value createDoubleArray(double d, double d2, double d3) {
        return new DoubleArrayValue3(d, d2, d3);
    }

    public static Value createDoubleArray(double d, double d2, double d3, double d4) {
        return new DoubleArrayValue4(d, d2, d3, d4);
    }

    public static Value createDoubleArray(double d, double d2, double d3, double d4, double d5) {
        return new DoubleArrayValue5(d, d2, d3, d4, d5);
    }

    public static Value createDoubleArray(double d, double d2, double d3, double d4, double d5, double d6) {
        return new DoubleArrayValue6(d, d2, d3, d4, d5, d6);
    }

    public static Value createDoubleArray(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return new DoubleArrayValue7(d, d2, d3, d4, d5, d6, d7);
    }

    public static Value createDoubleArray(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return new DoubleArrayValue8(d, d2, d3, d4, d5, d6, d7, d8);
    }

    public static Value createDoubleArray(double[] dArray) {
        int n = dArray.length;
        switch (n) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(dArray[0]);
            }
            case 2: {
                return new DoubleArrayValue2(dArray[0], dArray[1]);
            }
            case 3: {
                return new DoubleArrayValue3(dArray[0], dArray[1], dArray[2]);
            }
            case 4: {
                return new DoubleArrayValue4(dArray[0], dArray[1], dArray[2], dArray[3]);
            }
            case 5: {
                return new DoubleArrayValue5(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4]);
            }
            case 6: {
                return new DoubleArrayValue6(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            }
            case 7: {
                return new DoubleArrayValue7(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]);
            }
            case 8: {
                return new DoubleArrayValue8(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
            }
        }
        return new DoubleArrayValue(dArray);
    }

    public abstract double getDouble(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getDouble(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getDouble0();

    public abstract double getDouble1();

    public abstract double getDouble2();

    public abstract double getDouble3();

    public abstract double getDouble4();

    public abstract double getDouble5();

    public abstract double getDouble6();

    public abstract double getDouble7();

    public abstract void setDouble(long var1, double var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setDouble(int var1, double var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setDouble0(double var1);

    public abstract void setDouble1(double var1);

    public abstract void setDouble2(double var1);

    public abstract void setDouble3(double var1);

    public abstract void setDouble4(double var1);

    public abstract void setDouble5(double var1);

    public abstract void setDouble6(double var1);

    public abstract void setDouble7(double var1);

    public abstract long sizeDoubles();

    public abstract double getGenericDouble(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getGenericDouble(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract double getGenericDouble0();

    public abstract double getGenericDouble1();

    public abstract double getGenericDouble2();

    public abstract double getGenericDouble3();

    public abstract double getGenericDouble4();

    public abstract double getGenericDouble5();

    public abstract double getGenericDouble6();

    public abstract double getGenericDouble7();

    public abstract void setGenericDouble(long var1, double var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setGenericDouble(int var1, double var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setGenericDouble0(double var1);

    public abstract void setGenericDouble1(double var1);

    public abstract void setGenericDouble2(double var1);

    public abstract void setGenericDouble3(double var1);

    public abstract void setGenericDouble4(double var1);

    public abstract void setGenericDouble5(double var1);

    public abstract void setGenericDouble6(double var1);

    public abstract void setGenericDouble7(double var1);

    public static Value createLongBlockFromSize(int n, long l) {
        if (l < MAX_INTEGER) {
            int n2 = (int)l;
            switch (n2) {
                case 0: {
                    return new LongBlockValue0(n);
                }
                case 1: {
                    return new LongBlockValue1(n, 0L);
                }
                case 2: {
                    return new LongBlockValue2(n, 0L, 0L);
                }
                case 3: {
                    return new LongBlockValue3(n, 0L, 0L, 0L);
                }
                case 4: {
                    return new LongBlockValue4(n, 0L, 0L, 0L, 0L);
                }
                case 5: {
                    return new LongBlockValue5(n, 0L, 0L, 0L, 0L, 0L);
                }
                case 6: {
                    return new LongBlockValue6(n, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 7: {
                    return new LongBlockValue7(n, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
                case 8: {
                    return new LongBlockValue8(n, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
                }
            }
            return new LongBlockValue(n, n2);
        }
        return new LargeLongBlockValue(n, l);
    }

    public static Value createLongBlock(int n) {
        return new LongBlockValue0(n);
    }

    public static Value createLongBlock(int n, long l) {
        return new LongBlockValue1(n, l);
    }

    public static Value createLongBlock(int n, long l, long l2) {
        return new LongBlockValue2(n, l, l2);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3) {
        return new LongBlockValue3(n, l, l2, l3);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3, long l4) {
        return new LongBlockValue4(n, l, l2, l3, l4);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3, long l4, long l5) {
        return new LongBlockValue5(n, l, l2, l3, l4, l5);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3, long l4, long l5, long l6) {
        return new LongBlockValue6(n, l, l2, l3, l4, l5, l6);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        return new LongBlockValue7(n, l, l2, l3, l4, l5, l6, l7);
    }

    public static Value createLongBlock(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        return new LongBlockValue8(n, l, l2, l3, l4, l5, l6, l7, l8);
    }

    public static Value createLongBlock(int n, long[] lArray) {
        int n2 = lArray.length;
        switch (n2) {
            case 0: {
                return new LongBlockValue0(n);
            }
            case 1: {
                return new LongBlockValue1(n, lArray[0]);
            }
            case 2: {
                return new LongBlockValue2(n, lArray[0], lArray[1]);
            }
            case 3: {
                return new LongBlockValue3(n, lArray[0], lArray[1], lArray[2]);
            }
            case 4: {
                return new LongBlockValue4(n, lArray[0], lArray[1], lArray[2], lArray[3]);
            }
            case 5: {
                return new LongBlockValue5(n, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }
            case 6: {
                return new LongBlockValue6(n, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5]);
            }
            case 7: {
                return new LongBlockValue7(n, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6]);
            }
            case 8: {
                return new LongBlockValue8(n, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7]);
            }
        }
        return new LongBlockValue(n, lArray);
    }

    public abstract long getRawLong(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract long getRawLong(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract long getRawLong0();

    public abstract long getRawLong1();

    public abstract long getRawLong2();

    public abstract long getRawLong3();

    public abstract long getRawLong4();

    public abstract long getRawLong5();

    public abstract long getRawLong6();

    public abstract long getRawLong7();

    public abstract void setRawLong(long var1, long var3) throws ArrayIndexOutOfBoundsException;

    public abstract void setRawLong(int var1, long var2) throws ArrayIndexOutOfBoundsException;

    public abstract void setRawLong0(long var1);

    public abstract void setRawLong1(long var1);

    public abstract void setRawLong2(long var1);

    public abstract void setRawLong3(long var1);

    public abstract void setRawLong4(long var1);

    public abstract void setRawLong5(long var1);

    public abstract void setRawLong6(long var1);

    public abstract void setRawLong7(long var1);

    public abstract long sizeLongs();

    public static Value createDouble(double d) {
        return new DoubleValue(d);
    }

    public static Value createClosure(long l) {
        Value value = Value.createBlock(247, l);
        if (l > 0L) {
            value.set(0L, Value.createCodeOffset(0L));
        }
        return value;
    }

    public static Value createClosure(long l, long l2) {
        Value value = Value.createBlock(247, l);
        if (l > 0L) {
            value.set(0L, Value.createCodeOffset(l2));
        }
        return value;
    }

    public static Value createClosure(MethodHandle methodHandle) {
        Value value = Value.createBlock(247, ZERO, ONE);
        value.set0(new MethodHandleValue(methodHandle, value));
        return value;
    }

    public static Value createClosure(MethodHandle methodHandle, int n) {
        Value value = Value.createCodeOffset(n < 0 ? -1L : (long)(-n - 1));
        Value value2 = Value.createBlock(247, value, Value.createLong(n), ZERO);
        value2.set2(new MethodHandleValue(methodHandle, value2));
        return value2;
    }

    public static Value createInfix(int n) {
        return new InfixBlockValue(n);
    }

    public static Value createAtom(int n) {
        return new BasicBlockValue0(n);
    }

    public static Value createWeakBlock(long l) {
        if (l < MAX_INTEGER) {
            return new WeakBlockValue((int)l);
        }
        return new LargeWeakBlockValue(l);
    }

    public abstract double asDouble();

    public abstract void setDouble(double var1);

    public abstract long getCode();

    public abstract void setCode(long var1);

    public abstract int getTag();

    public abstract long getHeader();

    public abstract long getWoSize();

    public abstract long getMagicNumber();

    public abstract void setTag(int var1);

    public abstract boolean isLong();

    public abstract boolean isCodeOffset();

    public abstract boolean isMethodHandle();

    public abstract boolean isBlock();

    public abstract boolean isDoubleArray();

    public abstract boolean isLongBlock();

    public abstract boolean isDouble();

    public abstract long getRawValue();

    public abstract long asLong();

    public abstract int asCastedInt();

    public abstract int asBoundedInt() throws Fatal.Exception;

    public abstract long asCodeOffset();

    public int getApplicationKind() {
        block1: {
            block2: {
                block0: {
                    long l = this.asCodeOffset();
                    if (l == -1L) break block0;
                    if (l < 0L) break block1;
                    break block2;
                }
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public abstract BlockValue asBlock();

    public abstract String asString();

    public abstract byte[] getBytes();

    public abstract byte[] getBytesForModification();

    public abstract int[] getUnsignedBytes();

    public abstract byte getByte(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setByte(long var1, byte var3) throws ArrayIndexOutOfBoundsException;

    public abstract int getUnsignedByte(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setUnsignedByte(long var1, int var3) throws ArrayIndexOutOfBoundsException;

    public abstract long sizeBytes();

    public abstract long sizeBytesTagged();

    public abstract long sizeBytesMinusOneTagged();

    public abstract Value sizeBytesWrapped();

    public abstract Value getWeak(long var1) throws ArrayIndexOutOfBoundsException;

    public abstract void setWeak(long var1, Value var3) throws ArrayIndexOutOfBoundsException;

    public abstract long sizeWeakValues();

    public abstract int asInt32();

    public abstract void setInt32(int var1);

    public abstract long asNativeInt();

    public abstract void setNativeInt(long var1);

    public abstract long asInt64();

    public abstract void setInt64(long var1);

    public abstract CustomOperations getCustomOperations();

    public abstract Object asCustom();

    public abstract void setCustom(Object var1);

    public abstract void setParent(BlockValue var1);

    public abstract BlockValue getParent();

    public final Value setClosure(MethodHandle methodHandle) {
        assert (methodHandle != null) : "null mh";
        this.set0(new MethodHandleValue(methodHandle, this));
        this.set1(ONE);
        return this;
    }

    public final Value setClosure(MethodHandle methodHandle, int n) {
        assert (methodHandle != null) : "null mh";
        Value value = Value.createCodeOffset(n < 0 ? -1L : (long)(-n - 1));
        this.set0(value);
        this.set1(Value.createLong(n));
        this.set2(new MethodHandleValue(methodHandle, this));
        return this;
    }

    public final Value setInfix(MethodHandle methodHandle, long l) {
        assert (methodHandle != null) : "null mh";
        Value value = Value.createInfix((int)(l + 1L));
        value.setParent((BlockValue)this);
        value.set0(new MethodHandleValue(methodHandle, value));
        this.set(l, Value.createFromRawValue(value.getTag()));
        this.set(l + 1L, value);
        this.set(l + 2L, ONE);
        return this;
    }

    public final Value setInfix(MethodHandle methodHandle, long l, int n) {
        assert (methodHandle != null) : "null mh";
        Value value = Value.createCodeOffset(n < 0 ? -1L : (long)(-n - 1));
        Value value2 = Value.createInfix((int)(l + 1L));
        value2.setParent((BlockValue)this);
        value2.set0(value);
        this.set(l, Value.createFromRawValue(value2.getTag()));
        this.set(l + 1L, value2);
        this.set(l + 2L, Value.createLong(n));
        this.set(l + 3L, (Value)new MethodHandleValue(methodHandle, value2));
        return this;
    }

    public abstract void set(Value var1, long var2) throws ArrayIndexOutOfBoundsException;

    public abstract Value offset(long var1);

    public abstract long arrayLength();

    public abstract long arrayLengthTagged();

    public abstract long arrayLengthMinusOneTagged();

    public abstract Value arrayLengthWrapped();

    public abstract int switchTag();

    public abstract Value duplicate();

    public abstract void copyValuesIntoArray(Value[] var1);

    public abstract void copyValuesIntoArray(Value[] var1, int var2);

    public abstract void copyDoublesIntoArray(double[] var1, int var2);

    public abstract void copyRawLongsIntoArray(long[] var1, int var2);

    public abstract Value subArray(long var1, long var3);

    public abstract void blitArray(long var1, Value var3, long var4, long var6);

    private static int kind(Value value) {
        block1: {
            block2: {
                block0: {
                    if (value.isBlock()) break block0;
                    if (!value.isLong()) break block1;
                    break block2;
                }
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private static int kindTimes4(Value value) {
        block1: {
            block2: {
                block0: {
                    if (value.isBlock()) break block0;
                    if (!value.isLong()) break block1;
                    break block2;
                }
                return 0;
            }
            return 4;
        }
        return 8;
    }

    /*
     * Unable to fully structure code
     */
    public static int compare(Value var0, Value var1_1) {
        block23: {
            block22: {
                block24: {
                    block19: {
                        block21: {
                            block20: {
                                if (!Value.$assertionsDisabled && var0 == null) {
                                    throw new AssertionError((Object)"null v1");
                                }
                                if (!Value.$assertionsDisabled && var1_1 == null) {
                                    throw new AssertionError((Object)"null v2");
                                }
                                switch (Value.kindTimes4(var0) | Value.kind(var1_1)) {
                                    case 0: {
                                        var2_2 = var0.getMagicNumber();
                                        var4_5 = var1_1.getMagicNumber();
                                        if (var2_2 != var4_5) break;
                                        v0 = 0;
                                        break block19;
                                    }
                                    case 3: {
                                        if (!Value.$assertionsDisabled) {
                                            throw new AssertionError((Object)"should not happen");
                                        }
                                        break;
                                    }
                                    case 5: {
                                        var2_3 = var0.asLong();
                                        var4_6 = var1_1.asLong();
                                        if (var2_3 == var4_6) {
                                            v1 = 0;
                                            break;
                                        }
                                        break block20;
                                    }
                                    case 7: {
                                        if (!Value.$assertionsDisabled) {
                                            throw new AssertionError((Object)"should not happen");
                                        }
                                        break;
                                    }
                                    case 10: {
                                        var2_4 = var0.asLong();
                                        var4_7 = var1_1.asLong();
                                        if (var2_4 != var4_7) break block21;
                                        v2 = 0;
                                        break block22;
                                    }
                                    default: {
                                        if (!Value.$assertionsDisabled) {
                                            throw new AssertionError((Object)"should not happen");
                                        }
                                        break block23;
                                    }
                                }
                                v0 = var2_2 < var4_5 ? 1 : -1;
                                break block19;
                            }
                            v1 = var2_3 < var4_6 ? -1 : 1;
                            break block24;
                        }
                        v2 = var2_4 < var4_7 ? -1 : 1;
                        break block22;
                    }
                    return v0;
                    {
                        case 1: {
                            return -1;
                        }
                        case 2: {
                            return -1;
                        }
                    }
                    return -1;
                    {
                        case 4: {
                            return 1;
                        }
                    }
                }
                return v1;
                {
                    case 6: {
                        return -1;
                    }
                }
                return -1;
                {
                    case 8: {
                        return 1;
                    }
                    ** case 9:
                }
lbl62:
                // 1 sources

                return 1;
            }
            return v2;
        }
        return -1;
    }

    public static int compareUnsigned(Value value, Value value2) {
        int n;
        block13: {
            int n2;
            block11: {
                block9: {
                    block8: {
                        int n3;
                        block6: {
                            block3: {
                                block2: {
                                    long l;
                                    long l2;
                                    block12: {
                                        long l3;
                                        long l4;
                                        block10: {
                                            block7: {
                                                long l5;
                                                long l6;
                                                block5: {
                                                    long l7;
                                                    long l8;
                                                    int n4;
                                                    block4: {
                                                        int n5;
                                                        assert (value != null) : "null v1";
                                                        assert (value2 != null) : "null v2";
                                                        n4 = Value.kind(value);
                                                        if (n4 < (n5 = Value.kind(value2))) break block2;
                                                        if (n4 > n5) break block3;
                                                        if (n4 != 0) break block4;
                                                        l6 = value.getMagicNumber();
                                                        if (l6 != (l5 = value2.getMagicNumber())) break block5;
                                                        n3 = 0;
                                                        break block6;
                                                    }
                                                    if (n4 != 1) break block7;
                                                    long l9 = value.asLong();
                                                    long l10 = l9 >> 32 & 0xFFFFFFFFL;
                                                    if (l10 < (l8 = (l7 = value2.asLong()) >> 32 & 0xFFFFFFFFL)) break block8;
                                                    if (l10 > l8) break block9;
                                                    l4 = l9 & 0xFFFFFFFFL;
                                                    l3 = l7 & 0xFFFFFFFFL;
                                                    if (l4 != l3) break block10;
                                                    n2 = 0;
                                                    break block11;
                                                }
                                                n3 = l6 < l5 ? 1 : -1;
                                                break block6;
                                            }
                                            l2 = value.asLong();
                                            if (l2 != (l = value2.asLong())) break block12;
                                            n = 0;
                                            break block13;
                                        }
                                        n2 = l4 < l3 ? -1 : 1;
                                        break block11;
                                    }
                                    n = l2 < l ? -1 : 1;
                                    break block13;
                                }
                                return -1;
                            }
                            return 1;
                        }
                        return n3;
                    }
                    return -1;
                }
                return 1;
            }
            return n2;
        }
        return n;
    }

    public static int compareUsingMagicNumbers(Value value, Value value2) {
        long l;
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        assert (value.isBlock()) : "v1 should be a block";
        assert (value2.isBlock()) : "v2 should be a block";
        long l2 = value.getMagicNumber();
        return l2 == (l = value2.getMagicNumber()) ? 0 : (l2 < l ? 1 : -1);
    }

    static long wosize(long l) {
        assert (l >= 0L) : "bytes should be >= 0";
        long l2 = 8L;
        return 1L + (l + 8L - 1L) / 8L;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        MAX_INTEGER = Integer.MAX_VALUE;
        MIN_INTEGER = Integer.MIN_VALUE;
        INTEGER_CARDINALITY = MAX_INTEGER - MIN_INTEGER + 1L;
        CACHED_VALUES = new LongValue[384];
        RAW_CACHED_VALUES = new LongValue[767];
        int n = -255;
        int n2 = -128;
        while (true) {
            LongValue longValue;
            if (n2 > 255) {
                UNIT = Value.createLong(0L);
                FALSE = Value.createLong(0L);
                TRUE = Value.createLong(1L);
                EMPTY_LIST = Value.createLong(0L);
                ZERO = Value.createLong(0L);
                ONE = Value.createLong(1L);
                TWO = Value.createLong(2L);
                THREE = Value.createLong(3L);
                FOUR = Value.createLong(4L);
                FIVE = Value.createLong(5L);
                SIX = Value.createLong(6L);
                SEVEN = Value.createLong(7L);
                EIGHT = Value.createLong(8L);
                MINUS_ONE = Value.createLong(-1L);
                MINUS_TWO = Value.createLong(-2L);
                return;
            }
            Value.CACHED_VALUES[n2 - -128] = longValue = new LongValue(n2, n);
            Value.RAW_CACHED_VALUES[n - -255] = longValue;
            n += 2;
            ++n2;
        }
    }
}

