/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.support.scripting.OCamlBindings;
import org.ocamljava.runtime.support.scripting.OCamlCompiledScript;
import org.ocamljava.runtime.support.scripting.OCamlContext;
import org.ocamljava.runtime.support.scripting.OCamlScriptEngineFactory;
import org.ocamljava.runtime.util.CustomClassLoader;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.util.RedirectedInputStream;
import org.ocamljava.runtime.util.RedirectedOutputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class OCamlScriptEngine
implements ScriptEngine,
Compilable,
Invocable {
    private static final AtomicInteger ID = new AtomicInteger();
    private static Method COMPILER_MAIN;
    private ScriptContext context = new OCamlContext();
    private final Interpreter interpreter;
    private final List<String> libraryPaths = new LinkedList<String>();
    private final List<String> libraries = new LinkedList<String>();
    private final RedirectedInputStream in = new RedirectedInputStream(System.in);
    private final RedirectedOutputStream out = new RedirectedOutputStream(System.out);
    private final RedirectedOutputStream err = new RedirectedOutputStream(System.err);
    private PrintStream printOut = new PrintStream(this.out);
    private PrintStream printErr = new PrintStream(this.err);

    public OCamlScriptEngine() throws RuntimeException {
        try {
            InputStream inputStream = OCamlScriptEngine.class.getResourceAsStream("/script");
            RandomAccessInputStream randomAccessInputStream = new RandomAccessInputStream(inputStream);
            ByteCodeParameters byteCodeParameters = Parameters.defaultByteCodeParameters();
            byteCodeParameters = Parameters.setFile(byteCodeParameters, "/script");
            byteCodeParameters = Parameters.setBooleanParameter(byteCodeParameters, CommonParameters.BooleanParameterID.STOP_JVM, false);
            byteCodeParameters = Parameters.setInputStreamParameter(byteCodeParameters, CommonParameters.InputStreamParameterID.IN, (InputStream)this.in);
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.OUT, this.printOut);
            byteCodeParameters = Parameters.setPrintStreamParameter(byteCodeParameters, CommonParameters.PrintStreamParameterID.ERR, this.printErr);
            byteCodeParameters = Parameters.setBooleanParameter(byteCodeParameters, CommonParameters.BooleanParameterID.EMBEDDED, true);
            this.interpreter = new Interpreter(byteCodeParameters, new File("."), randomAccessInputStream, new CustomOperations[0]);
            randomAccessInputStream.close();
            this.interpreter.execute();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create script engine", iOException);
        }
        catch (Fatal.Exception exception) {
            throw new RuntimeException("Unable to create script engine", exception);
        }
        catch (OCamlJavaException oCamlJavaException) {
            throw new RuntimeException("Unable to create script engine", oCamlJavaException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLibraryPath(String string) throws NullPointerException, ScriptException {
        if (string == null) throw new NullPointerException();
        if (!this.libraryPaths.contains(string)) {
            this.libraryPaths.add(string);
        }
        try {
            this.interpreter.execute("ocamljava javax.script.directory", Value.createString(string));
            return;
        }
        catch (OCamlJavaException oCamlJavaException) {
            throw new ScriptException(oCamlJavaException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadLibrary(String string) throws NullPointerException, ScriptException {
        if (string == null) throw new NullPointerException();
        if (!this.libraries.contains(string)) {
            this.libraries.add(string);
        }
        try {
            this.interpreter.execute("ocamljava javax.script.load", Value.createString(string + ".cma"));
            return;
        }
        catch (OCamlJavaException oCamlJavaException) {
            throw new ScriptException(oCamlJavaException);
        }
    }

    @Override
    public Bindings createBindings() {
        return new OCamlBindings();
    }

    @Override
    public Object eval(Reader reader) throws NullPointerException, ScriptException {
        Object object;
        try {
            object = this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(this.context));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        return object;
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws NullPointerException, ScriptException {
        Object object;
        try {
            object = this.evaluate(OCamlScriptEngine.readerToString(reader), new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(bindings)));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        return object;
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws NullPointerException, ScriptException {
        Object object;
        try {
            object = this.evaluate(OCamlScriptEngine.readerToString(reader), OCamlContext.instance(scriptContext));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        return object;
    }

    @Override
    public Object eval(String string) throws NullPointerException, ScriptException {
        return this.evaluate(string, OCamlContext.instance(this.context));
    }

    @Override
    public Object eval(String string, Bindings bindings) throws NullPointerException, ScriptException {
        return this.evaluate(string, new OCamlContext(OCamlContext.instance(this.context), OCamlBindings.instance(bindings)));
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws NullPointerException, ScriptException {
        return this.evaluate(string, OCamlContext.instance(scriptContext));
    }

    @Override
    public Object get(String string) throws NullPointerException, IllegalArgumentException {
        return this.getBindings(100).get(string);
    }

    @Override
    public Bindings getBindings(int n) throws IllegalArgumentException {
        return this.context.getBindings(n);
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new OCamlScriptEngineFactory();
    }

    @Override
    public void put(String string, Object object) throws NullPointerException, IllegalArgumentException {
        this.getBindings(100).put(string, object);
    }

    @Override
    public void setBindings(Bindings bindings, int n) throws NullPointerException, IllegalArgumentException {
        this.context.setBindings(bindings, n);
    }

    @Override
    public void setContext(ScriptContext scriptContext) throws NullPointerException {
        this.context = scriptContext;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompiledScript compile(String string) throws NullPointerException, ScriptException {
        LinkedList<String> linkedList;
        File file;
        File file2;
        String string2;
        if (string == null) {
            throw new NullPointerException("null script");
        }
        if (COMPILER_MAIN == null) {
            throw new ScriptException("OCaml-Java compiler is not available");
        }
        try {
            int n = ID.getAndIncrement();
            string2 = "org.ocamljava.runtime.support.scripting.generated" + n;
            file2 = File.createTempFile("ocamlscript", ".ml");
            file = File.createTempFile("ocamlscript", ".jar");
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string);
            ((Writer)fileWriter).close();
            linkedList = new LinkedList<String>();
            for (Object object : this.libraryPaths) {
                linkedList.add("-I");
                linkedList.add((String)object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ScriptException("Unable to compile script");
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        {
            String[] stringArray = this.libraries.iterator();
            while (true) {
                Object object;
                if (!stringArray.hasNext()) {
                    linkedList.add("-w");
                    linkedList.add("-a");
                    linkedList.add("-scripting");
                    linkedList.add("-runtime-parameter");
                    linkedList.add("stop-jvm=off");
                    linkedList.add("-java-package");
                    linkedList.add(string2);
                    linkedList.add("-o");
                    linkedList.add(file.getAbsolutePath());
                    linkedList.add(file2.getAbsolutePath());
                    stringArray = linkedList.toArray(new String[linkedList.size()]);
                    COMPILER_MAIN.invoke(null, new Object[]{stringArray});
                    object = new URLClassLoader(new URL[]{new URL("file://" + file.getAbsolutePath())}, (ClassLoader)CustomClassLoader.INSTANCE);
                    Class<?> clazz = Class.forName(string2 + ".ocamljavaMain", true, (ClassLoader)object);
                    Method method = clazz.getMethod("mainScripting", String[].class, Map.class, InputStream.class, PrintStream.class, PrintStream.class);
                    return new OCamlCompiledScript(this, method, this.context);
                }
                object = stringArray.next();
                linkedList.add((String)object + ".cmja");
            }
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws NullPointerException, ScriptException {
        CompiledScript compiledScript;
        if (reader == null) {
            throw new NullPointerException("null script");
        }
        try {
            compiledScript = this.compile(OCamlScriptEngine.readerToString(reader));
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        return compiledScript;
    }

    @Override
    public Object invokeMethod(Object object, String string, Object ... objectArray) throws ScriptException, NoSuchMethodException, NullPointerException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException, NullPointerException {
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        OCamlContext oCamlContext = OCamlContext.instance(this.context);
        this.in.redirect(oCamlContext.getStdIn());
        this.out.redirect(oCamlContext.getStdOut());
        this.err.redirect(oCamlContext.getStdErr());
        try {}
        catch (OCamlJavaException oCamlJavaException) {
            throw new ScriptException(oCamlJavaException);
        }
        int n = objectArray.length;
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = OCamlBindings.convert(objectArray[i]);
        }
        return this.interpreter.execute(string, valueArray);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getInterface(Object object, Class<T> clazz) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object evaluate(String string, OCamlContext oCamlContext) throws ScriptException {
        assert (string != null) : "null script";
        assert (oCamlContext != null) : "null context";
        try {
            this.out.flush();
            this.err.flush();
            this.in.redirect(oCamlContext.getStdIn());
            this.out.redirect(oCamlContext.getStdOut());
            this.err.redirect(oCamlContext.getStdErr());
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
        try {}
        catch (OCamlJavaException oCamlJavaException) {
            Throwable throwable = oCamlJavaException.getCause();
            if (!(throwable instanceof Fail.Exception)) {
                if (!(throwable instanceof Fatal.Exception)) throw new ScriptException(oCamlJavaException);
                throw new ScriptException(throwable.getMessage());
            }
            Fail.Exception exception = (Fail.Exception)throwable;
            Value value = exception.asValue(this.interpreter.getContext().getCodeState().getGlobalData());
            Value value2 = value.isBlock() && value.asBlock().sizeValues() >= 2L ? value.asBlock().get1() : null;
            if (value2 == null) throw new ScriptException(oCamlJavaException);
            if (!value2.isBlock()) throw new ScriptException(oCamlJavaException);
            if (value2.getTag() != 252) throw new ScriptException(oCamlJavaException);
            throw new ScriptException(value2.asString());
        }
        String string2 = string + "\n";
        return this.interpreter.executeWithBindings("ocamljava javax.script.eval", oCamlContext.getBindings(), Value.createString(string2));
    }

    private static String readerToString(Reader reader) throws IOException {
        assert (reader != null) : "null reader";
        int n = 1024;
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        int n2 = reader.read(cArray);
        while (n2 != -1) {
            stringWriter.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
        return stringWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Class<?> clazz = Class.forName("ocaml.compilers.ocamljavaMain");
            COMPILER_MAIN = clazz.getMethod("mainWithReturn", String[].class);
            return;
        }
        catch (Throwable throwable) {
            COMPILER_MAIN = null;
            return;
        }
    }
}

