/*
 * Decompiled with CFR 0.152.
 */
package ocaml.otherlibs.zip;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import ocaml.otherlibs.unix.Unix;
import ocaml.otherlibs.zip.Zlib;
import ocaml.stdlib.Hashtbl;
import ocaml.stdlib.List;
import ocaml.stdlib.Pervasives;
import ocaml.stdlib.String;
import org.ocamljava.runtime.annotations.markers.CompiledModule;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.NativeArithmetic;
import org.ocamljava.runtime.kernel.NativeComparisons;
import org.ocamljava.runtime.kernel.NativeUtils;
import org.ocamljava.runtime.kernel.OCamlJavaModule;
import org.ocamljava.runtime.primitives.otherlibs.unix.Gmtime;
import org.ocamljava.runtime.primitives.otherlibs.unix.Stat;
import org.ocamljava.runtime.primitives.otherlibs.unix.Time;
import org.ocamljava.runtime.primitives.otherlibs.unix.Utimes;
import org.ocamljava.runtime.primitives.stdlib.Io;
import org.ocamljava.runtime.primitives.stdlib.Obj;
import org.ocamljava.runtime.primitives.stdlib.Str;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@CompiledModule
public final class Zip
implements OCamlJavaModule {
    public static Value GLOBALS;
    private static Value CONSTANTS;
    public static final MethodHandle search_1112;
    public static final MethodHandle find_ecd_1128;
    public static final MethodHandle fun_1469;
    public static final MethodHandle fun_1483;
    public static final MethodHandle fun_1480;
    public static final MethodHandle fun_1490;
    public static final MethodHandle fun_1487;
    public static final MethodHandle copy_1220;
    public static final MethodHandle fun_1509;
    public static final MethodHandle fun_1521;
    public static final MethodHandle fun_1518;
    public static final MethodHandle fun_1528;
    public static final MethodHandle fun_1525;
    public static final MethodHandle copy_1318;
    public static final MethodHandle fun_1547;
    public static final MethodHandle fun_1544;
    public static final MethodHandle fun_1541;
    public static final MethodHandle fun_1553;
    public static final MethodHandle fun_1550;
    public static final MethodHandle finish_1368;
    public static final MethodHandle check_1367;
    public static final MethodHandle read2_1010;
    public static final MethodHandle read4_1014;
    public static final MethodHandle read4_int_1018;
    public static final MethodHandle readstring_1022;
    public static final MethodHandle write2_1027;
    public static final MethodHandle write4_1030;
    public static final MethodHandle write4_int_1033;
    public static final MethodHandle writestring_1036;
    public static final MethodHandle entries_1097;
    public static final MethodHandle comment_1099;
    public static final MethodHandle strrstr_1107;
    public static final MethodHandle filename_is_directory_1115;
    public static final MethodHandle unixtime_of_dostime_1117;
    public static final MethodHandle dostime_of_unixtime_1120;
    public static final MethodHandle read_ecd_1123;
    public static final MethodHandle read_cd_1145;
    public static final MethodHandle open_in_1174;
    public static final MethodHandle close_in_1184;
    public static final MethodHandle find_entry_1186;
    public static final MethodHandle goto_entry_1189;
    public static final MethodHandle read_entry_1204;
    public static final MethodHandle copy_entry_to_channel_1215;
    public static final MethodHandle copy_entry_to_file_1229;
    public static final MethodHandle open_out_1235;
    public static final MethodHandle write_directory_entry_1240;
    public static final MethodHandle close_out_1246;
    public static final MethodHandle add_entry_header_1252;
    public static final MethodHandle add_data_descriptor_1264;
    public static final MethodHandle add_entry_1271;
    public static final MethodHandle copy_channel_to_entry_1297;
    public static final MethodHandle copy_file_to_entry_1329;
    public static final MethodHandle add_entry_generator_1347;
    public static final Value LONG_4096;
    public static final Value LONG_256;
    public static final Value LONG_210;
    public static final Value LONG_153;
    public static final Value LONG_128;

    static {
        LONG_4096 = Value.createLong(4096);
        LONG_256 = Value.createLong(256);
        LONG_210 = Value.createLong(210);
        LONG_153 = Value.createLong(153);
        LONG_128 = Value.createLong(128);
        CONSTANTS = Zip.createConstants();
        GLOBALS = null;
        search_1112 = cfr_ldc_0();
        find_ecd_1128 = cfr_ldc_1();
        fun_1469 = cfr_ldc_2();
        fun_1483 = cfr_ldc_3();
        fun_1480 = cfr_ldc_4();
        fun_1490 = cfr_ldc_5();
        fun_1487 = cfr_ldc_6();
        copy_1220 = cfr_ldc_7();
        fun_1509 = cfr_ldc_8();
        fun_1521 = cfr_ldc_9();
        fun_1518 = cfr_ldc_10();
        fun_1528 = cfr_ldc_11();
        fun_1525 = cfr_ldc_12();
        copy_1318 = cfr_ldc_13();
        fun_1547 = cfr_ldc_14();
        fun_1544 = cfr_ldc_15();
        fun_1541 = cfr_ldc_16();
        fun_1553 = cfr_ldc_17();
        fun_1550 = cfr_ldc_18();
        finish_1368 = cfr_ldc_19();
        check_1367 = cfr_ldc_20();
        read2_1010 = cfr_ldc_21();
        read4_1014 = cfr_ldc_22();
        read4_int_1018 = cfr_ldc_23();
        readstring_1022 = cfr_ldc_24();
        write2_1027 = cfr_ldc_25();
        write4_1030 = cfr_ldc_26();
        write4_int_1033 = cfr_ldc_27();
        writestring_1036 = cfr_ldc_28();
        entries_1097 = cfr_ldc_29();
        comment_1099 = cfr_ldc_30();
        strrstr_1107 = cfr_ldc_31();
        filename_is_directory_1115 = cfr_ldc_32();
        unixtime_of_dostime_1117 = cfr_ldc_33();
        dostime_of_unixtime_1120 = cfr_ldc_34();
        read_ecd_1123 = cfr_ldc_35();
        read_cd_1145 = cfr_ldc_36();
        open_in_1174 = cfr_ldc_37();
        close_in_1184 = cfr_ldc_38();
        find_entry_1186 = cfr_ldc_39();
        goto_entry_1189 = cfr_ldc_40();
        read_entry_1204 = cfr_ldc_41();
        copy_entry_to_channel_1215 = cfr_ldc_42();
        copy_entry_to_file_1229 = cfr_ldc_43();
        open_out_1235 = cfr_ldc_44();
        write_directory_entry_1240 = cfr_ldc_45();
        close_out_1246 = cfr_ldc_46();
        add_entry_header_1252 = cfr_ldc_47();
        add_data_descriptor_1264 = cfr_ldc_48();
        add_entry_1271 = cfr_ldc_49();
        copy_channel_to_entry_1297 = cfr_ldc_50();
        copy_file_to_entry_1329 = cfr_ldc_51();
        add_entry_generator_1347 = cfr_ldc_52();
    }

    public static Value createConstants() {
        Value value = Value.createBlock(0, 56L);
        value.set(0, Value.createString(""));
        value.set(1, Value.createString("end of central directory not found, not a ZIP file"));
        value.set(2, Value.createString("PK\u0005\u0006"));
        value.set(3, Value.createString("wrong size for deflated entry (too much data)"));
        value.set(4, Value.createString("compression error"));
        value.set(5, Value.createString("compression error"));
        value.set(6, Value.createString("entry already finished"));
        value.set(7, Value.createString(""));
        value.set(8, Value.createString(""));
        value.set(9, Value.createString("32-bit data too large"));
        value.set(10, Value.createBlock(0, Value.createString("zip.ml"), LONG_153, Value.TWO));
        value.set(11, Value.createString(""));
        value.set(12, Value.createString("multi-disk ZIP files not supported"));
        value.set(13, Value.createString("wrong file header in central directory"));
        value.set(14, Value.createString("encrypted entries not supported"));
        value.set(15, Value.createString("unknown compression method"));
        value.set(16, Value.createBlock(0, Value.createString("zip.ml"), LONG_210, Value.FOUR));
        value.set(17, Value.createString(""));
        value.set(18, Value.createString("end-of-file while reading central directory"));
        value.set(19, Value.createString("wrong local file header"));
        value.set(20, Value.createString("truncated local file header"));
        value.set(21, Value.createBlock(0, Value.ZERO));
        value.set(22, Value.createString("decompression error"));
        value.set(23, Value.createString("wrong size for deflated entry (not enough data)"));
        value.set(24, Value.createString("CRC mismatch"));
        value.set(25, Value.createString("wrong size for stored entry"));
        value.set(26, Value.createString("truncated data"));
        value.set(27, Value.createBlock(0, Value.ZERO));
        value.set(28, Value.createString("decompression error"));
        value.set(29, Value.createString("CRC mismatch"));
        value.set(30, Value.createString("wrong size for stored entry"));
        value.set(31, Value.createString("truncated data"));
        value.set(32, Value.createString(""));
        value.set(33, Value.createString(""));
        value.set(34, Value.createString("comment too long"));
        value.set(35, Value.createString(""));
        value.set(36, Value.createString("too many entries"));
        value.set(37, Value.createString("wrong compression level"));
        value.set(38, Value.createString("filename too long"));
        value.set(39, Value.createString("extra data too long"));
        value.set(40, Value.createString("comment too long"));
        value.set(41, Value.createString(""));
        value.set(42, Value.createString(""));
        value.set(43, Value.createBlock(0, Value.ZERO));
        value.set(44, Value.createString("compression error"));
        value.set(45, Value.createString(""));
        value.set(46, Value.createString(""));
        value.set(47, Value.createBlock(0, Value.ZERO));
        value.set(48, Value.createString("compression error"));
        value.set(49, Value.createString(""));
        value.set(50, Value.createString(""));
        value.set(51, Value.createString(""));
        value.set(52, Value.createString(""));
        value.set(53, Value.createBlock(0, Value.ZERO));
        value.set(54, Value.createString("Zip.Error"));
        value.set(55, Value.createString("Zip.Error"));
        return value;
    }

    public static Value getGlobal() {
        return GLOBALS;
    }

    public static Value search_1112(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Value value4;
        while (true) {
            if (NativeComparisons.lowerThanValue(value, value3.get5())) {
                value4 = Value.MINUS_ONE;
                break;
            }
            if (value2.asLong() < value3.get3().sizeBytes()) {
                if (NativeUtils.caml_string_get(value3.get3(), value2.asLong()) != NativeUtils.caml_string_get(value3.get4(), NativeArithmetic.addint(value.getRawValue(), value2.getRawValue()) >> 1)) {
                    value2 = Value.ZERO;
                    value = Value.createFromRawLong(NativeArithmetic.decrint(value.getRawValue()));
                    continue;
                }
            } else {
                value4 = value;
                break;
            }
            value2 = Value.createFromRawLong(NativeArithmetic.incrint(value2.getRawValue()));
        }
        return value4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value find_ecd_1128(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Value value4 = CONSTANTS;
        Value value5 = GLOBALS;
        while (true) {
            if (value.getRawValue() <= 1L || NativeArithmetic.subint(value3.get6().getRawValue(), value.getRawValue()) >= 131073L) {
                Fail.raise(Value.createBlock(0, value5.get(14), value3.get3(), value4.get0(), value4.get1()));
            }
            Value value6 = Pervasives.min_1015(value, LONG_128);
            String.blit_1034(value3.get5(), Value.ZERO, value3.get5(), value6, Value.createFromRawLong(NativeArithmetic.subint(513, value6.getRawValue())));
            long l = NativeArithmetic.subint(value.getRawValue(), value6.getRawValue());
            Value value7 = value3.get4();
            Io.caml_ml_seek_in(value7, Value.createFromRawLong(l));
            Pervasives.really_input_1216(value3.get4(), value3.get5(), Value.ZERO, value6);
            value7 = Pervasives.min_1015(Value.createFromRawLong(NativeArithmetic.addint(value6.getRawValue(), value2.getRawValue())), LONG_256);
            Value value8 = Zip.strrstr_1107(value4.get2(), value3.get5(), Value.ZERO, value7);
            if (value8.getRawValue() >= 1L && value7.getRawValue() >= (long)45) {
                long l2 = Value.createLong(NativeUtils.caml_string_get(value3.get5(), NativeArithmetic.addint(value8.getRawValue(), 41) >> 1)).getRawValue() | NativeArithmetic.lslint(Value.createLong(NativeUtils.caml_string_get(value3.get5(), NativeArithmetic.addint(value8.getRawValue(), 43) >> 1)).getRawValue(), 8);
                if (NativeArithmetic.addint(NativeArithmetic.addint(NativeArithmetic.addint(l, value8.getRawValue()), 45), l2) == value3.get6().getRawValue()) {
                    return Value.createFromRawLong(NativeArithmetic.addint(l, value8.getRawValue()));
                }
            }
            value2 = value7;
            value = Value.createFromRawLong(l);
        }
    }

    public static Value fun_1469(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        return Hashtbl.add_1069(value2.get2(), value.get0(), value);
    }

    public static Value fun_1483(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Value value4 = CONSTANTS;
        Value value5 = GLOBALS;
        if (NativeArithmetic.addint(value3.get6().get0().getRawValue(), value2.getRawValue()) >> 1 > value3.get5().sizeBytes()) {
            Fail.raise(Value.createBlock(0, value5.get(14), value3.get3().get0(), value3.get4().get0(), value4.get3()));
        }
        String.blit_1034(value, Value.ZERO, value3.get5(), value3.get6().get0(), value2);
        Value value6 = value3.get6();
        value6.set0(Value.createFromRawLong(NativeArithmetic.addint(value6.get0().getRawValue(), value2.getRawValue())));
        return Value.UNIT;
    }

    public static Value fun_1480(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Pervasives.input_1205(value2.get2().get1(), value, Value.ZERO, Pervasives.min_1015(value2.get3().get0(), value.sizeBytesWrapped()));
        Value value4 = value2.get3();
        value4.set0(Value.createFromRawLong(NativeArithmetic.subint(value4.get0().getRawValue(), value3.getRawValue())));
        return value3;
    }

    public static Value fun_1490(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Pervasives.output_1175(value3.get3(), value, Value.ZERO, value2);
        Value value4 = value3.get4();
        value4.set0(org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(value4.get0(), value, Value.ZERO, value2));
        return Value.UNIT;
    }

    public static Value fun_1487(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Pervasives.input_1205(value2.get2().get1(), value, Value.ZERO, Pervasives.min_1015(value2.get3().get0(), value.sizeBytesWrapped()));
        Value value4 = value2.get3();
        value4.set0(Value.createFromRawLong(NativeArithmetic.subint(value4.get0().getRawValue(), value3.getRawValue())));
        return value3;
    }

    public static Value copy_1220(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        while (value.getRawValue() > 1L) {
            Value value3 = Pervasives.input_1205(value2.get2().get1(), value2.get4(), Value.ZERO, Pervasives.min_1015(value, value2.get4().sizeBytesWrapped()));
            Pervasives.output_1175(value2.get3(), value2.get4(), Value.ZERO, value3);
            value = Value.createFromRawLong(NativeArithmetic.subint(value.getRawValue(), value3.getRawValue()));
        }
        return Value.ZERO;
    }

    public static Value fun_1509(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        return Zip.write_directory_entry_1240(value2.get2(), value);
    }

    public static Value fun_1521(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Pervasives.output_1175(value3.get3().get1(), value, Value.ZERO, value2);
        Value value4 = value3.get4();
        value4.set0(Value.createFromRawLong(NativeArithmetic.addint(value4.get0().getRawValue(), value2.getRawValue())));
        return Value.UNIT;
    }

    public static Value fun_1518(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Pervasives.min_1015(Value.createFromRawLong(NativeArithmetic.subint(value2.get2().sizeBytesTagged(), value2.get3().get0().getRawValue())), value.sizeBytesWrapped());
        String.blit_1034(value2.get2(), value2.get3().get0(), value, Value.ZERO, value3);
        Value value4 = value2.get3();
        value4.set0(Value.createFromRawLong(NativeArithmetic.addint(value4.get0().getRawValue(), value3.getRawValue())));
        return value3;
    }

    public static Value fun_1528(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Pervasives.output_1175(value3.get3().get1(), value, Value.ZERO, value2);
        Value value4 = value3.get4();
        value4.set0(Value.createFromRawLong(NativeArithmetic.addint(value4.get0().getRawValue(), value2.getRawValue())));
        return Value.UNIT;
    }

    public static Value fun_1525(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Pervasives.input_1205(value2.get2(), value, Value.ZERO, value.sizeBytesWrapped());
        Value value4 = value2.get3();
        value4.set0(org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(value4.get0(), value, Value.ZERO, value3));
        Value value5 = value2.get4();
        value5.set0(Value.createFromRawLong(NativeArithmetic.addint(value5.get0().getRawValue(), value3.getRawValue())));
        return value3;
    }

    public static Value copy_1318(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3;
        while ((value3 = Pervasives.input_1205(value2.get2(), value2.get5(), Value.ZERO, value2.get5().sizeBytesWrapped())).getRawValue() != 1L) {
            Value value4 = value2.get4();
            value4.set0(org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(value4.get0(), value2.get5(), Value.ZERO, value3));
            Pervasives.output_1175(value2.get3().get1(), value2.get5(), Value.ZERO, value3);
            value = Value.createFromRawLong(NativeArithmetic.addint(value.getRawValue(), value3.getRawValue()));
        }
        return value;
    }

    public static Value fun_1547(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3;
        Value value4 = CONSTANTS;
        Value value5 = GLOBALS;
        Value value6 = Zlib.GLOBALS;
        Zip.check_1367(Value.ZERO, value2.get4());
        try {
            Zlib.compr_finish_1055(Value.ZERO, value2.get6());
            value3 = Zip.finish_1368(Value.ZERO, value2.get5());
        }
        catch (Throwable throwable) {
            Value value7 = Fail.asValue(throwable);
            if (NativeComparisons.equalValues(value7.get0(), value6.get0())) {
                Fail.raise(Value.createBlock(0, value5.get(14), value2.get2().get0(), value2.get3(), value4.get4()));
                value3 = Value.UNIT;
            }
            Fail.raise(value7);
            value3 = Value.UNIT;
        }
        return value3;
    }

    public static Value fun_1544(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, Fatal.Exception {
        Value value5;
        Value value6 = CONSTANTS;
        Value value7 = GLOBALS;
        Value value8 = Zlib.GLOBALS;
        Zip.check_1367(Value.ZERO, value4.get7());
        try {
            Zlib.compr_1054(value, value2, value3, value4.get(8));
            Value value9 = value4.get6();
            value9.set0(Value.createFromRawLong(NativeArithmetic.addint(value9.get0().getRawValue(), value3.getRawValue())));
            Value value10 = value4.get5();
            value10.set0(org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(value10.get0(), value, value2, value3));
            value5 = Value.UNIT;
        }
        catch (Throwable throwable) {
            Value value11 = Fail.asValue(throwable);
            if (NativeComparisons.equalValues(value11.get0(), value8.get0())) {
                Fail.raise(Value.createBlock(0, value7.get(14), value4.get3().get0(), value4.get4(), value6.get5()));
                value5 = Value.UNIT;
            }
            Fail.raise(value11);
            value5 = Value.UNIT;
        }
        return value5;
    }

    public static Value fun_1541(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Pervasives.output_1175(value3.get3().get1(), value, Value.ZERO, value2);
        Value value4 = value3.get4();
        value4.set0(Value.createFromRawLong(NativeArithmetic.addint(value4.get0().getRawValue(), value2.getRawValue())));
        return Value.UNIT;
    }

    public static Value fun_1553(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Zip.check_1367(Value.ZERO, value2.get2());
        return Zip.finish_1368(Value.ZERO, value2.get3());
    }

    public static Value fun_1550(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, Fatal.Exception {
        Zip.check_1367(Value.ZERO, value4.get6());
        Pervasives.output_1175(value4.get3().get1(), value, value2, value3);
        Value value5 = value4.get4();
        value5.set0(Value.createFromRawLong(NativeArithmetic.addint(value5.get0().getRawValue(), value3.getRawValue())));
        Value value6 = value4.get5();
        value6.set0(Value.createFromRawLong(NativeArithmetic.addint(value6.get0().getRawValue(), value3.getRawValue())));
        return Value.UNIT;
    }

    public static Value finish_1368(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        value2.get7().set0(Value.ONE);
        Value value3 = Zip.add_data_descriptor_1264(value2.get2(), value2.get4().get0(), value2.get5().get0(), value2.get6().get0(), value2.get3());
        value2.get2().set2(Value.createBlock(0, value3, value2.get2().get2()));
        return Value.UNIT;
    }

    public static Value check_1367(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3;
        Value value4 = CONSTANTS;
        Value value5 = GLOBALS;
        if ((int)value2.get4().get0().asLong() != 0) {
            Fail.raise(Value.createBlock(0, value5.get(14), value2.get2().get0(), value2.get3(), value4.get6()));
            value3 = Value.UNIT;
        } else {
            value3 = Value.ZERO;
        }
        return value3;
    }

    public static Value read2_1010(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = Io.caml_ml_input_char(value);
        Value value3 = Io.caml_ml_input_char(value);
        return Value.createFromRawLong(value2.getRawValue() | NativeArithmetic.lslint(value3.getRawValue(), 8));
    }

    public static Value read4_1014(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = Zip.read2_1010(value);
        Value value3 = Zip.read2_1010(value);
        return Value.createInt32((int)(value2.getRawValue() >> 1) | (int)(value3.getRawValue() >> 1) << 16);
    }

    public static Value read4_int_1018(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = CONSTANTS;
        Value value3 = GLOBALS;
        Value value4 = Zip.read2_1010(value);
        Value value5 = Zip.read2_1010(value);
        if (value5.getRawValue() > 0x7FFFFFFFFFFFL) {
            Fail.raise(Value.createBlock(0, value3.get(15), value2.get7(), value2.get(8), value2.get(9)));
        }
        return Value.createFromRawLong(value4.getRawValue() | NativeArithmetic.lslint(value5.getRawValue(), 16));
    }

    public static Value readstring_1022(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Str.caml_create_string(value2);
        Pervasives.really_input_1216(value, value3, Value.ZERO, value2);
        return value3;
    }

    public static Value write2_1027(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Io.caml_ml_output_char(value, value2);
        long l = NativeArithmetic.lsrint(value2.getRawValue(), 8);
        return Io.caml_ml_output_char(value, Value.createFromRawLong(l));
    }

    public static Value write4_1030(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Zip.write2_1027(value, Value.createFromRawLong((long)value2.asInt32() << 1 | 1L));
        return Zip.write2_1027(value, Value.createFromRawLong((long)(value2.asInt32() >>> 16) << 1 | 1L));
    }

    public static Value write4_int_1033(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Zip.write2_1027(value, value2);
        return Zip.write2_1027(value, Value.createFromRawLong(NativeArithmetic.lsrint(value2.getRawValue(), 16)));
    }

    public static Value writestring_1036(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        return Pervasives.output_1175(value, value2, Value.ZERO, value2.sizeBytesWrapped());
    }

    public static Value entries_1097(Value value) throws Fail.Exception, Fatal.Exception {
        return value.get2();
    }

    public static Value comment_1099(Value value) throws Fail.Exception, Fatal.Exception {
        return value.get4();
    }

    public static Value strrstr_1107(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, Fatal.Exception {
        Value value5 = Value.createClosure(6).setClosure(search_1112, 2);
        value5.set3(value);
        value5.set4(value2);
        value5.set5(value3);
        Value value6 = value5;
        return Zip.search_1112(Value.createFromRawLong(NativeArithmetic.subint(NativeArithmetic.addint(value3.getRawValue(), value4.getRawValue()), value.sizeBytesTagged())), Value.ZERO, value6);
    }

    public static Value filename_is_directory_1115(Value value) throws Fail.Exception, Fatal.Exception {
        long l;
        if (value.sizeBytes() <= 0L) {
            l = 0L;
        } else {
            Value value2 = value;
            l = NativeUtils.caml_string_get(value2, value2.sizeBytesMinusOneTagged() >> 1) != (long)47 ? 0L : 1L;
        }
        return Value.createLong(l);
    }

    public static Value unixtime_of_dostime_1117(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = Value.createBlock(0, 9);
        value3.set(0L, Value.createFromRawLong(NativeArithmetic.lslint(value.getRawValue(), 1L) & (long)125));
        value3.set(1L, Value.createFromRawLong(NativeArithmetic.lsrint(value.getRawValue(), 5) & (long)127));
        value3.set((long)2, Value.createFromRawLong(NativeArithmetic.lsrint(value.getRawValue(), 11) & (long)63));
        value3.set((long)3, Value.createFromRawLong(value2.getRawValue() & (long)63));
        value3.set((long)4, Value.createFromRawLong(NativeArithmetic.decrint(NativeArithmetic.lsrint(value2.getRawValue(), 5) & (long)31)));
        value3.set((long)5, Value.createFromRawLong(NativeArithmetic.addint(NativeArithmetic.lsrint(value2.getRawValue(), 9) & (long)255, 161)));
        value3.set((long)6, Value.ZERO);
        value3.set((long)7, Value.ZERO);
        value3.set((long)8, Value.ZERO);
        Value value4 = value3;
        return Gmtime.unix_mktime(value3).get0();
    }

    public static Value dostime_of_unixtime_1120(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = Gmtime.unix_localtime(value);
        return Value.createBlock(0, Value.createFromRawLong(NativeArithmetic.addint(NativeArithmetic.addint(NativeArithmetic.lsrint(value2.get0().getRawValue(), 1L), NativeArithmetic.lslint(value2.get1().getRawValue(), 5)), NativeArithmetic.lslint(value2.get2().getRawValue(), 11))), Value.createFromRawLong(NativeArithmetic.addint(NativeArithmetic.addint(value2.get3().getRawValue(), NativeArithmetic.lslint(NativeArithmetic.incrint(value2.get4().getRawValue()), 5)), NativeArithmetic.lslint(NativeArithmetic.subint(value2.get5().getRawValue(), 161), 9))));
    }

    public static Value read_ecd_1123(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = CONSTANTS;
        Value value4 = GLOBALS;
        Value value5 = Str.caml_create_string(LONG_256);
        Value value6 = Io.caml_ml_channel_size(value2);
        Value value7 = Value.createClosure(7).setClosure(find_ecd_1128, 2);
        value7.set3(value);
        value7.set4(value2);
        value7.set5(value5);
        value7.set6(value6);
        Value value8 = value7;
        Value value9 = Zip.find_ecd_1128(value6, Value.ZERO, value8);
        Io.caml_ml_seek_in(value2, value9);
        value9 = Zip.read4_1014(value2);
        Value value10 = Zip.read2_1010(value2);
        Value value11 = Zip.read2_1010(value2);
        Value value12 = Zip.read2_1010(value2);
        Value value13 = Zip.read2_1010(value2);
        Value value14 = Zip.read4_1014(value2);
        Value value15 = Zip.read4_1014(value2);
        Value value16 = Zip.read2_1010(value2);
        Value value17 = Zip.readstring_1022(value2, value16);
        if (value9.asInt32() != 101010256) {
            Fail.raise(Value.createBlock(0, AbstractNativeRunner.getGlobal("caml_exn_Assert_failure"), value3.get(10)));
        }
        if (value10.getRawValue() != 1L || value11.getRawValue() != 1L) {
            Fail.raise(Value.createBlock(0, value4.get(14), value, value3.get(11), value3.get(12)));
        }
        return Value.createBlock(0, value13, value14, value15, value17);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value read_cd_1145(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, Fatal.Exception {
        Value value6;
        Value value7;
        block9: {
            Value value8 = CONSTANTS;
            Value value9 = GLOBALS;
            long l = value5.asInt32();
            try {
                long l2 = value4.asInt32();
                Io.caml_ml_seek_in_64(value2, Value.createInt64(l2));
                value7 = Value.ZERO;
                long l3 = 1L;
                while (true) {
                    Value value10;
                    Value value11;
                    Value value12;
                    Value value13;
                    long l4;
                    Value value14;
                    Value value15;
                    Value value16;
                    Value value17;
                    Value value18;
                    Value value19;
                    Value value20;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        if (Io.caml_ml_pos_in_64(value2).asInt64() < l) break block10;
                                        if (l != Io.caml_ml_pos_in_64(value2).asInt64() || value3.getRawValue() != 131071L && l3 != value3.getRawValue()) break block11;
                                        break block12;
                                    }
                                    l3 = NativeArithmetic.incrint(l3);
                                    Value value21 = Zip.read4_1014(value2);
                                    Value value22 = Zip.read2_1010(value2);
                                    Value value23 = Zip.read2_1010(value2);
                                    value20 = Zip.read2_1010(value2);
                                    value19 = Zip.read2_1010(value2);
                                    value18 = Zip.read2_1010(value2);
                                    value17 = Zip.read2_1010(value2);
                                    value16 = Zip.read4_1014(value2);
                                    value15 = Zip.read4_int_1018(value2);
                                    value14 = Zip.read4_int_1018(value2);
                                    Value value24 = Zip.read2_1010(value2);
                                    Value value25 = Zip.read2_1010(value2);
                                    Value value26 = Zip.read2_1010(value2);
                                    Value value27 = Zip.read2_1010(value2);
                                    Value value28 = Zip.read2_1010(value2);
                                    Value value29 = Zip.read4_1014(value2);
                                    l4 = Zip.read4_1014(value2).asInt32();
                                    value13 = Zip.readstring_1022(value2, value24);
                                    value12 = Zip.readstring_1022(value2, value25);
                                    value11 = Zip.readstring_1022(value2, value26);
                                    if (value21.asInt32() != 33639248) break block13;
                                    break block14;
                                }
                                Fail.raise(Value.createBlock(0, AbstractNativeRunner.getGlobal("caml_exn_Assert_failure"), value8.get(16)));
                            }
                            value6 = List.rev_append_1029(value7, Value.ZERO);
                            return value6;
                        }
                        Fail.raise(Value.createBlock(0, value9.get(14), value, value13, value8.get(13)));
                    }
                    if ((value20.getRawValue() & (long)3) != 1L) {
                        Fail.raise(Value.createBlock(0, value9.get(14), value, value13, value8.get(14)));
                    }
                    Value value30 = Value.createBlock(0, 10);
                    value30.set(0L, value13);
                    value30.set(1L, value12);
                    value30.set((long)2, value11);
                    long l5 = 3;
                    if (value19.getRawValue() == 1L) {
                        value10 = Value.ZERO;
                    } else if (value19.getRawValue() == (long)17) {
                        value10 = Value.ONE;
                    } else {
                        Fail.raise(Value.createBlock(0, value9.get(14), value, value13, value8.get(15)));
                        value10 = Value.UNIT;
                    }
                    value30.set(l5, value10);
                    value30.set((long)4, Zip.unixtime_of_dostime_1117(value18, value17));
                    value30.set((long)5, value16);
                    value30.set((long)6, value14);
                    value30.set((long)7, value15);
                    value30.set((long)8, Zip.filename_is_directory_1115(value13));
                    value30.set((long)9, Value.createInt64(l4));
                    value7 = Value.createBlock(0, value30, value7);
                }
            }
            catch (Throwable throwable) {
                value7 = Fail.asValue(throwable);
                if (!NativeComparisons.equalValues(value7.get0(), AbstractNativeRunner.getGlobal("caml_exn_End_of_file"))) break block9;
                Fail.raise(Value.createBlock(0, value9.get(14), value, value8.get(17), value8.get(18)));
                value6 = Value.UNIT;
                return value6;
            }
        }
        Fail.raise(value7);
        value6 = Value.UNIT;
        return value6;
    }

    public static Value open_in_1174(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = Pervasives.open_in_bin_1201(value);
        Value value3 = Zip.read_ecd_1123(value, value2);
        Value value4 = value3.get2();
        Value value5 = value3.get0();
        Value value6 = value4;
        Value value7 = Zip.read_cd_1145(value, value2, value5, value6, Value.createInt32(value6.asInt32() + value3.get1().asInt32()));
        Value value8 = Hashtbl.create_1035(Value.ZERO, Value.createFromRawLong(NativeArithmetic.divint(value5.getRawValue(), 7)));
        Value value9 = Value.createClosure(3).setClosure(fun_1469);
        value9.set2(value8);
        List.iter_1061(value9, value7);
        return Value.createBlock(0, value, value2, value7, value8, value3.get3());
    }

    public static Value close_in_1184(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = value.get1();
        return Io.caml_ml_close_channel(value2);
    }

    public static Value find_entry_1186(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        return Hashtbl.find_1088(value.get3(), value2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value goto_entry_1189(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3;
        Value value4 = CONSTANTS;
        Value value5 = GLOBALS;
        try {
            Value value6 = value.get1();
            Value value7 = value2.get(9);
            Io.caml_ml_seek_in_64(value6, value7);
            value7 = Zip.read4_1014(value6);
            Value value8 = Zip.read2_1010(value6);
            Value value9 = Zip.read2_1010(value6);
            Value value10 = Zip.read2_1010(value6);
            Value value11 = Zip.read2_1010(value6);
            Value value12 = Zip.read2_1010(value6);
            Value value13 = Zip.read4_1014(value6);
            Value value14 = Zip.read4_int_1018(value6);
            Value value15 = Zip.read4_int_1018(value6);
            Value value16 = Zip.read2_1010(value6);
            Value value17 = Zip.read2_1010(value6);
            if (value7.asInt32() != 67324752) {
                Fail.raise(Value.createBlock(0, value5.get(14), value.get0(), value2.get0(), value4.get(19)));
            }
            long l = value2.get(9).asInt64() + (NativeArithmetic.addint(NativeArithmetic.addint(61, value16.getRawValue()), value17.getRawValue()) >> 1);
            Value value18 = value.get1();
            value3 = Io.caml_ml_seek_in_64(value18, Value.createInt64(l));
            return value3;
        }
        catch (Throwable throwable) {
            Value value19 = Fail.asValue(throwable);
            if (NativeComparisons.equalValues(value19.get0(), AbstractNativeRunner.getGlobal("caml_exn_End_of_file"))) {
                Fail.raise(Value.createBlock(0, value5.get(14), value.get0(), value2.get0(), value4.get(20)));
                value3 = Value.UNIT;
                return value3;
            }
            Fail.raise(value19);
            value3 = Value.UNIT;
        }
        return value3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value read_entry_1204(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3;
        Value value4;
        Value value5;
        Value value6;
        Value value7;
        Value value8;
        block11: {
            block12: {
                value8 = CONSTANTS;
                Value value9 = Zlib.GLOBALS;
                value7 = GLOBALS;
                Zip.goto_entry_1189(value, value2);
                value6 = Str.caml_create_string(value2.get6());
                Value value10 = value2.get3();
                if (value10.getRawValue() == 1L) {
                    if (NativeComparisons.notEqualValues(value2.get7(), value2.get6())) {
                        Fail.raise(Value.createBlock(0, value7.get(14), value.get0(), value2.get0(), value8.get(25)));
                    }
                    Pervasives.really_input_1216(value.get1(), value6, Value.ZERO, value2.get6());
                    value5 = value6;
                    return value5;
                }
                Value value11 = Value.createBlock(0, value2.get7());
                value4 = Value.createBlock(0, Value.ZERO);
                try {
                    Value value12 = value8.get(21);
                    Value value13 = Value.createClosure(4).setClosure(fun_1480);
                    value13.set2(value);
                    value13.set3(value11);
                    Value value14 = Value.createClosure(7).setClosure(fun_1483, 2);
                    value14.set3(value);
                    value14.set4(value2);
                    value14.set5(value6);
                    value14.set6(value4);
                    Zlib.uncompress_1063(value12, value13, value14);
                }
                catch (Throwable throwable) {
                    block10: {
                        value3 = Fail.asValue(throwable);
                        if (!NativeComparisons.equalValues(value3.get0(), value9.get0())) break block10;
                        Fail.raise(Value.createBlock(0, value7.get(14), value.get0(), value2.get0(), value8.get(22)));
                        break block11;
                    }
                    try {
                        Fail.raise(value3);
                        break block11;
                    }
                    catch (Throwable throwable2) {
                        value6 = Fail.asValue(throwable2);
                        if (!NativeComparisons.equalValues(value6.get0(), AbstractNativeRunner.getGlobal("caml_exn_End_of_file"))) break block12;
                        Fail.raise(Value.createBlock(0, value7.get(14), value.get0(), value2.get0(), value8.get(26)));
                        value5 = Value.UNIT;
                        return value5;
                    }
                }
            }
            Fail.raise(value6);
            value5 = Value.UNIT;
            return value5;
        }
        if (value4.get0().asLong() != value6.sizeBytes()) {
            Fail.raise(Value.createBlock(0, value7.get(14), value.get0(), value2.get0(), value8.get(23)));
        }
        if ((value3 = org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(Value.createInt32(0), value6, Value.ZERO, value6.sizeBytesWrapped())).asInt32() != value2.get5().asInt32()) {
            Fail.raise(Value.createBlock(0, value7.get(14), value.get0(), value2.get0(), value8.get(24)));
        }
        value5 = value6;
        return value5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value copy_entry_to_channel_1215(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Value value4;
        Value value5;
        Value value6;
        Value value7;
        block10: {
            Value value8;
            block11: {
                value7 = CONSTANTS;
                Value value9 = Zlib.GLOBALS;
                value6 = GLOBALS;
                Zip.goto_entry_1189(value, value2);
                value8 = value2.get3();
                if (value8.getRawValue() == 1L) {
                    if (NativeComparisons.notEqualValues(value2.get7(), value2.get6())) {
                        Fail.raise(Value.createBlock(0, value6.get(14), value.get0(), value2.get0(), value7.get(30)));
                    }
                    Value value10 = Str.caml_create_string(LONG_4096);
                    Value value11 = Value.createClosure(5).setClosure(copy_1220);
                    value11.set2(value);
                    value11.set3(value3);
                    value11.set4(value10);
                    Value value12 = value11;
                    value5 = Zip.copy_1220(value2.get6(), value12);
                    return value5;
                }
                Value value13 = Value.createBlock(0, value2.get7());
                value4 = Value.createBlock(0, Value.createInt32(0));
                try {
                    Value value14 = value7.get(27);
                    Value value15 = Value.createClosure(4).setClosure(fun_1487);
                    value15.set2(value);
                    value15.set3(value13);
                    Value value16 = Value.createClosure(5).setClosure(fun_1490, 2);
                    value16.set3(value3);
                    value16.set4(value4);
                    Zlib.uncompress_1063(value14, value15, value16);
                }
                catch (Throwable throwable) {
                    Value value17;
                    block9: {
                        value17 = Fail.asValue(throwable);
                        if (!NativeComparisons.equalValues(value17.get0(), value9.get0())) break block9;
                        Fail.raise(Value.createBlock(0, value6.get(14), value.get0(), value2.get0(), value7.get(28)));
                        break block10;
                    }
                    try {
                        Fail.raise(value17);
                        break block10;
                    }
                    catch (Throwable throwable2) {
                        value8 = Fail.asValue(throwable2);
                        if (!NativeComparisons.equalValues(value8.get0(), AbstractNativeRunner.getGlobal("caml_exn_End_of_file"))) break block11;
                        Fail.raise(Value.createBlock(0, value6.get(14), value.get0(), value2.get0(), value7.get(31)));
                        value5 = Value.UNIT;
                        return value5;
                    }
                }
            }
            Fail.raise(value8);
            value5 = Value.UNIT;
            return value5;
        }
        if (value4.get0().asInt32() != value2.get5().asInt32()) {
            Fail.raise(Value.createBlock(0, value6.get(14), value.get0(), value2.get0(), value7.get(29)));
            value5 = Value.UNIT;
            return value5;
        }
        value5 = Value.ZERO;
        return value5;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value copy_entry_to_file_1229(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        Value value4;
        Value value5 = Unix.GLOBALS;
        Value value6 = Pervasives.open_out_bin_1162(value3);
        Zip.copy_entry_to_channel_1215(value, value2, value6);
        Pervasives.close_out_1190(value6);
        {
            catch (Throwable throwable) {
                Value value7 = Fail.asValue(throwable);
                Pervasives.close_out_1190(value6);
                Sys.caml_sys_remove(value3);
                Fail.raise(value7);
                value4 = Value.UNIT;
                return value4;
            }
            try {
                Value value8 = value2.get4();
                Value value9 = value2.get4();
                value4 = Utimes.unix_utimes(value3, value9, value8);
                return value4;
            }
            catch (Throwable throwable) {}
            {
                Value value10 = Fail.asValue(throwable);
                if (!NativeComparisons.equalValues(value10.get0(), value5.get0()) && !NativeComparisons.equalValues(value10.get0(), AbstractNativeRunner.getGlobal("caml_exn_Invalid_argument"))) {
                    Fail.raise(value10);
                    value4 = Value.UNIT;
                    return value4;
                }
                value4 = Value.ZERO;
            }
        }
        return value4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value open_out_1235(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Value value3 = CONSTANTS;
        Value value4 = GLOBALS;
        Value value5 = (int)value.asLong() != 0 ? value.get0() : value3.get(32);
        if (value5.sizeBytes() >= 65536L) {
            Fail.raise(Value.createBlock(0, value4.get(14), value2, value3.get(33), value3.get(34)));
        }
        Value value6 = value2;
        return Value.createBlock(0, value6, Pervasives.open_out_bin_1162(value6), Value.ZERO, value5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value write_directory_entry_1240(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        Zip.write4_1030(value, Value.createInt32(33639248));
        Value value3 = value2.get3();
        long l = value3.getRawValue() == 1L ? (long)21 : (long)41;
        Zip.write2_1027(value, Value.createFromRawLong(l));
        Zip.write2_1027(value, Value.createFromRawLong(l));
        Zip.write2_1027(value, Value.EIGHT);
        Value value4 = value2.get3();
        Zip.write2_1027(value, value4.getRawValue() == 1L ? Value.ZERO : Value.EIGHT);
        value4 = Zip.dostime_of_unixtime_1120(value2.get4());
        Zip.write2_1027(value, value4.get0());
        Zip.write2_1027(value, value4.get1());
        Zip.write4_1030(value, value2.get5());
        Value value5 = value2.get7();
        Zip.write2_1027(value, value5);
        Zip.write2_1027(value, Value.createFromRawLong(NativeArithmetic.lsrint(value5.getRawValue(), 16)));
        value5 = value2.get6();
        Zip.write2_1027(value, value5);
        Zip.write2_1027(value, Value.createFromRawLong(NativeArithmetic.lsrint(value5.getRawValue(), 16)));
        Zip.write2_1027(value, value2.get0().sizeBytesWrapped());
        Zip.write2_1027(value, value2.get1().sizeBytesWrapped());
        Zip.write2_1027(value, value2.get2().sizeBytesWrapped());
        Zip.write2_1027(value, Value.ZERO);
        Zip.write2_1027(value, Value.ZERO);
        Zip.write2_1027(value, Value.ZERO);
        Zip.write2_1027(value, Value.ZERO);
        Zip.write4_1030(value, Value.createInt32((int)value2.get(9).asInt64()));
        value5 = value2.get0();
        Pervasives.output_1175(value, value5, Value.ZERO, value5.sizeBytesWrapped());
        value5 = value2.get1();
        Pervasives.output_1175(value, value5, Value.ZERO, value5.sizeBytesWrapped());
        value5 = value2.get2();
        return Pervasives.output_1175(value, value5, Value.ZERO, value5.sizeBytesWrapped());
    }

    public static Value close_out_1246(Value value) throws Fail.Exception, Fatal.Exception {
        Value value2 = CONSTANTS;
        Value value3 = GLOBALS;
        Value value4 = value.get1();
        Value value5 = Io.caml_ml_pos_out(value4);
        Value value6 = value4;
        Value value7 = Value.createClosure(3).setClosure(fun_1509);
        value7.set2(value6);
        value6 = value.get2();
        List.iter_1061(value7, List.rev_append_1029(value6, Value.ZERO));
        long l = NativeArithmetic.subint(Io.caml_ml_pos_out(value4).getRawValue(), value5.getRawValue());
        Value value8 = value.get2();
        value8 = List.length_aux_1008(Value.ZERO, value8);
        if (value8.getRawValue() >= 131073L) {
            Fail.raise(Value.createBlock(0, value3.get(14), value.get0(), value2.get(35), value2.get(36)));
        }
        Zip.write4_1030(value4, Value.createInt32(101010256));
        Zip.write2_1027(value4, Value.ZERO);
        Zip.write2_1027(value4, Value.ZERO);
        Zip.write2_1027(value4, value8);
        Zip.write2_1027(value4, value8);
        Zip.write2_1027(value4, Value.createFromRawLong(l));
        Zip.write2_1027(value4, Value.createFromRawLong(NativeArithmetic.lsrint(l, 16)));
        Zip.write2_1027(value4, value5);
        Zip.write2_1027(value4, Value.createFromRawLong(NativeArithmetic.lsrint(value5.getRawValue(), 16)));
        Zip.write2_1027(value4, value.get3().sizeBytesWrapped());
        Value value9 = value.get3();
        Pervasives.output_1175(value4, value9, Value.ZERO, value9.sizeBytesWrapped());
        return Pervasives.close_out_1190(value4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value add_entry_header_1252(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, Fatal.Exception {
        Value value7 = CONSTANTS;
        Value value8 = GLOBALS;
        if (value4.getRawValue() < 1L || value4.getRawValue() > (long)19) {
            Fail.raise(Value.createBlock(0, value8.get(14), value.get0(), value6, value7.get(37)));
        }
        if (value6.sizeBytes() >= 65536L) {
            Fail.raise(Value.createBlock(0, value8.get(14), value.get0(), value6, value7.get(38)));
        }
        if (value2.sizeBytes() >= 65536L) {
            Fail.raise(Value.createBlock(0, value8.get(14), value.get0(), value6, value7.get(39)));
        }
        if (value3.sizeBytes() >= 65536L) {
            Fail.raise(Value.createBlock(0, value8.get(14), value.get0(), value6, value7.get(40)));
        }
        Value value9 = value.get1();
        Value value10 = Io.caml_ml_pos_out_64(value9);
        Zip.write4_1030(value9, Value.createInt32(67324752));
        long l = value4.getRawValue() != 1L ? (long)41 : (long)21;
        Zip.write2_1027(value9, Value.createFromRawLong(l));
        Zip.write2_1027(value9, Value.EIGHT);
        Zip.write2_1027(value9, value4.getRawValue() != 1L ? Value.EIGHT : Value.ZERO);
        Value value11 = Zip.dostime_of_unixtime_1120(value5);
        Zip.write2_1027(value9, value11.get0());
        Zip.write2_1027(value9, value11.get1());
        Zip.write4_1030(value9, Value.createInt32(0));
        Zip.write2_1027(value9, Value.ZERO);
        Zip.write2_1027(value9, Value.ZERO);
        Zip.write2_1027(value9, Value.ZERO);
        Zip.write2_1027(value9, Value.ZERO);
        Zip.write2_1027(value9, value6.sizeBytesWrapped());
        Zip.write2_1027(value9, value2.sizeBytesWrapped());
        Pervasives.output_1175(value9, value6, Value.ZERO, value6.sizeBytesWrapped());
        Pervasives.output_1175(value9, value2, Value.ZERO, value2.sizeBytesWrapped());
        Value value12 = Value.createBlock(0, 10);
        value12.set(0L, value6);
        value12.set(1L, value2);
        value12.set((long)2, value3);
        value12.set((long)3, value4.getRawValue() != 1L ? Value.ONE : Value.ZERO);
        value12.set((long)4, value5);
        value12.set((long)5, Value.createInt32(0));
        value12.set((long)6, Value.ZERO);
        value12.set((long)7, Value.ZERO);
        value12.set((long)8, Zip.filename_is_directory_1115(value6));
        value12.set((long)9, value10);
        return value12;
    }

    public static Value add_data_descriptor_1264(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, Fatal.Exception {
        Value value6 = value.get1();
        Zip.write4_1030(value6, Value.createInt32(134695760));
        Zip.write4_1030(value6, value2);
        Zip.write2_1027(value6, value3);
        Zip.write2_1027(value6, Value.createFromRawLong(NativeArithmetic.lsrint(value3.getRawValue(), 16)));
        Zip.write2_1027(value6, value4);
        Zip.write2_1027(value6, Value.createFromRawLong(NativeArithmetic.lsrint(value4.getRawValue(), 16)));
        Value value7 = Obj.caml_obj_dup(value5);
        value7.set5(value2);
        value7.set6(value4);
        value7.set7(value3);
        return value7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value add_entry_1271(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) throws Fail.Exception, Fatal.Exception {
        Value value8;
        Value value9;
        Value value10;
        Value value11 = CONSTANTS;
        Value value12 = GLOBALS;
        Value value13 = Zlib.GLOBALS;
        Value value14 = (int)value3.asLong() != 0 ? value3.get0() : value11.get(41);
        Value value15 = (int)value4.asLong() != 0 ? value4.get0() : value11.get(42);
        Value value16 = (int)value5.asLong() != 0 ? value5.get0() : Value.SIX;
        Value value17 = (int)value6.asLong() != 0 ? value6.get0() : Time.unix_time(Value.ZERO);
        Value value18 = Zip.add_entry_header_1252(value2, value14, value15, value16, value17, value7);
        Value value19 = org.ocamljava.runtime.primitives.externallibs.zip.Zlib.camlzip_update_crc32(Value.createInt32(0), value, Value.ZERO, value.sizeBytesWrapped());
        if (value16.getRawValue() == 1L) {
            Pervasives.output_1175(value2.get1(), value, Value.ZERO, value.sizeBytesWrapped());
            value10 = value.sizeBytesWrapped();
        } else {
            value9 = Value.createBlock(0, Value.ZERO);
            value8 = Value.createBlock(0, Value.ZERO);
            try {
                Value value20 = Value.createBlock(0, value16);
                Value value21 = value11.get(43);
                Value value22 = Value.createClosure(4).setClosure(fun_1518);
                value22.set2(value);
                value22.set3(value9);
                Value value23 = Value.createClosure(5).setClosure(fun_1521, 2);
                value23.set3(value2);
                value23.set4(value8);
                Zlib.compress_1023(value20, value21, value22, value23);
                value10 = value8.get0();
            }
            catch (Throwable throwable) {
                Value value24 = Fail.asValue(throwable);
                if (NativeComparisons.equalValues(value24.get0(), value13.get0())) {
                    Fail.raise(Value.createBlock(0, value12.get(14), value2.get0(), value7, value11.get(44)));
                    value10 = Value.UNIT;
                }
                Fail.raise(value24);
                value10 = Value.UNIT;
            }
        }
        value9 = value10;
        value8 = Zip.add_data_descriptor_1264(value2, value19, value9, value.sizeBytesWrapped(), value18);
        value2.set2(Value.createBlock(0, value8, value2.get2()));
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value copy_channel_to_entry_1297(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) throws Fail.Exception, Fatal.Exception {
        Value value8;
        Value value9;
        Value value10;
        Value value11;
        Value value12 = CONSTANTS;
        Value value13 = GLOBALS;
        Value value14 = Zlib.GLOBALS;
        Value value15 = (int)value3.asLong() != 0 ? value3.get0() : value12.get(45);
        Value value16 = (int)value4.asLong() != 0 ? value4.get0() : value12.get(46);
        Value value17 = (int)value5.asLong() != 0 ? value5.get0() : Value.SIX;
        Value value18 = (int)value6.asLong() != 0 ? value6.get0() : Time.unix_time(Value.ZERO);
        Value value19 = Zip.add_entry_header_1252(value2, value15, value16, value17, value18, value7);
        Value value20 = Value.createBlock(0, Value.createInt32(0));
        if (value17.getRawValue() == 1L) {
            value11 = Str.caml_create_string(LONG_4096);
            Value value21 = Value.createClosure(6).setClosure(copy_1318);
            value21.set2(value);
            value21.set3(value2);
            value21.set4(value20);
            value21.set5(value11);
            value10 = value21;
            Value value22 = value9 = Zip.copy_1318(Value.ZERO, value10);
            value8 = Value.createBlock(0, value22, value22);
        } else {
            value11 = Value.createBlock(0, Value.ZERO);
            value10 = Value.createBlock(0, Value.ZERO);
            try {
                Value value23 = Value.createBlock(0, value17);
                Value value24 = value12.get(47);
                Value value25 = Value.createClosure(5).setClosure(fun_1525);
                value25.set2(value);
                value25.set3(value20);
                value25.set4(value11);
                Value value26 = Value.createClosure(5).setClosure(fun_1528, 2);
                value26.set3(value2);
                value26.set4(value10);
                Zlib.compress_1023(value23, value24, value25, value26);
                value8 = Value.createBlock(0, value10.get0(), value11.get0());
            }
            catch (Throwable throwable) {
                value9 = Fail.asValue(throwable);
                if (NativeComparisons.equalValues(value9.get0(), value14.get0())) {
                    Fail.raise(Value.createBlock(0, value13.get(14), value2.get0(), value7, value12.get(48)));
                    value8 = Value.UNIT;
                }
                Fail.raise(value9);
                value8 = Value.UNIT;
            }
        }
        value11 = value8;
        value10 = Zip.add_data_descriptor_1264(value2, value20.get0(), value11.get0(), value11.get1(), value19);
        value2.set2(Value.createBlock(0, value10, value2.get2()));
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value copy_file_to_entry_1329(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) throws Fail.Exception, Fatal.Exception {
        Value value8;
        Value value9;
        Value value10;
        Value value11 = CONSTANTS;
        Value value12 = Unix.GLOBALS;
        Value value13 = (int)value3.asLong() != 0 ? value3.get0() : value11.get(49);
        Value value14 = (int)value4.asLong() != 0 ? value4.get0() : value11.get(50);
        Value value15 = (int)value5.asLong() != 0 ? value5.get0() : Value.SIX;
        Value value16 = Pervasives.open_in_bin_1201(value);
        if ((int)value6.asLong() != 0) {
            value10 = value6;
        } else {
            try {
                value10 = Value.createBlock(0, Stat.unix_stat(value).get(10));
            }
            catch (Throwable throwable) {
                value9 = Fail.asValue(throwable);
                if (NativeComparisons.equalValues(value9.get0(), value12.get0())) {
                    value10 = Value.ZERO;
                }
                Fail.raise(value9);
                value10 = Value.UNIT;
            }
        }
        value9 = value10;
        try {
            Zip.copy_channel_to_entry_1297(value16, value2, Value.createBlock(0, value13), Value.createBlock(0, value14), Value.createBlock(0, value15), value9, value7);
            value8 = Io.caml_ml_close_channel(value16);
            return value8;
        }
        catch (Throwable throwable) {
            Value value17 = Fail.asValue(throwable);
            Io.caml_ml_close_channel(value16);
            Fail.raise(value17);
            value8 = Value.UNIT;
            return value8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value add_entry_generator_1347(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, Fatal.Exception {
        Value value7;
        Value value8 = CONSTANTS;
        Value value9 = (int)value2.asLong() != 0 ? value2.get0() : value8.get(51);
        Value value10 = (int)value3.asLong() != 0 ? value3.get0() : value8.get(52);
        Value value11 = (int)value4.asLong() != 0 ? value4.get0() : Value.SIX;
        Value value12 = (int)value5.asLong() != 0 ? value5.get0() : Time.unix_time(Value.ZERO);
        Value value13 = Zip.add_entry_header_1252(value, value9, value10, value11, value12, value6);
        Value value14 = Value.createBlock(0, Value.createInt32(0));
        Value value15 = Value.createBlock(0, Value.ZERO);
        Value value16 = Value.createBlock(0, Value.ZERO);
        Value value17 = Value.createBlock(0, Value.ZERO);
        Value value18 = Value.createClosure(5).setClosure(check_1367);
        value18.set2(value);
        value18.set3(value6);
        value18.set4(value17);
        Value value19 = value18;
        Value value20 = Value.createClosure(8).setClosure(finish_1368);
        value20.set2(value);
        value20.set3(value13);
        value20.set4(value14);
        value20.set5(value15);
        value20.set6(value16);
        value20.set7(value17);
        Value value21 = value20;
        if (value11.getRawValue() == 1L) {
            Value value22 = Value.createClosure(7).setClosure(fun_1550, 3);
            value22.set3(value);
            value22.set4(value15);
            value22.set5(value16);
            value22.set6(value19);
            Value value23 = Value.createClosure(4).setClosure(fun_1553);
            value23.set2(value19);
            value23.set3(value21);
            value7 = Value.createBlock(0, value22, value23);
            return value7;
        }
        Value value24 = Value.createBlock(0, value11);
        Value value25 = value8.get(53);
        Value value26 = Value.createClosure(5).setClosure(fun_1541, 2);
        value26.set3(value);
        value26.set4(value15);
        Value value27 = Zlib.compress_direct_1044(value24, value25, value26);
        Value value28 = value27.get1();
        Value value29 = value27.get0();
        Value value30 = Value.createClosure(9).setClosure(fun_1544, 3);
        value30.set3(value);
        value30.set4(value6);
        value30.set5(value14);
        value30.set6(value16);
        value30.set7(value19);
        value30.set((long)8, value29);
        Value value31 = Value.createClosure(7).setClosure(fun_1547);
        value31.set2(value);
        value31.set3(value6);
        value31.set4(value19);
        value31.set5(value21);
        value31.set6(value28);
        value7 = Value.createBlock(0, value30, value31);
        return value7;
    }

    public static Value entry() throws Fail.Exception, Fatal.Exception {
        Value value = CONSTANTS;
        Value value2 = GLOBALS = AbstractNativeRunner.createGlobal("Zip", 36);
        Value value3 = Value.createBlock(0, value.get(54));
        value2.set(15, value3);
        value3 = Pervasives.GLOBALS.get(64);
        value2.set(16, value3);
        value3 = Value.createClosure(read2_1010);
        value2.set(17, value3);
        value3 = Value.createClosure(read4_1014);
        value2.set(18, value3);
        value3 = Value.createClosure(read4_int_1018);
        value2.set(19, value3);
        value3 = Value.createClosure(readstring_1022, 2);
        value2.set(20, value3);
        value3 = Pervasives.GLOBALS.get(48);
        value2.set(21, value3);
        value3 = Value.createClosure(write2_1027, 2);
        value2.set(22, value3);
        value3 = Value.createClosure(write4_1030, 2);
        value2.set(23, value3);
        value3 = Value.createClosure(write4_int_1033, 2);
        value2.set(24, value3);
        value3 = Value.createClosure(writestring_1036, 2);
        value2.set(25, value3);
        value3 = Value.createClosure(entries_1097);
        value2.set1(value3);
        value3 = Value.createClosure(comment_1099);
        value2.set2(value3);
        value3 = Value.createBlock(0, value.get(55));
        value2.set(14, value3);
        value3 = Value.createClosure(strrstr_1107, 4);
        value2.set(26, value3);
        value3 = Value.createClosure(filename_is_directory_1115);
        value2.set(27, value3);
        value3 = Value.createClosure(unixtime_of_dostime_1117, 2);
        value2.set(28, value3);
        value3 = Value.createClosure(dostime_of_unixtime_1120);
        value2.set(29, value3);
        value3 = Value.createClosure(read_ecd_1123, 2);
        value2.set(30, value3);
        value3 = Value.createClosure(read_cd_1145, 5);
        value2.set(31, value3);
        value3 = Value.createClosure(open_in_1174);
        value2.set0(value3);
        value3 = Value.createClosure(close_in_1184);
        value2.set7(value3);
        value3 = Value.createClosure(find_entry_1186, 2);
        value2.set3(value3);
        value3 = Value.createClosure(goto_entry_1189, 2);
        value2.set(32, value3);
        value3 = Value.createClosure(read_entry_1204, 2);
        value2.set4(value3);
        value3 = Value.createClosure(copy_entry_to_channel_1215, 3);
        value2.set5(value3);
        value3 = Value.createClosure(copy_entry_to_file_1229, 3);
        value2.set6(value3);
        value3 = Value.createClosure(open_out_1235, 2);
        value2.set(8, value3);
        value3 = Value.createClosure(write_directory_entry_1240, 2);
        value2.set(33, value3);
        value3 = Value.createClosure(close_out_1246);
        value2.set(13, value3);
        value3 = Value.createClosure(add_entry_header_1252, 6);
        value2.set(34, value3);
        value3 = Value.createClosure(add_data_descriptor_1264, 5);
        value2.set(35, value3);
        value3 = Value.createClosure(add_entry_1271, 7);
        value2.set(9, value3);
        value3 = Value.createClosure(copy_channel_to_entry_1297, 7);
        value2.set(10, value3);
        value3 = Value.createClosure(copy_file_to_entry_1329, 7);
        value2.set(11, value3);
        value3 = Value.createClosure(add_entry_generator_1347, 6);
        value2.set(12, value3);
        return Value.ZERO;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "search_1112", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "find_ecd_1128", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1469", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1483", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1480", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_5() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1490", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_6() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1487", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_7() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_1220", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_8() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1509", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_9() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1521", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_10() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1518", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_11() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1528", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_12() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1525", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_13() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_1318", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_14() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1547", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_15() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1544", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_16() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1541", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_17() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1553", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_18() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "fun_1550", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_19() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "finish_1368", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_20() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "check_1367", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_21() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read2_1010", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_22() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read4_1014", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_23() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read4_int_1018", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_24() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "readstring_1022", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_25() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "write2_1027", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_26() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "write4_1030", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_27() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "write4_int_1033", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_28() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "writestring_1036", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_29() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "entries_1097", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_30() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "comment_1099", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_31() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "strrstr_1107", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_32() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "filename_is_directory_1115", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_33() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "unixtime_of_dostime_1117", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_34() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "dostime_of_unixtime_1120", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_35() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read_ecd_1123", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_36() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read_cd_1145", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_37() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "open_in_1174", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_38() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "close_in_1184", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_39() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "find_entry_1186", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_40() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "goto_entry_1189", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_41() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "read_entry_1204", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_42() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_entry_to_channel_1215", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_43() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_entry_to_file_1229", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_44() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "open_out_1235", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_45() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "write_directory_entry_1240", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_46() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "close_out_1246", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_47() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "add_entry_header_1252", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_48() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "add_data_descriptor_1264", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_49() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "add_entry_1271", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_50() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_channel_to_entry_1297", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_51() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "copy_file_to_entry_1329", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_52() {
        try {
            return MethodHandles.lookup().findStatic(Zip.class, "add_entry_generator_1347", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

