/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.CustomBigArray;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="bigarray", module="Bigarray", source="otherlibs/bigarray/bigarray_stubs.c")
public final class BigArray {
    static final int MAX_NUM_DIMS = 16;
    static final int CAML_BA_FLOAT32 = 0;
    static final int CAML_BA_FLOAT64 = 1;
    static final int CAML_BA_SINT8 = 2;
    static final int CAML_BA_UINT8 = 3;
    static final int CAML_BA_SINT16 = 4;
    static final int CAML_BA_UINT16 = 5;
    static final int CAML_BA_INT32 = 6;
    static final int CAML_BA_INT64 = 7;
    static final int CAML_BA_CAML_INT = 8;
    static final int CAML_BA_NATIVE_INT = 9;
    static final int CAML_BA_COMPLEX32 = 10;
    static final int CAML_BA_COMPLEX64 = 11;
    static final int CAML_BA_KIND_MASK = 255;
    static final int CAML_BA_C_LAYOUT = 0;
    static final int CAML_BA_FORTRAN_LAYOUT = 256;
    static final int CAML_BA_LAYOUT_MASK = 256;
    static final int CAML_BA_EXTERNAL = 0;
    static final int CAML_BA_MANAGED = 512;
    static final int CAML_BA_MAPPED_FILE = 1024;
    static final int CAML_BA_MANAGED_MASK = 1536;
    static final int SIZE_FLOAT32 = 4;
    static final int SIZE_FLOAT64 = 8;
    static final int SIZE_SINT8 = 1;
    static final int SIZE_UINT8 = 1;
    static final int SIZE_SINT16 = 2;
    static final int SIZE_UINT16 = 2;
    static final int SIZE_INT32 = 4;
    static final int SIZE_INT64 = 8;
    static final int SIZE_CAML_INT = 8;
    static final int SIZE_NATIVE_INT = 8;
    static final int SIZE_COMPLEX32 = 8;
    static final int SIZE_COMPLEX64 = 16;
    static final int[] CAML_BA_ELEMENT_SIZE = new int[]{4, 8, 1, 1, 2, 2, 4, 8, 8, 8, 8, 16};
    static final int STRUCT_SIZE = 20;

    private BigArray() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_ba_init(Value value) {
        CurrentContext.CODE_STATE.registerCustom(CustomBigArray.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b) Bigarray.kind", "'c Bigarray.layout", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_create(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        int n;
        int n2 = (int)value3.sizeValues();
        if (n2 < 1 || n2 > 16) {
            Fail.invalidArgument("Bigarray.create: bad number of dimensions");
        }
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = value3.get(n).asCastedInt();
            if (nArray[n] >= 0) continue;
            Fail.invalidArgument("Bigarray.create: negative dimension");
        }
        n = value.asCastedInt() | value2.asCastedInt();
        MemArray memArray = new MemArray(n, nArray, null);
        return Value.createCustom(CustomBigArray.OPS, 20 + (n2 - 1) * 8, memArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="'a")
    public static Value caml_ba_get_1(Value value, Value value2) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_2(Value value, Value value2, Value value3) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt(), value3.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int"}, returnType="'a")
    public static Value caml_ba_get_3(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        return ((MemArray)value.asCustom()).get(new int[]{value2.asCastedInt(), value3.asCastedInt(), value4.asCastedInt()});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="'a")
    public static Value caml_ba_get_generic(Value value, Value value2) throws Fail.Exception {
        int n = (int)value2.sizeValues();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = value2.get(i).asCastedInt();
        }
        return ((MemArray)value.asCustom()).get(nArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_1(Value value, Value value2, Value value3) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt()}, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_2(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt(), value3.asCastedInt()}, value4);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int", "int", "'a"}, returnType="unit")
    public static Value caml_ba_set_3(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception {
        ((MemArray)value.asCustom()).set(new int[]{value2.asCastedInt(), value3.asCastedInt(), value4.asCastedInt()}, value5);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array", "'a"}, returnType="unit")
    public static Value caml_ba_set_generic(Value value, Value value2, Value value3) throws Fail.Exception {
        int n = (int)value2.sizeValues();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = value2.get(i).asCastedInt();
        }
        ((MemArray)value.asCustom()).set(nArray, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="int")
    public static Value caml_ba_num_dims(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getNumDims());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int"}, returnType="int")
    public static Value caml_ba_dim(Value value, Value value2) throws Fail.Exception {
        MemArray memArray = (MemArray)value.asCustom();
        int n = value2.asCastedInt();
        if (n >= memArray.getNumDims()) {
            Fail.invalidArgument("Bigarray.dim");
        }
        return Value.createLong(memArray.getDim(n));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="('a, 'b) Bigarray.kind")
    public static Value caml_ba_kind(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getFlags() & 0xFFL);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="'c Bigarray.layout")
    public static Value caml_ba_layout(Value value) {
        return Value.createLong(((MemArray)value.asCustom()).getFlags() & 0x100L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int", "int"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_sub(Value value, Value value2, Value value3) throws Fail.Exception, Fatal.Exception {
        int n;
        int n2;
        int n3;
        MemArray memArray = (MemArray)value.asCustom();
        int[] nArray = memArray.getDims();
        int n4 = nArray.length;
        int n5 = value2.asCastedInt();
        int n6 = value3.asCastedInt();
        if ((memArray.getFlags() & 0x100L) == 0L) {
            n3 = 1;
            for (n2 = 1; n2 < n4; n3 *= nArray[n2], ++n2) {
            }
            n = 0;
        } else {
            n3 = 1;
            for (n2 = 0; n2 < n4 - 1; n3 *= nArray[n2], ++n2) {
            }
            n = n4 - 1;
            --n5;
        }
        if (n5 < 0 || n6 < 0 || n5 + n6 > nArray[n]) {
            Fail.invalidArgument("Bigarray.sub: bad sub-array");
        }
        memArray.getData().position(n5 * n3 * CAML_BA_ELEMENT_SIZE[(int)memArray.getFlags() & 0xFF]);
        ByteBuffer byteBuffer = memArray.getData().slice();
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        nArray2[n] = n6;
        MemArray memArray2 = new MemArray(memArray.getFlags(), nArray2, byteBuffer);
        return Value.createCustom(CustomBigArray.OPS, 20 + (n4 - 1) * 8, memArray2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_slice(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        int n;
        int n2;
        int n3;
        Object object;
        int[] nArray;
        int n4;
        MemArray memArray = (MemArray)value.asCustom();
        int n5 = (int)value2.sizeValues();
        if (n5 >= (n4 = (nArray = memArray.getDims()).length)) {
            Fail.invalidArgument("Bigarray.slice: too many indices");
        }
        if ((memArray.getFlags() & 0x100L) == 0L) {
            object = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                object[n3] = value2.get(n3).asCastedInt();
            }
            n2 = memArray.offset((int[])object);
            n = n5;
        } else {
            object = new int[16];
            for (n3 = 0; n3 < n5; ++n3) {
                object[n4 - n5 + n3] = value2.get(n3).asCastedInt();
            }
            for (n3 = 0; n3 < n4 - n5; ++n3) {
                object[n3] = 1;
            }
            n2 = memArray.offset((int[])object);
            n = 0;
        }
        memArray.getData().position(4 * n2 * CAML_BA_ELEMENT_SIZE[(int)memArray.getFlags() & 0xFF]);
        object = memArray.getData().slice();
        n3 = n4 - n5;
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n, nArray2, 0, n3);
        MemArray memArray2 = new MemArray(memArray.getFlags(), nArray2, (ByteBuffer)object);
        return Value.createCustom(CustomBigArray.OPS, 20 + (n3 - 1) * 8, memArray2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "('a, 'b, 'c) Bigarray.Genarray.t"}, returnType="unit")
    public static Value caml_ba_blit(Value value, Value value2) throws Fail.Exception {
        int[] nArray;
        MemArray memArray = (MemArray)value.asCustom();
        MemArray memArray2 = (MemArray)value2.asCustom();
        int[] nArray2 = memArray.getDims();
        if (nArray2.length != (nArray = memArray2.getDims()).length) {
            Fail.invalidArgument("Bigarray.blit: dimension mismatch");
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == nArray[i]) continue;
            Fail.invalidArgument("Bigarray.blit: dimension mismatch");
        }
        ByteBuffer byteBuffer = memArray.getData();
        ByteBuffer byteBuffer2 = memArray2.getData();
        byteBuffer.position(0);
        byteBuffer2.position(0);
        byteBuffer2.put(byteBuffer);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "'a"}, returnType="unit")
    public static Value caml_ba_fill(Value value, Value value2) {
        MemArray memArray = (MemArray)value.asCustom();
        long l = memArray.getNumElems();
        ByteBuffer byteBuffer = memArray.getData();
        switch ((int)memArray.getFlags() & 0xFF) {
            case 0: {
                float f = (float)value2.asDouble();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putFloat(4 * n, f);
                    ++n;
                }
                break;
            }
            case 1: {
                double d = value2.asDouble();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putDouble(8 * n, d);
                    ++n;
                }
                break;
            }
            case 2: 
            case 3: {
                byte by = (byte)(value2.asLong() & 0xFFL);
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.put(1 * n, by);
                    ++n;
                }
                break;
            }
            case 4: 
            case 5: {
                short s = (short)(value2.asLong() & 0xFFFFL);
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putShort(2 * n, s);
                    ++n;
                }
                break;
            }
            case 6: {
                int n = value2.asInt32();
                int n2 = 0;
                while ((long)n2 < l) {
                    byteBuffer.putInt(4 * n2, n);
                    ++n2;
                }
                break;
            }
            case 7: {
                long l2 = value2.asInt64();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putLong(8 * n, l2);
                    ++n;
                }
                break;
            }
            case 9: {
                long l3 = value2.asNativeInt();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putLong(8 * n, l3);
                    ++n;
                }
                break;
            }
            case 8: {
                long l4 = value2.asLong();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putLong(8 * n, l4);
                    ++n;
                }
                break;
            }
            case 10: {
                float f = (float)value2.getDouble0();
                float f2 = (float)value2.getDouble1();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putFloat(8 * n, f);
                    byteBuffer.putFloat(8 * n + 4, f2);
                    ++n;
                }
                break;
            }
            case 11: {
                double d = value2.getDouble0();
                double d2 = value2.getDouble1();
                int n = 0;
                while ((long)n < l) {
                    byteBuffer.putDouble(16 * n, d);
                    byteBuffer.putDouble(16 * n + 8, d2);
                    ++n;
                }
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
        return Value.UNIT;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file(Value var0, Value var1_1, Value var2_2, Value var3_3, Value var4_4, Value var5_5) throws Fail.Exception, Fatal.Exception, FalseExit {
        block18: {
            block14: {
                try {
                    var6_6 = var0.asCastedInt();
                    var7_9 = var1_1.asCastedInt() | var2_2.asCastedInt();
                    var8_12 = var5_5.asInt64();
                    var10_13 = (int)var4_4.sizeValues();
                    v0 = var11_14 = (var7_9 & 256) != 0 ? var10_13 - 1 : 0;
                    if (var10_13 < 1 || var10_13 > 16) {
                        Fail.invalidArgument("Bigarray.mmap: bad number of dimensions");
                    }
                    var12_15 = new int[var10_13];
                    var13_16 = 0;
                    break block14;
                }
                catch (InterruptedIOException var6_7) {
                    var7_10 = FalseExit.createFromContext(CurrentContext.CONTEXT);
                    var7_10.fillInStackTrace();
                    throw var7_10;
                }
                catch (IOException var6_8) {
                    var7_11 = var6_8.getMessage();
                    Fail.raiseSysError(var7_11 != null ? var7_11 : "error in file mapping");
                }
                return Value.UNIT;
            }
            while (true) {
                block17: {
                    block16: {
                        block15: {
                            if (var13_16 >= var10_13) break block15;
                            var12_15[var13_16] = var14_18 = var4_4.get(var13_16).asCastedInt();
                            if (var14_18 != -1 || var13_16 != var11_14) break block16;
                            break block17;
                        }
                        var13_17 = CurrentContext.FILES_STATE.getChannel(var6_6);
                        if (var13_17 == null) {
                            Fail.raiseSysError("invalid file descriptor");
                        }
                        if (!(var13_17.asChannel() instanceof FileChannel)) {
                            Fail.raiseSysError("invalid file descriptor");
                        }
                        var14_19 = (FileChannel)var13_17.asChannel();
                        var15_20 = var14_19.position();
                        var17_21 = var14_19.size();
                        var19_22 = BigArray.CAML_BA_ELEMENT_SIZE[var7_9 & 255];
                        for (var21_23 = 0; var21_23 < var10_13; ++var21_23) {
                            var22_26 = var12_15[var21_23];
                            if (var22_26 == -1) continue;
                            var19_22 *= (long)var22_26;
                        }
                        break;
                    }
                    if (var14_18 < 0) {
                        Fail.invalidArgument("Bigarray.create: negative dimension");
                    }
                }
                ++var13_16;
            }
            if (var12_15[var11_14] != -1) break block18;
            if (var17_21 < var8_12) {
                Fail.failWith("Bigarray.mmap: file position exceeds file size");
            }
            var21_24 = var17_21 - var8_12;
            var12_15[var11_14] = IntegerUtils.ensure32s(var21_24 / var19_22);
            if ((var19_22 = (long)var12_15[var11_14] * var19_22) != var21_24) {
                Fail.failWith("Bigarray.mmap: file size doesn't match array dimensions");
            }
            ** GOTO lbl-1000
        }
        if (var17_21 >= var8_12 + var19_22) ** GOTO lbl-1000
        var14_19.truncate(var8_12 + var19_22);
lbl-1000:
        // 3 sources

        {
            var21_25 = var3_3 != Value.FALSE ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.PRIVATE;
            var22_27 = var14_19.map(var21_25, var15_20 + var8_12, var19_22);
            var23_28 = new MemArray(var7_9, var12_15, var22_27);
            return Value.createCustom(CustomBigArray.OPS, 20 + (var12_15.length - 1) * 8, var23_28);
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "('a, 'b) Bigarray.kind", "'c Bigarray.layout", "bool", "int array", "int64"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_map_file_bytecode(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, Fatal.Exception, FalseExit {
        return BigArray.caml_ba_map_file(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a, 'b, 'c) Bigarray.Genarray.t", "int array"}, returnType="('a, 'b, 'c) Bigarray.Genarray.t")
    public static Value caml_ba_reshape(Value value, Value value2) throws Fail.Exception, Fatal.Exception {
        MemArray memArray = (MemArray)value.asCustom();
        int n = (int)value2.sizeValues();
        if (n < 1 || n > 16) {
            Fail.invalidArgument("Bigarray.reshape: bad number of dimensions");
        }
        int[] nArray = new int[n];
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            int n2 = value2.get(i).asCastedInt();
            if (nArray[i] < 0) {
                Fail.invalidArgument("Bigarray.reshape: negative dimension");
            }
            nArray[i] = n2;
            l *= (long)n2;
        }
        if (l != memArray.getNumElems()) {
            Fail.invalidArgument("Bigarray.reshape: size mismatch");
        }
        MemArray memArray2 = new MemArray(memArray.getFlags(), nArray, memArray.getData());
        return Value.createCustom(CustomBigArray.OPS, 20 + (nArray.length - 1) * 8, memArray2);
    }
}

