/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/make_img.c")
public final class MakeImage {
    private static final int TRANSPARENT = -1;

    private MakeImage() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.color array array"}, returnType="Graphics.image")
    public static Value caml_gr_make_image(Value value) throws Fail.Exception {
        int[] nArray;
        int n;
        GraphSlot.checkGraph();
        int n2 = (int)value.sizeValues();
        if (n2 != 0) {
            n = (int)value.get0().sizeValues();
            for (int i = 1; i < n2; ++i) {
                if (value.get(i).sizeValues() == (long)n) continue;
                GraphSlot.fail("make_image: lines of different lengths", "");
            }
            nArray = new int[n2 * n];
            block1: for (int i = 0; i < n2; ++i) {
                Value value2 = value.get(i);
                int n3 = 0;
                while (true) {
                    if (n3 >= n) continue block1;
                    int n4 = value2.get(n3).asCastedInt();
                    nArray[i * n + n3] = n4 == -1 ? 0 : n4 | 0xFF000000;
                    ++n3;
                }
            }
        } else {
            return Value.createCustom(CustomImage.OPS, 16L, new BufferedImage(0, 0, 2));
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return Value.createCustom(CustomImage.OPS, 16L, bufferedImage);
    }
}

