/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.ocamljava.runtime.util.MemoryInputStream;

public final class RandomAccessInputStream {
    private static final String FILE_MODE_READ = "r";
    private static final int BUFFER_SIZE = 65536;
    private final byte[] bytes;
    private final RandomAccessFile file;

    public RandomAccessInputStream(File file) throws FileNotFoundException {
        assert (file != null) : "null f";
        this.file = new RandomAccessFile(file, FILE_MODE_READ);
        this.bytes = null;
    }

    public RandomAccessInputStream(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public RandomAccessInputStream(InputStream inputStream, int n) throws IOException {
        assert (inputStream != null) : "null in";
        assert (n >= 0) : "maxSize should be >= 0";
        if (n == 0) {
            this.bytes = new byte[0];
        } else {
            byte[] byArray = new byte[65536];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read(byArray);
            for (int i = 0; n2 != -1 && i < n; i += n2) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
        }
        this.file = null;
    }

    public RandomAccessInputStream(InputStream inputStream) throws IOException {
        this(inputStream, Integer.MAX_VALUE);
    }

    public DataInput dataInputFrom(long l) throws IOException {
        assert (l >= 0L) : "ofs should be >= 0";
        if (this.file == null) {
            assert (l <= Integer.MAX_VALUE) : "ofs should be <= Integer.MAX_VALUE when in 'stream' mode";
        } else {
            this.file.seek(l);
            return this.file;
        }
        int n = (int)l;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes, n, this.bytes.length - n);
        return new DataInputStream(byteArrayInputStream);
    }

    public byte[] readBytes(long l, int n) throws IOException {
        assert (l >= 0L) : "ofs should be >= 0";
        assert (n >= 0) : "len should be >= 0";
        byte[] byArray = new byte[n];
        if (this.file != null) {
            this.file.seek(l);
            this.file.readFully(byArray);
        } else {
            assert (l <= Integer.MAX_VALUE) : "ofs should be <= Integer.MAX_VALUE when in 'stream' mode";
            try {
                System.arraycopy(this.bytes, (int)l, byArray, 0, n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IOException(indexOutOfBoundsException.toString());
            }
        }
        return byArray;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long length() throws IOException {
        if (this.file != null) {
            return this.file.length();
        }
        return this.bytes.length;
    }

    public MemoryInputStream createInputStream() {
        if (this.bytes != null) {
            return new MemoryInputStream(this.bytes);
        }
        return null;
    }
}

