/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/lssek.c")
public final class Lseek {
    private Lseek() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int", "Unix.seek_command"}, returnType="int")
    public static Value unix_lseek(Value value, Value value2, Value value3) throws Fail.Exception, FalseExit {
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("lseek", "invalid descriptor");
                return Value.UNIT;
            }
            return Value.createLong(channel.seek(value2.asLong(), value3.asCastedInt()));
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("lseek", iOException);
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int64", "Unix.seek_command"}, returnType="int64")
    public static Value unix_lseek_64(Value value, Value value2, Value value3) throws Fail.Exception, FalseExit {
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("lseek_64", "invalid descriptor");
                return Value.UNIT;
            }
            return Value.createInt64(channel.seek(value2.asInt64(), value3.asCastedInt()));
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("lseek_64", iOException);
            return Value.UNIT;
        }
    }
}

