/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.num;

import java.math.BigInteger;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.primitives.otherlibs.num.CustomNat;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="num", module="Nat", source="otherlibs/num/nat_stubs.c")
public final class Nat {
    static final int DIGIT_SIZE_IN_BYTES = 8;
    private static final int BNG_BITS_PER_DIGIT = 64;
    private static final int BNG_BITS_PER_HALF_DIGIT = 32;
    private static final BigInteger BNG_LOW_HALF_MASK = Nat.createDigit(0xFFFFFFFFL);
    private static final BigInteger BNG_DIGIT_MASK = Nat.createDigit(-1L);
    private static final BigInteger MAX_LONG = Nat.createDigit(0x3FFFFFFFFFFFFFFFL);

    private Nat() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value initialize_nat(Value value) {
        CurrentContext.CODE_STATE.registerCustom(CustomNat.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Nat.nat")
    public static Value create_nat(Value value) {
        int n = value.asCastedInt();
        long[] lArray = new long[n + 1];
        return Value.createCustom(CustomNat.OPS, n * 8, lArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat"}, returnType="int")
    public static Value length_nat(Value value) {
        return Value.createLong(value.getWoSize() - 1L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_to_zero_nat(Value value, Value value2, Value value3) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = 0L;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value blit_nat(Value value, Value value2, Value value3, Value value4, Value value5) {
        System.arraycopy((long[])value3.asCustom(), value4.asCastedInt(), (long[])value.asCustom(), value2.asCastedInt(), value5.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_digit_nat(Value value, Value value2, Value value3) {
        ((long[])value.asCustom())[value2.asCastedInt()] = value3.asLong();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value nth_digit_nat(Value value, Value value2) {
        return Value.createLong(((long[])value.asCustom())[value2.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "nativeint"}, returnType="unit")
    public static Value set_digit_nat_native(Value value, Value value2, Value value3) {
        ((long[])value.asCustom())[value2.asCastedInt()] = value3.asNativeInt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="nativeint")
    public static Value nth_digit_nat_native(Value value, Value value2) {
        return Value.createNativeInt(((long[])value.asCustom())[value2.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="int")
    public static Value num_digits_nat(Value value, Value value2, Value value3) {
        int n;
        block2: {
            long[] lArray = (long[])value.asCustom();
            int n2 = value2.asCastedInt();
            for (n = value3.asCastedInt(); n != 0; --n) {
                if (lArray[n2 + n - 1] == 0L) {
                    continue;
                }
                break block2;
            }
            return Value.ONE;
        }
        return Value.createLong(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value num_leading_zero_bits_in_digit(Value value, Value value2) {
        return Value.createLong(Nat.numLeadingZeroBitsInDigit(((long[])value.asCustom())[value2.asCastedInt()]));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_int(Value value, Value value2) {
        BigInteger bigInteger = Nat.createDigit(((long[])value.asCustom())[value2.asCastedInt()]);
        return bigInteger.compareTo(MAX_LONG) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_zero(Value value, Value value2) {
        return ((long[])value.asCustom())[value2.asCastedInt()] == 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_normalized(Value value, Value value2) {
        return (((long[])value.asCustom())[value2.asCastedInt()] & Long.MIN_VALUE) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_odd(Value value, Value value2) {
        return (((long[])value.asCustom())[value2.asCastedInt()] & 1L) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value incr_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        if (value4 != Value.ZERO && n2 != 0) {
            do {
                int n3 = n++;
                lArray[n3] = lArray[n3] + 1L;
                if (lArray[n3] != 0L) break block3;
            } while (--n2 != 0);
        } else {
            block3: {
                return value4;
            }
            return Value.ZERO;
        }
        return Value.ONE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value3.asCastedInt();
        int n4 = value6.asCastedInt();
        long l = value7.asLong();
        n3 -= n4;
        while (true) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            if (n4 > 0) {
                bigInteger3 = Nat.createDigit(lArray[n]);
                bigInteger2 = Nat.addDigit(bigInteger3, Nat.createDigit(lArray2[n2]));
                bigInteger = Nat.addDigit(bigInteger2, Nat.createDigit(l));
            }
            if (l == 0L) return Value.createLong(l);
            if (n3 == 0) return Value.createLong(l);
            do {
                int n5 = n++;
                long l2 = lArray[n5] + 1L;
                lArray[n5] = l2;
                if (l2 != 0L) return Value.ZERO;
            } while (--n3 != 0);
            return Value.ONE;
            l = (bigInteger2.compareTo(bigInteger3) < 0 ? 1 : 0) + (bigInteger.compareTo(bigInteger2) < 0 ? 1 : 0);
            lArray[n] = bigInteger.longValue();
            --n4;
            ++n;
            ++n2;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Nat.add_nat(value, value2, value3, value4, value5, value6, value7);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value complement_nat(Value value, Value value2, Value value3) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = lArray[i + n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value decr_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        long l = 1L ^ value4.asLong();
        if (l != 0L && n2 != 0) {
            do {
                int n3 = n++;
                long l2 = lArray[n3];
                lArray[n3] = l2 - 1L;
                if (l2 != 0L) break block3;
            } while (--n2 != 0);
        } else {
            block3: {
                return value4;
            }
            return Value.ONE;
        }
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Value.createLong(Nat.subNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt(), Nat.createDigit(value7.asLong())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Nat.sub_nat(value, value2, value3, value4, value5, value6, value7);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        return Value.createLong(Nat.multDigitNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt(), (long[])value7.asCustom(), value8.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        return Nat.mult_digit_nat(value, value2, value3, value4, value5, value6, value7, value8);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        long[] lArray3 = (long[])value7.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value8.asCastedInt();
        int n4 = value3.asCastedInt();
        int n5 = value6.asCastedInt();
        int n6 = value9.asCastedInt();
        BigInteger bigInteger = Nat.createDigit(0L);
        while (n6 > 0) {
            bigInteger = Nat.addDigit(bigInteger, Nat.createDigit(Nat.multDigitNat(lArray, n, n4, lArray2, n2, n5, lArray3, n3)));
            --n6;
            ++n3;
            --n4;
            ++n;
        }
        return Value.createLong(bigInteger.longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        return Nat.mult_nat(value, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value3.asCastedInt();
        int n4 = value6.asCastedInt();
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 1; i < n4; ++i) {
            int n5 = 2 * i - 1;
            bigInteger = Nat.addDigit(bigInteger, Nat.createDigit(Nat.multDigitNat(lArray, n + n5, n3 - n5, lArray2, n2 + i, n4 - i, lArray2, n2 + i - 1)));
        }
        bigInteger = bigInteger.shiftLeft(1).and(BNG_DIGIT_MASK).or(Nat.createDigit(Nat.shiftLeft(lArray, n, n3, 1)).and(BNG_DIGIT_MASK));
        BigInteger bigInteger2 = BigInteger.ZERO;
        int n6 = 0;
        while (true) {
            if (n6 >= n4) break;
            BigInteger bigInteger3 = Nat.createDigit(lArray2[n2 + n6]);
            BigInteger bigInteger4 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger5 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger3.shiftRight(32));
            BigInteger bigInteger6 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger7 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger3.shiftRight(32));
            BigInteger bigInteger8 = Nat.addDigit(bigInteger7, Nat.addDigit(bigInteger5.shiftRight(32), bigInteger6.shiftRight(32)));
            BigInteger bigInteger9 = bigInteger4;
            BigInteger bigInteger10 = Nat.addDigit(bigInteger9, bigInteger5.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger10.compareTo(bigInteger9) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger6.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = bigInteger11;
            bigInteger4 = Nat.createDigit(lArray[n]);
            bigInteger5 = Nat.addDigit(bigInteger4, bigInteger12);
            bigInteger6 = Nat.addDigit(bigInteger5, bigInteger2);
            bigInteger2 = Nat.addDigit(bigInteger5.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger6.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n] = bigInteger6.longValue();
            bigInteger4 = Nat.createDigit(lArray[++n]);
            bigInteger5 = Nat.addDigit(bigInteger4, bigInteger8);
            bigInteger6 = Nat.addDigit(bigInteger5, bigInteger2);
            bigInteger2 = Nat.addDigit(bigInteger5.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger6.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n] = bigInteger6.longValue();
            ++n;
            ++n6;
        }
        if ((n3 -= 2 * n4) <= 0) return Value.createLong(Nat.addDigit(bigInteger, bigInteger2).longValue());
        if (bigInteger2.compareTo(BigInteger.ZERO) == 0) return Value.createLong(Nat.addDigit(bigInteger, bigInteger2).longValue());
        do {
            int n7 = n++;
            lArray[n7] = lArray[n7] + 1L;
            if (lArray[n7] == 0L) continue;
            bigInteger2 = BigInteger.ZERO;
            return Value.createLong(Nat.addDigit(bigInteger, bigInteger2).longValue());
        } while (--n3 != 0);
        return Value.createLong(Nat.addDigit(bigInteger, bigInteger2).longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.square_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        ((long[])value4.asCustom())[value5.asCastedInt()] = Nat.shiftLeft((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), value6.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.shift_left_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        long[] lArray2 = (long[])value5.asCustom();
        int n2 = value6.asCastedInt();
        int n3 = value7.asCastedInt();
        long l = ((long[])value8.asCustom())[value9.asCastedInt()];
        int n4 = Nat.numLeadingZeroBitsInDigit(l);
        BigInteger bigInteger = Nat.createDigit(l);
        bigInteger = bigInteger.shiftLeft(n4).and(BNG_DIGIT_MASK);
        Nat.shiftLeft(lArray2, n2, n3, n4);
        BigInteger bigInteger2 = Nat.divRemNormDigit(lArray, n, lArray2, n2, n3, bigInteger);
        Nat.shiftRight(lArray2, n2, n3, n4);
        ((long[])value3.asCustom())[value4.asCastedInt()] = bigInteger2.shiftRight(n4).longValue();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        return Nat.div_digit_nat(value, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    /*
     * Unable to fully structure code
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat(Value var0, Value var1_1, Value var2_2, Value var3_3, Value var4_4, Value var5_5) {
        block9: {
            block8: {
                var6_6 = (long[])var0.asCustom();
                var7_7 = (long[])var3_3.asCustom();
                var8_8 = var1_1.asCastedInt();
                var9_9 = var4_4.asCastedInt();
                var10_10 = var2_2.asCastedInt();
                var11_11 = var5_5.asCastedInt();
                var15_12 = Nat.numLeadingZeroBitsInDigit(var7_7[var9_9 + var11_11 - 1]);
                Nat.shiftLeft(var6_6, var8_8, var10_10, var15_12);
                Nat.shiftLeft(var7_7, var9_9, var11_11, var15_12);
                if (var11_11 != 1) break block8;
                var6_6[var8_8] = Nat.divRemNormDigit(var6_6, var8_8 + 1, var6_6, var8_8, var10_10, Nat.createDigit(var7_7[var9_9])).longValue();
                break block9;
            }
            var12_13 = Nat.createDigit(var7_7[var9_9 + var11_11 - 1]);
            for (var16_14 = var10_10 - 1; var16_14 >= var11_11; --var16_14) {
                block11: {
                    block16: {
                        block7: {
                            block14: {
                                block15: {
                                    block13: {
                                        block6: {
                                            block12: {
                                                block5: {
                                                    block10: {
                                                        var17_16 = var16_14 - var11_11;
                                                        if (Nat.addDigit(var12_13, BigInteger.ONE).compareTo(BigInteger.ZERO) != 0) break block10;
                                                        var13_15 = Nat.createDigit(var6_6[var8_8 + var16_14]);
                                                        break block11;
lbl22:
                                                        // 1 sources

                                                        while (true) {
                                                            if (var6_6[var8_8 + var16_14] != 0L || Nat.compareNat(var6_6, var8_8 + var17_16, var11_11, var7_7, var9_9, var11_11) >= 0) {
                                                                var13_15 = Nat.addDigit(var13_15, BigInteger.ONE);
                                                                var6_6[var8_8 + var16_14] = Nat.subtractDigit(Nat.createDigit(var6_6[var8_8 + var16_14]), BigInteger.ONE.xor(Nat.createDigit(Nat.subNat(var6_6, var8_8 + var17_16, var11_11, var7_7, var9_9, var11_11, BigInteger.ZERO))).and(Nat.BNG_DIGIT_MASK)).longValue();
                                                                continue;
                                                            }
                                                            break block5;
                                                            break;
                                                        }
                                                    }
                                                    var18_17 = Nat.createDigit(var6_6[var8_8 + var16_14]);
                                                    var19_18 = Nat.createDigit(var6_6[var8_8 + var16_14 - 1]);
                                                    var20_19 = Nat.addDigit(var12_13, BigInteger.ONE);
                                                    var21_20 = var20_19.and(Nat.BNG_LOW_HALF_MASK);
                                                    var22_21 = var20_19.shiftRight(32);
                                                    var23_22 = Nat.divDigit(var18_17, Nat.addDigit(var22_21, BigInteger.ONE));
                                                    var24_23 = var19_18.and(Nat.BNG_LOW_HALF_MASK);
                                                    var25_24 = Nat.multDigit(var23_22, var22_21);
                                                    var26_25 = Nat.multDigit(var23_22, var21_20);
                                                    var18_17 = Nat.subtractDigit(var18_17, var25_24);
                                                    var19_18 = var19_18.shiftRight(32).or(var18_17.shiftLeft(32)).and(Nat.BNG_DIGIT_MASK);
                                                    var18_17 = var18_17.shiftRight(32);
                                                    if (var19_18.compareTo(var26_25) >= 0) break block12;
                                                    v0 = BigInteger.ONE;
                                                    break block13;
lbl44:
                                                    // 2 sources

                                                    while (true) {
                                                        if (var18_17.compareTo(BigInteger.ZERO) == 0 && var19_18.compareTo(var20_19) < 0) break block6;
                                                        break;
                                                    }
                                                }
                                                var6_6[var8_8 + var16_14] = var13_15.longValue();
                                                continue;
                                            }
                                            v0 = BigInteger.ZERO;
                                            break block13;
                                        }
                                        var27_26 = Nat.divDigit(var19_18, Nat.addDigit(var22_21, BigInteger.ONE));
                                        var25_24 = Nat.multDigit(var27_26, var22_21);
                                        var26_25 = Nat.multDigit(var27_26, var21_20);
                                        var19_18 = Nat.subtractDigit(var19_18, var25_24);
                                        var18_17 = var19_18.shiftRight(32);
                                        if ((var19_18 = var19_18.shiftLeft(32).or(var24_23).and(Nat.BNG_DIGIT_MASK)).compareTo(var26_25) >= 0) break block14;
                                        break block15;
                                    }
                                    var18_17 = Nat.subtractDigit(var18_17, v0);
                                    var19_18 = Nat.subtractDigit(var19_18, var26_25);
                                    ** GOTO lbl44
                                }
                                v1 = BigInteger.ONE;
                                break block16;
lbl67:
                                // 2 sources

                                while (true) {
                                    if (var18_17.compareTo(BigInteger.ZERO) == 0 && var19_18.compareTo(var20_19) < 0) break block7;
                                    break;
                                }
                            }
                            v1 = BigInteger.ZERO;
                            break block16;
                        }
                        var13_15 = var23_22.shiftLeft(32).or(var27_26).and(Nat.BNG_DIGIT_MASK);
                        break block11;
                    }
                    var18_17 = Nat.subtractDigit(var18_17, v1);
                    var19_18 = Nat.subtractDigit(var19_18, var26_25);
                    ** GOTO lbl67
                }
                var6_6[var8_8 + var16_14] = Nat.subtractDigit(Nat.createDigit(var6_6[var8_8 + var16_14]), Nat.multSubDigit(var6_6, var8_8 + var17_16, var11_11, var7_7, var9_9, var11_11, var13_15)).longValue();
                ** continue;
                var18_17 = Nat.subtractDigit(var18_17, var19_18.compareTo(var20_19) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                var19_18 = Nat.subtractDigit(var19_18, var20_19);
                var27_26 = Nat.addDigit(var27_26, BigInteger.ONE);
                ** continue;
                var18_17 = Nat.subtractDigit(var18_17, var19_18.compareTo(var20_19) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                var19_18 = Nat.subtractDigit(var19_18, var20_19);
                var23_22 = Nat.addDigit(var23_22, BigInteger.ONE);
                ** continue;
            }
        }
        Nat.shiftRight(var6_6, var8_8, var11_11, var15_12);
        Nat.shiftRight(var7_7, var9_9, var11_11, var15_12);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.div_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        ((long[])value4.asCustom())[value5.asCastedInt()] = Nat.shiftRight((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), value6.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.shift_right_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="int")
    public static Value compare_digits_nat(Value value, Value value2, Value value3, Value value4) {
        BigInteger bigInteger = Nat.createDigit(((long[])value.asCustom())[value2.asCastedInt()]);
        BigInteger bigInteger2 = Nat.createDigit(((long[])value3.asCustom())[value4.asCastedInt()]);
        return Value.createLong(bigInteger.compareTo(bigInteger2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Value.createLong(Nat.compareNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.compare_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value land_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] & ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lor_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] | ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lxor_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] ^ ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    private static int numLeadingZeroBitsInDigit(long l) {
        long l2 = l;
        int n = 64;
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            n -= 32;
            l2 >>>= 32;
        }
        if ((l2 & 0xFFFF0000L) != 0L) {
            n -= 16;
            l2 >>>= 16;
        }
        if ((l2 & 0xFF00L) != 0L) {
            n -= 8;
            l2 >>>= 8;
        }
        if ((l2 & 0xF0L) != 0L) {
            n -= 4;
            l2 >>>= 4;
        }
        if ((l2 & 0xCL) != 0L) {
            n -= 2;
            l2 >>>= 2;
        }
        if ((l2 & 2L) != 0L) {
            --n;
            l2 >>>= 1;
        }
        return n - (int)l2;
    }

    private static int compareNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        block6: {
            int n5;
            block3: {
                block5: {
                    block4: {
                        int n6;
                        int n7 = n;
                        int n8 = n3;
                        int n9 = n4;
                        for (n6 = n2; n6 > 0 && lArray[n7 + n6 - 1] == 0L; --n6) {
                        }
                        while (n9 > 0 && lArray2[n8 + n9 - 1] == 0L) {
                            --n9;
                        }
                        if (n6 > n9) break block4;
                        if (n6 < n9) break block5;
                        while (n6 > 0) {
                            BigInteger bigInteger;
                            BigInteger bigInteger2;
                            if ((n5 = (bigInteger2 = Nat.createDigit(lArray[n7 + --n6])).compareTo(bigInteger = Nat.createDigit(lArray2[n8 + n6]))) == 0) continue;
                            break block3;
                        }
                        break block6;
                    }
                    return 1;
                }
                return -1;
            }
            return n5;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long subNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, BigInteger bigInteger) {
        int n5 = n;
        int n6 = n3;
        int n7 = n2;
        int n8 = n4;
        BigInteger bigInteger2 = BigInteger.ONE.xor(bigInteger).and(BNG_DIGIT_MASK);
        n7 -= n8;
        while (true) {
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            if (n8 > 0) {
                bigInteger5 = Nat.createDigit(lArray[n5]);
                bigInteger4 = Nat.createDigit(lArray2[n6]);
                bigInteger3 = Nat.subtractDigit(bigInteger5, bigInteger4);
                lArray[n5] = Nat.subtractDigit(bigInteger3, bigInteger2).longValue();
            }
            if (bigInteger2.compareTo(BigInteger.ZERO) == 0) return bigInteger.longValue();
            if (n7 == 0) return bigInteger.longValue();
            do {
                int n9 = n5++;
                long l = lArray[n9];
                lArray[n9] = l - 1L;
                if (l != 0L) return 1L;
            } while (--n7 != 0);
            return 0L;
            bigInteger2 = Nat.addDigit(bigInteger5.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger3.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            --n8;
            ++n5;
            ++n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long multDigitNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, long[] lArray3, int n5) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n6 = n2;
        int n7 = n4;
        int n8 = n;
        int n9 = n3;
        BigInteger bigInteger4 = Nat.createDigit(lArray3[n5]);
        n6 -= n7;
        BigInteger bigInteger5 = BigInteger.ZERO;
        while (true) {
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            if (n7 > 0) {
                bigInteger3 = Nat.createDigit(lArray2[n9]);
                bigInteger2 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger4.and(BNG_LOW_HALF_MASK));
                bigInteger8 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger4.shiftRight(32));
                bigInteger7 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger4.and(BNG_LOW_HALF_MASK));
                BigInteger bigInteger9 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger4.shiftRight(32));
                bigInteger6 = Nat.addDigit(bigInteger9, Nat.addDigit(bigInteger8.shiftRight(32), bigInteger7.shiftRight(32)));
            }
            if (n6 == 0) return bigInteger5.longValue();
            bigInteger = BigInteger.ZERO;
            BigInteger bigInteger10 = bigInteger2;
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger8.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger6 = Nat.addDigit(bigInteger6, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = Nat.addDigit(bigInteger11, bigInteger7.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger6 = Nat.addDigit(bigInteger6, bigInteger12.compareTo(bigInteger11) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger13 = bigInteger12;
            bigInteger2 = Nat.createDigit(lArray[n8]);
            bigInteger8 = Nat.addDigit(bigInteger2, bigInteger13);
            bigInteger6 = Nat.addDigit(bigInteger6, bigInteger8.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger7 = Nat.addDigit(bigInteger8, bigInteger5);
            bigInteger6 = Nat.addDigit(bigInteger6, bigInteger7.compareTo(bigInteger8) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n8] = bigInteger7.longValue();
            bigInteger5 = bigInteger6;
            --n7;
            ++n8;
            ++n9;
        }
        bigInteger3 = Nat.createDigit(lArray[n8]);
        bigInteger2 = Nat.addDigit(bigInteger3, bigInteger5);
        bigInteger = bigInteger2.compareTo(bigInteger3) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        lArray[n8] = bigInteger2.longValue();
        ++n8;
        if (bigInteger.compareTo(BigInteger.ZERO) == 0) return bigInteger.longValue();
        if (--n6 == 0) return bigInteger.longValue();
        do {
            int n10 = n8++;
            long l = lArray[n10] + 1L;
            lArray[n10] = l;
            if (l != 0L) return 0L;
        } while (--n6 != 0);
        return 1L;
    }

    private static long shiftLeft(long[] lArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = 64 - n3;
        long l = 0L;
        if (n3 > 0) {
            int n6 = n2;
            while (n6 > 0) {
                long l2 = lArray[n4];
                lArray[n4] = l2 << n3 | l;
                l = l2 >>> n5;
                --n6;
                ++n4;
            }
        }
        return l;
    }

    private static long shiftRight(long[] lArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 64 - n3;
        long l = 0L;
        if (n3 > 0) {
            int n6 = n + n4 - 1;
            while (n4 > 0) {
                long l2 = lArray[n6];
                lArray[n6] = l2 >>> n3 | l;
                l = l2 << n5;
                --n4;
                --n6;
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static BigInteger divRemNormDigit(long[] lArray, int n, long[] lArray2, int n2, int n3, BigInteger bigInteger) {
        BigInteger bigInteger2 = Nat.createDigit(lArray2[n2 + n3 - 1]);
        int n4 = n3 - 2;
        block0: while (n4 >= 0) {
            BigInteger bigInteger3 = bigInteger2;
            BigInteger bigInteger4 = Nat.createDigit(lArray2[n2 + n4]);
            BigInteger bigInteger5 = bigInteger.and(BNG_LOW_HALF_MASK);
            BigInteger bigInteger6 = bigInteger.shiftRight(32);
            BigInteger bigInteger7 = Nat.divDigit(bigInteger3, Nat.addDigit(bigInteger6, BigInteger.ONE));
            BigInteger bigInteger8 = bigInteger4.and(BNG_LOW_HALF_MASK);
            BigInteger bigInteger9 = Nat.multDigit(bigInteger7, bigInteger6);
            BigInteger bigInteger10 = Nat.multDigit(bigInteger7, bigInteger5);
            bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger9);
            bigInteger4 = bigInteger4.shiftRight(32).or(bigInteger3.shiftLeft(32)).and(BNG_DIGIT_MASK);
            bigInteger3 = bigInteger3.shiftRight(32);
            bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger10);
            while (true) {
                if (bigInteger3.compareTo(BigInteger.ZERO) == 0 && bigInteger4.compareTo(bigInteger) < 0) break;
                bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger);
                bigInteger7 = Nat.addDigit(bigInteger7, BigInteger.ONE);
            }
            BigInteger bigInteger11 = Nat.divDigit(bigInteger4, bigInteger6.add(BigInteger.ONE));
            bigInteger9 = Nat.multDigit(bigInteger11, bigInteger6);
            bigInteger10 = Nat.multDigit(bigInteger11, bigInteger5);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger9);
            bigInteger3 = bigInteger4.shiftRight(32);
            bigInteger3 = Nat.subtractDigit(bigInteger3, (bigInteger4 = bigInteger4.shiftLeft(32).or(bigInteger8).and(BNG_DIGIT_MASK)).compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger10);
            while (true) {
                block4: {
                    if (bigInteger3.compareTo(BigInteger.ZERO) == 0 && bigInteger4.compareTo(bigInteger) < 0) break block4;
                }
                BigInteger bigInteger12 = bigInteger7.shiftLeft(32).or(bigInteger11).and(BNG_DIGIT_MASK);
                BigInteger bigInteger13 = bigInteger4;
                lArray[n + n4] = bigInteger12.longValue();
                bigInteger2 = bigInteger13;
                --n4;
                continue block0;
                bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger);
                bigInteger11 = Nat.addDigit(bigInteger11, BigInteger.ONE);
            }
            break;
        }
        return bigInteger2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static BigInteger multSubDigit(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n5 = n2;
        int n6 = n4;
        int n7 = n;
        int n8 = n3;
        n5 -= n6;
        BigInteger bigInteger4 = BigInteger.ZERO;
        while (true) {
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            if (n6 > 0) {
                bigInteger3 = Nat.createDigit(lArray2[n8]);
                bigInteger2 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger.and(BNG_LOW_HALF_MASK));
                bigInteger8 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger.shiftRight(32));
                bigInteger7 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger.and(BNG_LOW_HALF_MASK));
                bigInteger6 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger.shiftRight(32));
                bigInteger5 = Nat.addDigit(bigInteger6, Nat.addDigit(bigInteger8.shiftRight(32), bigInteger7.shiftRight(32)));
            }
            if (n5 == 0) return bigInteger4;
            bigInteger3 = Nat.createDigit(lArray[n7]);
            bigInteger2 = bigInteger4;
            lArray[n7] = Nat.subtractDigit(bigInteger3, bigInteger2).longValue();
            BigInteger bigInteger9 = bigInteger2;
            BigInteger bigInteger10 = Nat.addDigit(bigInteger9, bigInteger8.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger5 = Nat.addDigit(bigInteger5, bigInteger10.compareTo(bigInteger9) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger7.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger5 = Nat.addDigit(bigInteger5, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = bigInteger11;
            bigInteger2 = Nat.createDigit(lArray[n7]);
            bigInteger8 = bigInteger12;
            bigInteger7 = bigInteger4;
            bigInteger6 = Nat.subtractDigit(bigInteger2, bigInteger8);
            lArray[n7] = Nat.subtractDigit(bigInteger6, bigInteger7).longValue();
            bigInteger4 = bigInteger5 = Nat.addDigit(bigInteger5, Nat.addDigit(bigInteger2.compareTo(bigInteger8) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger6.compareTo(bigInteger7) < 0 ? BigInteger.ONE : BigInteger.ZERO));
            --n6;
            ++n7;
            ++n8;
        }
        BigInteger bigInteger13 = bigInteger3.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        ++n7;
        if (bigInteger13.compareTo(BigInteger.ZERO) == 0) return bigInteger13;
        if (--n5 == 0) return bigInteger13;
        do {
            int n9 = n7++;
            long l = lArray[n9];
            lArray[n9] = l - 1L;
            if (l != 0L) return BigInteger.ZERO;
        } while (--n5 != 0);
        return BigInteger.ONE;
    }

    private static BigInteger createDigit(long l) {
        byte[] byArray = new byte[8];
        long l2 = l;
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return new BigInteger(1, byArray);
    }

    private static BigInteger addDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger multDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger subtractDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger divDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }
}

