/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.MurmurHash3;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Hashtbl", source="byterun/hash.c")
public final class Hash {
    private static final long QUEUE_SIZE = 256L;

    private Hash() {
    }

    public static int caml_hash_mix_uint32(int n, int n2) {
        return MurmurHash3.mix32(n, n2);
    }

    public static int caml_hash_mix_intnat(int n, long l) {
        int n2 = (int)(l >> 32 ^ l >> 63 ^ l);
        return MurmurHash3.mix32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int caml_hash_mix_int64(int n, long l) {
        int n2 = PlatformUtils.isBigEndianPlatform() ? (int)(l & 0xFFFFFFFFL) : (int)(l >>> 32);
        int n3 = PlatformUtils.isBigEndianPlatform() ? (int)(l >>> 32) : (int)(l & 0xFFFFFFFFL);
        int n4 = MurmurHash3.mix32(n, n3);
        return MurmurHash3.mix32(n4, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int caml_hash_mix_double(int n, double d) {
        int n2;
        long l = Double.doubleToRawLongBits(d);
        int n3 = PlatformUtils.isBigEndianPlatform() ? (int)(l & 0xFFFFFFFFL) : (int)(l >>> 32);
        int n4 = n2 = PlatformUtils.isBigEndianPlatform() ? (int)(l >>> 32) : (int)(l & 0xFFFFFFFFL);
        if ((n3 & 0x7FF00000) == 0x7FF00000 && (n2 | n3 & 0xFFFFF) != 0) {
            n3 = 0x7FF00000;
            n2 = 1;
        } else if (n3 == Integer.MIN_VALUE && n2 == 0) {
            n3 = 0;
        }
        int n5 = MurmurHash3.mix32(n, n2);
        return MurmurHash3.mix32(n5, n3);
    }

    public static int caml_hash_mix_float(int n, float f) {
        int n2 = Float.floatToRawIntBits(f);
        if ((n2 & 0x7F800000) == 2139095040 && (n2 & 0x7FFFFF) != 0) {
            n2 = 2139095041;
        } else if (n2 == Integer.MIN_VALUE) {
            n2 = 0;
        }
        return MurmurHash3.mix32(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int caml_hash_mix_string(int n, Value value) {
        int n2;
        int[] nArray = value.getUnsignedBytes();
        int n3 = nArray.length;
        int n4 = n;
        int n5 = 0;
        while (n5 + 4 <= n3) {
            n2 = nArray[n5] | nArray[n5 + 1] << 8 | nArray[n5 + 2] << 16 | nArray[n5 + 3] << 24;
            n4 = MurmurHash3.mix32(n4, n2);
            n5 += 4;
        }
        switch (n3 & 3) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = nArray[n5];
                break;
            }
            case 2: {
                n2 = nArray[n5] | nArray[n5 + 1] << 8;
                break;
            }
            case 3: {
                n2 = nArray[n5] | nArray[n5 + 1] << 8 | nArray[n5 + 2] << 16;
                break;
            }
            default: {
                assert (false) : "should not happen";
                n2 = 0;
            }
        }
        if (n2 == 0) return n4 ^ n3;
        n4 = MurmurHash3.mix32(n4, n2);
        return n4 ^ n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "'a"}, returnType="int")
    public static Value caml_hash(Value value, Value value2, Value value3, Value value4) {
        Value[] valueArray = new Value[256];
        long l = value2.asLong();
        int n = l < 0L || l > 256L ? 256 : (int)l;
        long l2 = value.asLong();
        int n2 = value3.asCastedInt();
        valueArray[0] = value4;
        int n3 = 0;
        int n4 = 1;
        boolean bl = false;
        Value value5 = null;
        block10: while (n3 < n4 && l2 > 0L) {
            long l3;
            long l4;
            if (bl) {
                bl = false;
            } else {
                value5 = valueArray[n3++];
            }
            if (value5.isLong()) {
                n2 = Hash.caml_hash_mix_intnat(n2, value5.getRawValue());
                --l2;
                continue;
            }
            int n5 = value5.getTag();
            switch (n5) {
                case 251: {
                    continue block10;
                }
                case 252: {
                    n2 = Hash.caml_hash_mix_string(n2, value5);
                    --l2;
                    continue block10;
                }
                case 253: {
                    n2 = Hash.caml_hash_mix_double(n2, value5.asDouble());
                    --l2;
                    continue block10;
                }
                case 254: {
                    l4 = value5.sizeDoubles();
                    for (l3 = 0L; l3 < l4; ++l3) {
                        n2 = Hash.caml_hash_mix_double(n2, value5.getDouble(l3));
                        if (--l2 < 0L) continue block10;
                    }
                    continue block10;
                }
                case 249: {
                    n2 = Hash.caml_hash_mix_uint32(n2, (int)(value5.getWoSize() * 8L));
                    value5 = value5.getParent();
                    bl = true;
                    continue block10;
                }
                case 250: {
                    value5 = value5.get0();
                    bl = true;
                    continue block10;
                }
                case 248: {
                    n2 = Hash.caml_hash_mix_intnat(n2, value5.get1().asLong());
                    --l2;
                    continue block10;
                }
                case 255: {
                    CustomOperations customOperations = value4.getCustomOperations();
                    if (!customOperations.isHashable()) continue block10;
                    n2 = Hash.caml_hash_mix_uint32(n2, (int)customOperations.hash(value5));
                    --l2;
                    continue block10;
                }
            }
            n2 = Hash.caml_hash_mix_uint32(n2, (int)value5.getHeader());
            l4 = value5.sizeValues();
            for (l3 = 0L; l3 < l4 && n4 < n; ++l3) {
                valueArray[n4++] = value5.get(l3);
            }
        }
        n2 = MurmurHash3.finalMix32(n2);
        return Value.createLong(n2 & 0x3FFFFFFF);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "'a"}, returnType="int")
    public static Value caml_hash_univ_param(Value value, Value value2, Value value3) {
        HashParams hashParams = new HashParams(value2.asLong(), value.asLong());
        Hash.hashVal(value3, hashParams, true);
        return Value.createLong(hashParams.get());
    }

    public static Value hashVariant(String string) {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(string.charAt(i)));
            l = 223L * (l >> 1) + (long)n2 << 1;
        }
        return Value.createLong((l &= 0xFFFFFFFEL) >> 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void hashVal(Value var0, HashParams var1_1, boolean var2_2) {
        block14: {
            if (!var2_2) break block14;
            HashParams.access$200(var1_1);
            if (HashParams.access$300(var1_1)) ** GOTO lbl-1000
        }
        if (!var0.isLong()) {
            var3_3 = var0.getTag();
            switch (var3_3) {
                case 252: {
                    HashParams.access$400(var1_1);
                    var4_4 = var0.getBytes();
                    var5_5 = var4_4.length;
                    for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
                        HashParams.access$600(var1_1, IntegerUtils.signedToUnsignedByte(var4_4[var6_6]));
                    }
                    break;
                }
                case 253: {
                    HashParams.access$400(var1_1);
                    Hash.hashDouble(var0.asDouble(), var1_1);
                    break;
                }
                case 254: {
                    HashParams.access$400(var1_1);
                    var6_7 = var0.sizeDoubles();
                    for (var8_8 = 0L; var8_8 < var6_7; ++var8_8) {
                        Hash.hashDouble(var0.getDouble(var8_8), var1_1);
                    }
                    break;
                }
                case 249: {
                    Hash.hashVal(var0.getParent(), var1_1, true);
                    break;
                }
                case 248: {
                    HashParams.access$400(var1_1);
                    HashParams.access$500(var1_1, var0.get1().asLong());
                    break;
                }
                case 255: {
                    var8_9 = var0.getCustomOperations();
                    if (!var8_9.isHashable()) break;
                    HashParams.access$400(var1_1);
                    HashParams.access$500(var1_1, var8_9.hash(var0));
                    break;
                }
                default: {
                    HashParams.access$400(var1_1);
                    HashParams.access$600(var1_1, var3_3);
                    var9_10 = var0.sizeValues();
                    for (var11_11 = var9_10 - 1L; var11_11 >= 0L; --var11_11) {
                        Hash.hashVal(var0.get(var11_11), var1_1, true);
                    }
                    break;
                }
            }
        }
        ** GOTO lbl50
lbl-1000:
        // 1 sources

        {
            return;
lbl50:
            // 1 sources

            HashParams.access$400(var1_1);
            HashParams.access$500(var1_1, var0.asLong());
            return;
            case 250: {
                Hash.hashVal(var0.get0(), var1_1, false);
                return;
            }
            ** case 251:
        }
lbl57:
        // 9 sources

    }

    private static void hashDouble(double d, HashParams hashParams) {
        long l = Double.doubleToRawLongBits(d);
        for (int i = 0; i < 8; ++i) {
            hashParams.combineSmall((int)(l >> i * 8 & 0xFFL));
        }
    }

    private static final class HashParams {
        private static final long ALPHA = 65599L;
        private static final long BETA = 19L;
        private long accu = 0L;
        private long limit;
        private long count;

        private HashParams(long l, long l2) {
            this.limit = l;
            this.count = l2;
        }

        private boolean stopHashing() {
            return this.count < 0L || this.limit < 0L;
        }

        private void decrementCount() {
            --this.count;
        }

        private void decrementLimit() {
            --this.limit;
        }

        private void combineSmall(int n) {
            this.accu = this.accu * 19L + (long)n;
        }

        private void combine(long l) {
            this.accu = this.accu * 65599L + l;
        }

        private int get() {
            return (int)(this.accu & 0x3FFFFFFFL);
        }

        static /* synthetic */ void access$200(HashParams hashParams) {
            hashParams.decrementLimit();
        }

        static /* synthetic */ boolean access$300(HashParams hashParams) {
            return hashParams.stopHashing();
        }

        static /* synthetic */ void access$400(HashParams hashParams) {
            hashParams.decrementCount();
        }

        static /* synthetic */ void access$500(HashParams hashParams, long l) {
            hashParams.combine(l);
        }
    }
}

