/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.ComposedWrapper;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlList<T extends OCamlValue>
extends OCamlValue
implements Iterable<T> {
    private final Wrapper<T> wrapper;

    private OCamlList(Wrapper<T> wrapper, Value value) {
        super(value);
        assert (wrapper != null) : "null w";
        this.wrapper = wrapper;
    }

    public Wrapper<? extends OCamlList<T>> getWrapper() {
        return OCamlList.wrapper(this.wrapper);
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        switch (n) {
            case 0: {
                return this.wrapper;
            }
        }
        return OCamlUnit.WRAPPER;
    }

    public boolean isEmpty() {
        return this.value.isLong();
    }

    public long length() {
        long l = 0L;
        Value value = this.value;
        while (value.isBlock()) {
            ++l;
            value = value.get1();
        }
        return l;
    }

    public T head() {
        if (this.value.isBlock()) {
            return this.wrapper.wrap(this.value.get0());
        }
        return null;
    }

    public OCamlList<T> tail() {
        if (this.value.isBlock()) {
            return new OCamlList<T>(this.wrapper, this.value.get1());
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Value next;
            {
                this.next = OCamlList.this.value;
            }

            @Override
            public boolean hasNext() {
                return this.next.isBlock();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Value value = this.next.get0();
                    this.next = this.next.get1();
                    return OCamlList.this.wrapper.wrap(value);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlList) {
            OCamlList oCamlList = (OCamlList)object;
            return this == oCamlList;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlList(");
        Value value = this.value;
        while (value.isBlock() && stringBuilder.length() < 256) {
            if (value != this.value) {
                stringBuilder.append(", ");
            }
            Value value2 = value.get0();
            value = value.get1();
            T t = this.wrapper.wrap(value2);
            stringBuilder.append(((OCamlValue)t).toString());
        }
        if (value.isBlock()) {
            stringBuilder.append("...");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static <T extends OCamlValue> OCamlList<T> create(Wrapper<T> wrapper, List<T> list) {
        assert (wrapper != null) : "null w";
        assert (list != null) : "null v";
        Value value = Value.EMPTY_LIST;
        ListIterator<T> listIterator = list.listIterator(list.size());
        OCamlValue oCamlValue = null;
        while (listIterator.hasPrevious()) {
            oCamlValue = (OCamlValue)listIterator.previous();
            value = Value.createBlock(0, oCamlValue.value(), value);
        }
        return new OCamlList<T>(wrapper, value);
    }

    public static <T extends OCamlValue> OCamlList<T> create(List<T> list) {
        assert (list != null) : "null v";
        if (list.size() == 0) {
            return OCamlList.create(OCamlUnit.WRAPPER, list);
        }
        return OCamlList.create(((OCamlValue)list.get(0)).getWrapper(), list);
    }

    public static <T extends OCamlValue> OCamlList<T> create(Wrapper<T> wrapper) {
        assert (wrapper != null) : "null w";
        return new OCamlList<T>(wrapper, Value.EMPTY_LIST);
    }

    public static <T extends OCamlValue> OCamlList<T> create(T t, OCamlList<T> oCamlList) {
        assert (t != null) : "null hd";
        assert (oCamlList != null) : "null tl";
        Value value = Value.createBlock(0, t.value(), oCamlList.value());
        return new OCamlList<OCamlValue>(t.getWrapper(), value);
    }

    public static <T extends OCamlValue> OCamlList<T> wrap(Wrapper<T> wrapper, Value value) {
        assert (wrapper != null) : "null w";
        assert (value != null) : "null v";
        return new OCamlList<T>(wrapper, value);
    }

    public static <T extends OCamlValue> Wrapper<? extends OCamlList<T>> wrapper(final Wrapper<T> wrapper) {
        return new ComposedWrapper<OCamlList<T>>(new Wrapper[]{wrapper}){

            @Override
            public OCamlList<T> wrap(Value value) {
                return new OCamlList(wrapper, value);
            }
        };
    }
}

