/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.SwankFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.filechooser.FileSystemView;
import tcl.lang.Interp;
import tcl.lang.TclException;

public class SwankAltFileSystemView
extends FileSystemView {
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    private static Method listRootsMethod = null;
    private static boolean listRootsMethodChecked = false;
    private boolean smode = false;
    private boolean debug = false;
    Interp interp = null;

    public SwankAltFileSystemView(Interp interp) {
        this.interp = interp;
    }

    public File createFileObject(File dir, String filename) {
        return new SwankFile(this.interp, dir.getPath(), filename);
    }

    public File createFileObject(String path) {
        return new SwankFile(this.interp, path);
    }

    public File createNewFolder(File containingDir) throws IOException {
        SwankFile result = new SwankFile(this.interp, containingDir.getPath() + "/NewFolder");
        if (result.mkdir()) {
            return result;
        }
        return null;
    }

    public File getDefaultDirectory() {
        if (this.smode) {
            return super.getDefaultDirectory();
        }
        try {
            this.interp.eval("::fileSystemView::getDefaultDirectory");
        }
        catch (TclException tclE) {
            return null;
        }
        return new SwankFile(this.interp, this.interp.getResult().toString());
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        if (this.debug) {
            System.out.println("getFiles " + dir);
        }
        if (this.smode) {
            return super.getFiles(dir, useFileHiding);
        }
        if (dir instanceof SwankFile) {
            if (this.debug) {
                System.out.println("getFiles sk " + dir.getName());
            }
            return ((SwankFile)dir).listFiles();
        }
        if (this.debug) {
            System.out.println("getFiles nk " + dir.getName());
        }
        return new SwankFile(this.interp, dir.getPath()).listFiles();
    }

    public File getHomeDirectory() {
        if (this.smode) {
            return super.getHomeDirectory();
        }
        try {
            this.interp.eval("::fileSystemView::getHomeDirectory");
        }
        catch (TclException tclE) {
            return null;
        }
        return new SwankFile(this.interp, this.interp.getResult().toString());
    }

    public File getParentDirectory(File dir) {
        if (this.debug) {
            System.out.println("getParent " + dir.getName());
        }
        if (this.smode) {
            return super.getParentDirectory(dir);
        }
        String p = dir.getParent();
        if (p == null) {
            return null;
        }
        return new SwankFile(this.interp, p);
    }

    public File[] getRoots() {
        if (this.debug) {
            System.out.println("getRoots");
        }
        if (this.smode) {
            return super.getRoots();
        }
        return new SwankFile[]{new SwankFile(this.interp, "/")};
    }

    public String getSystemDisplayName(File f) {
        if (this.debug) {
            System.out.println("getSystemDisplayName " + f.toString());
        }
        return f.getName();
    }

    public String getSystemTypeDescription(File f) {
        if (this.debug) {
            System.out.println("getSystemTypeDescription " + f.toString());
        }
        return f.getName();
    }

    public boolean isComputerNode(File dir) {
        if (this.debug) {
            System.out.println("isCN " + dir);
        }
        boolean isComputerNode = false;
        isComputerNode = this.smode ? super.isComputerNode(dir) : false;
        if (this.debug) {
            System.out.println("isComputerNode " + isComputerNode);
        }
        return isComputerNode;
    }

    public boolean isDrive(File dir) {
        if (this.debug) {
            System.out.println("isDrive " + dir);
        }
        boolean isDrive = false;
        isDrive = this.smode ? super.isDrive(dir) : false;
        if (this.debug) {
            System.out.println("isDrive " + isDrive);
        }
        return isDrive;
    }

    public boolean isFileSystem(File dir) {
        if (this.debug) {
            System.out.println("isFS " + dir);
        }
        boolean isFileSystem = false;
        isFileSystem = this.smode ? super.isFileSystem(dir) : false;
        if (this.debug) {
            System.out.println("isFileSystem " + isFileSystem);
        }
        return isFileSystem;
    }

    public boolean isFileSystemRoot(File dir) {
        if (this.debug) {
            System.out.println("isFSRoot " + dir);
        }
        boolean isFileSystemRoot = false;
        isFileSystemRoot = this.smode ? super.isFileSystemRoot(dir) : false;
        if (this.debug) {
            System.out.println("isFileSystemRoot " + isFileSystemRoot);
        }
        return isFileSystemRoot;
    }

    public boolean isFloppyDrive(File dir) {
        if (this.debug) {
            System.out.println("isFloppyDrive " + dir);
        }
        boolean isFloppyDrive = false;
        isFloppyDrive = this.smode ? super.isFloppyDrive(dir) : false;
        if (this.debug) {
            System.out.println("isFloppyDrive " + isFloppyDrive);
        }
        return isFloppyDrive;
    }

    public boolean isHiddenFile(File f) {
        boolean isHiddenFile = false;
        isHiddenFile = this.smode ? super.isHiddenFile(f) : false;
        if (this.debug) {
            System.out.println("isHiddenFile " + isHiddenFile);
        }
        return isHiddenFile;
    }

    public boolean isParent(File folder, File file) {
        if (this.debug) {
            System.out.println("isParent " + folder + " " + file);
        }
        boolean isParent = false;
        isParent = this.smode ? super.isParent(folder, file) : false;
        if (this.debug) {
            System.out.println("isParent " + isParent);
        }
        return isParent;
    }

    public boolean isRoot(File f) {
        if (this.debug) {
            System.out.println("isRoot");
        }
        boolean isRoot = false;
        isRoot = this.smode ? super.isRoot(f) : f instanceof SwankFile && f.getParent() == null && f.getName().length() == 0;
        if (this.debug) {
            System.out.println("isRoot " + isRoot);
        }
        return isRoot;
    }

    public Boolean isTraversable(File f) {
        if (this.debug) {
            System.out.println("isTravers " + f.getPath());
        }
        Boolean isTraversable = this.smode ? super.isTraversable(f) : new Boolean(true);
        if (this.debug) {
            System.out.println("isTraversable " + isTraversable);
        }
        return isTraversable;
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

