/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkFileFilter;
import com.onemoonscientific.swank.SwkJFileChooser;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.io.File;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJFileChooserWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"configure", "cget", "open", "save", "filter"};
    private static final int OPT_CONFIGURE = 0;
    private static final int OPT_CGET = 1;
    private static final int OPT_OPEN = 2;
    private static final int OPT_SAVE = 3;
    private static final int OPT_FILTER = 4;
    static boolean gotDefaults = false;

    SwkJFileChooserWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJFileChooser swkjfilechooser = (SwkJFileChooser)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjfilechooser.jget(interp, argv[2]));
                break;
            }
            case 0: {
                if (!gotDefaults) {
                    swkjfilechooser.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjfilechooser.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjfilechooser.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJFileChooser.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjfilechooser.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.open(interp, swkjfilechooser, argv);
                break;
            }
            case 3: {
                this.save(interp, swkjfilechooser, argv);
                break;
            }
            case 4: {
                this.filter(interp, swkjfilechooser, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void open(Interp interp, SwkJFileChooser swkjfilechooser, TclObject[] argv) throws TclException {
        File[] files;
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        String dialogParent = swkjfilechooser.getDialogParent();
        Component dParent = null;
        if (dialogParent != null && dialogParent.length() != 0) {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, dialogParent);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + dialogParent + "\"");
            }
            dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
        }
        if ((files = new Open().exec(swkjfilechooser, dParent)) != null) {
            if (swkjfilechooser.isMultiSelectionEnabled()) {
                TclObject list = TclList.newInstance();
                try {
                    for (int iFile = 0; iFile < files.length; ++iFile) {
                        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)files[iFile].getAbsolutePath()));
                    }
                }
                catch (TclException tclE) {
                    // empty catch block
                }
                interp.setResult(list);
            } else {
                interp.setResult(files[0].getAbsolutePath());
            }
        } else {
            interp.resetResult();
        }
    }

    void save(Interp interp, SwkJFileChooser swkjfilechooser, TclObject[] argv) throws TclException {
        File file;
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        String dialogParent = swkjfilechooser.getDialogParent();
        Component dParent = null;
        if (dialogParent != null && dialogParent.length() != 0) {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, dialogParent);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + dialogParent + "\"");
            }
            dParent = (Component)ReflectObject.get((Interp)interp, (TclObject)tObj);
        }
        if ((file = new Save().exec(swkjfilechooser, dParent)) != null) {
            interp.setResult(file.getAbsolutePath());
        }
    }

    void filter(Interp interp, SwkJFileChooser swkjfilechooser, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        SwkFileFilter filter = new SwkFileFilter(interp, argv[2], argv[3].toString());
        new Filter().exec(swkjfilechooser, filter);
    }

    class Filter
    extends UpdateOnEventThread {
        SwkFileFilter filter = null;
        SwkJFileChooser swkjfilechooser = null;

        Filter() {
        }

        void exec(SwkJFileChooser swkjfilechooser, SwkFileFilter filter) {
            this.swkjfilechooser = swkjfilechooser;
            this.filter = filter;
            this.execOnThread();
        }

        public void run() {
            this.swkjfilechooser.addChoosableFileFilter(this.filter);
        }
    }

    class Save
    extends GetValueOnEventThread {
        int index = -1;
        String item = null;
        SwkJFileChooser swkjfilechooser;
        Component dParent = null;
        File file = null;

        Save() {
        }

        File exec(SwkJFileChooser swkjfilechooser, Component dParent) {
            this.swkjfilechooser = swkjfilechooser;
            this.dParent = dParent;
            this.execOnThread();
            return this.file;
        }

        public void run() {
            this.swkjfilechooser.setVisible(true);
            int soption = this.swkjfilechooser.showSaveDialog(this.dParent);
            if (soption == 0) {
                this.file = this.swkjfilechooser.getSelectedFile();
            }
        }
    }

    class Open
    extends GetValueOnEventThread {
        int index = -1;
        String item = null;
        SwkJFileChooser swkjfilechooser;
        Component dParent = null;
        File[] files = null;

        Open() {
        }

        File[] exec(SwkJFileChooser swkjfilechooser, Component dParent) {
            this.swkjfilechooser = swkjfilechooser;
            this.dParent = dParent;
            this.execOnThread();
            return this.files;
        }

        public void run() {
            this.swkjfilechooser.setVisible(true);
            int option = this.swkjfilechooser.showOpenDialog(this.dParent);
            if (option == 0) {
                if (this.swkjfilechooser.isMultiSelectionEnabled()) {
                    this.files = this.swkjfilechooser.getSelectedFiles();
                } else if (this.swkjfilechooser.getSelectedFile() != null) {
                    this.files = new File[1];
                    this.files[0] = this.swkjfilechooser.getSelectedFile();
                }
            }
        }
    }
}

