/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemArc;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.geom.Arc2D;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class AngleStartParameter
extends CanvasParameter {
    private static String name = "start";
    private static double defValue = 0.0;
    private double newValue = defValue;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-start".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        if (swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            return TclDouble.newInstance((double)arc2D.getAngleStart());
        }
        throw new TclException(interp, "shape not arc");
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = TclDouble.get((Interp)interp, (TclObject)arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape == null) {
            return;
        }
        if (swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            arc2D.setAngleStart(this.newValue);
            swkShape.applyCoordinates();
        }
    }
}

